/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class MakhaiModel<T extends LivingEntity>
extends HumanoidModel<T> {
    public static final ModelLayerLocation MAKHAI_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"makhai"), "makhai");
    protected final ModelPart leftHead;
    public final ModelPart frontRightArm;
    public final ModelPart backRightArm;
    public final ModelPart frontLeftArm;
    public final ModelPart backLeftArm;

    public MakhaiModel(ModelPart root) {
        super(root);
        this.leftHead = root.getChild("left_head");
        this.frontRightArm = root.getChild("front_right_arm");
        this.backRightArm = root.getChild("back_right_arm");
        this.frontLeftArm = root.getChild("front_left_arm");
        this.backLeftArm = root.getChild("back_left_arm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0436f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)-4.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
        partdefinition.addOrReplaceChild("front_right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)2.0f, (float)0.0f, (float)-1.1345f, (float)0.5236f, (float)-0.1745f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, 0.0f, -3.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)2.0f, (float)0.0f, (float)1.1345f, (float)-1.4835f, (float)-0.48f));
        partdefinition.addOrReplaceChild("back_right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)2.0f, (float)0.0f, (float)1.0908f, (float)0.5672f, (float)0.9163f));
        partdefinition.addOrReplaceChild("front_left_arm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-1.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)5.0f, (float)3.0f, (float)0.0f, (float)-0.6109f, (float)-0.3491f, (float)-0.1745f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)2.0f, (float)0.0f, (float)1.0908f, (float)1.3963f, (float)0.2182f));
        partdefinition.addOrReplaceChild("back_left_arm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(0.0f, -1.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)2.0f, (float)0.0f, (float)0.7854f, (float)0.0873f, (float)-0.0873f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    protected Iterable<ModelPart> headParts() {
        return Iterables.concat((Iterable)super.headParts(), (Iterable)ImmutableList.of((Object)this.leftHead));
    }

    protected Iterable<ModelPart> bodyParts() {
        return Iterables.concat((Iterable)super.bodyParts(), (Iterable)ImmutableList.of((Object)this.backLeftArm, (Object)this.frontLeftArm, (Object)this.backRightArm, (Object)this.frontRightArm));
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.head.setPos(-4.0f, 0.0f, 0.0f);
        this.leftHead.xRot = this.head.xRot;
        this.leftHead.yRot = this.head.yRot * -1.0f + (float)Math.PI;
        this.leftHead.zRot = this.head.zRot + 0.1309f;
        float x = this.rightArm.xRot * 0.85f;
        float y = this.rightArm.yRot * 0.85f;
        float z = this.rightArm.zRot * 0.85f;
        this.backRightArm.xRot = -x + 1.1345f;
        this.backRightArm.yRot = -y + -1.5272f;
        this.backRightArm.zRot = -z + -0.48f;
        this.rightArm.xRot += -1.1345f;
        this.rightArm.yRot += 0.5236f;
        this.rightArm.zRot += -0.1745f;
        this.frontRightArm.xRot = x + 1.0908f;
        this.frontRightArm.yRot = y + 0.5672f;
        this.frontRightArm.zRot = z + 0.9163f;
        x = this.leftArm.xRot * 0.85f;
        y = this.leftArm.yRot * 0.85f;
        z = this.leftArm.zRot * 0.85f;
        this.frontLeftArm.xRot = x + 1.0908f;
        this.frontLeftArm.yRot = y + 1.3963f;
        this.frontLeftArm.zRot = z + 0.2182f;
        this.leftArm.setPos(5.0f, 3.0f, 0.0f);
        this.leftArm.xRot += -0.6109f;
        this.leftArm.yRot += -0.3491f;
        this.leftArm.zRot += -0.1745f;
        this.backLeftArm.xRot = -x + 0.7854f;
        this.backLeftArm.yRot = -y + 0.0873f;
        this.backLeftArm.zRot = -z + -0.0873f;
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(entityIn, limbSwing, limbSwingAmount, partialTick);
    }
}

