/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import greekfantasy.client.entity.model.GFModelUtil;
import greekfantasy.client.entity.model.HoofedHumanoidModel;
import greekfantasy.entity.monster.Minotaur;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class MinotaurModel<T extends Minotaur>
extends HoofedHumanoidModel<T> {
    public static final ModelLayerLocation MINOTAUR_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"minotaur"), "minotaur");

    public MinotaurModel(ModelPart root) {
        super(root, true, false);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HoofedHumanoidModel.createMesh(CubeDeformation.NONE);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = GFModelUtil.addOrReplaceBullHead(partdefinition, "head", 58, 48);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.head.setPos(0.0f, 0.0f, 0.0f);
        if (((Minotaur)((Object)entity)).isCharging()) {
            float stompSpeed = 0.58f;
            float limbSwingSin = Mth.cos((float)(ageInTicks * 0.58f + (float)Math.PI));
            float limbSwingCos = Mth.cos((float)(ageInTicks * 0.58f)) * 0.75f;
            float rightLegSwing = 0.38f * limbSwingSin;
            float leftLegSwing = 0.38f * limbSwingCos;
            this.rightLegUpper.xRot = -0.2618f + limbSwingSin * 0.42f;
            this.leftLegUpper.xRot = -0.2618f + limbSwingCos * 0.42f;
            this.rightLegLower.xRot = 0.7854f + rightLegSwing;
            this.rightHoof.xRot = -0.5236f - rightLegSwing;
            this.leftLegLower.xRot = 0.7854f + leftLegSwing;
            this.leftHoof.xRot = -0.5236f - leftLegSwing;
            this.head.xRot = 0.558f;
        }
    }
}

