/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import greekfantasy.client.entity.model.BigCatModel;
import greekfantasy.entity.boss.NemeanLion;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class NemeanLionModel<T extends NemeanLion>
extends BigCatModel<T> {
    public static final ModelLayerLocation NEMEAN_LION_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"lion"), "lion");
    protected final ModelPart mouth;

    public NemeanLionModel(ModelPart root) {
        super(root);
        this.mouth = this.head.getChild("mouth");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = BigCatModel.createBodyMesh(CubeDeformation.NONE);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(29, 0).addBox(-4.0f, -17.0f, -3.0f, 8.0f, 11.0f, 7.0f, CubeDeformation.NONE).texOffs(35, 19).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 8.0f, 6.0f, CubeDeformation.NONE).texOffs(0, 34).addBox(-5.0f, -19.0f, -4.0f, 10.0f, 4.0f, 10.0f, CubeDeformation.NONE).texOffs(20, 36).addBox(5.0f, -18.0f, -3.0f, 1.0f, 2.0f, 8.0f, CubeDeformation.NONE).texOffs(2, 36).addBox(-6.0f, -18.0f, -3.0f, 1.0f, 2.0f, 8.0f, CubeDeformation.NONE).texOffs(9, 43).addBox(-4.0f, -18.0f, 6.0f, 8.0f, 2.0f, 1.0f, CubeDeformation.NONE).texOffs(13, 43).addBox(-4.0f, -18.0f, -5.0f, 8.0f, 2.0f, 1.0f, CubeDeformation.NONE).texOffs(17, 43).addBox(-3.0f, -15.0f, 4.0f, 6.0f, 1.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)8.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(2, 2).addBox(-3.5f, -3.0f, -3.0f, 7.0f, 7.0f, 4.0f, CubeDeformation.NONE).texOffs(0, 13).addBox(-2.5f, 0.0f, -5.0f, 5.0f, 3.0f, 2.0f, CubeDeformation.NONE).texOffs(15, 17).addBox(-2.0f, 2.5f, -4.5f, 4.0f, 1.0f, 1.0f, CubeDeformation.NONE).texOffs(21, 1).addBox(-3.5f, -5.0f, -2.0f, 2.0f, 2.0f, 1.0f, CubeDeformation.NONE).texOffs(21, 1).mirror().addBox(1.5f, -5.0f, -2.0f, 2.0f, 2.0f, 1.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)10.5f, (float)-10.0f));
        PartDefinition mouth = head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(15, 14).addBox(-2.5f, 0.0f, -2.0f, 5.0f, 1.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)3.0f, (float)-3.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    @Override
    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
        float idleSwingCos = Mth.cos((float)(((float)((NemeanLion)entity).tickCount + partialTick) * 0.22f));
        this.mouth.xRot = 0.5236f + 0.05f * idleSwingCos;
    }

    @Override
    protected float getAttackingPercent(T entity, float partialTick) {
        return ((NemeanLion)entity).getAttackPercent(partialTick);
    }

    @Override
    protected float getSittingPercent(T entity, float partialTick) {
        return ((NemeanLion)entity).getSittingPercent(partialTick);
    }
}

