/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;

public class NymphModel<T extends PathfinderMob>
extends HumanoidModel<T> {
    public static final ModelLayerLocation NYMPH_LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"nymph"), "nymph");

    public NymphModel(ModelPart root, boolean hatVisible) {
        super(root);
        this.hat.visible = hatVisible;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -7.0f, -3.5f, 7.0f, 7.0f, 7.0f, CubeDeformation.NONE).texOffs(21, 0).addBox(-3.5f, 0.0f, 2.5f, 7.0f, 5.0f, 1.0f, CubeDeformation.NONE), PartPose.ZERO);
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-3.0f, 0.0f, -1.5f, 6.0f, 12.0f, 3.0f, CubeDeformation.NONE), PartPose.ZERO);
        body.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(30, 7).addBox(-2.99f, 0.3473f, -2.5f, 6.0f, 4.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)1.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(19, 16).addBox(0.0f, -2.0f, -1.5f, 2.0f, 12.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)3.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(29, 16).addBox(-2.0f, -2.0f, -1.5f, 2.0f, 12.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)-3.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(40, 16).addBox(-1.49f, 0.0f, -1.5f, 3.0f, 12.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)1.5f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(52, 16).addBox(-1.51f, 0.0f, -1.5f, 3.0f, 12.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)-1.5f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack item = entity.getMainHandItem();
        if (item.getUseAnimation() == UseAnim.SPEAR && entity.isAggressive()) {
            if (entity.getMainArm() == HumanoidArm.RIGHT) {
                this.rightArmPose = HumanoidModel.ArmPose.THROW_SPEAR;
            } else {
                this.leftArmPose = HumanoidModel.ArmPose.THROW_SPEAR;
            }
        } else {
            this.rightArmPose = this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        }
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.leftArm.setPos(3.0f, 2.0f, 0.0f);
        this.rightArm.setPos(-3.0f, 2.0f, 0.0f);
        this.leftLeg.setPos(1.5f, 12.0f, 0.0f);
        this.rightLeg.setPos(-1.5f, 12.0f, 0.0f);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        if (this.swimAmount > 0.0f) {
            poseStack.translate(0.0, (double)this.swimAmount * 1.375, (double)this.swimAmount * -0.4);
            poseStack.mulPose(Axis.XP.rotationDegrees(this.swimAmount * 90.0f));
        }
        super.renderToBuffer(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

