/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.google.common.collect.ImmutableList;
import greekfantasy.client.entity.model.GFModelUtil;
import greekfantasy.entity.Orthus;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class OrthusModel<T extends Orthus>
extends AgeableListModel<T> {
    public static final ModelLayerLocation ORTHUS_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"orthus"), "orthus");
    protected final ModelPart rightHead;
    protected final ModelPart leftHead;
    protected final ModelPart body;
    protected final ModelPart mane;
    protected final ModelPart rightHindLeg;
    protected final ModelPart leftHindLeg;
    protected final ModelPart rightFrontLeg;
    protected final ModelPart leftFrontLeg;
    protected final ModelPart tail;
    protected final ModelPart realTail;

    public OrthusModel(ModelPart root) {
        this.rightHead = root.getChild("right_head");
        this.leftHead = root.getChild("left_head");
        this.body = root.getChild("body");
        this.mane = root.getChild("mane");
        this.rightHindLeg = root.getChild("right_hind_leg");
        this.leftHindLeg = root.getChild("left_hind_leg");
        this.rightFrontLeg = root.getChild("right_front_leg");
        this.leftFrontLeg = root.getChild("left_front_leg");
        this.tail = root.getChild("tail");
        this.realTail = this.tail.getChild("real_tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        GFModelUtil.addOrReplaceOrthusHead(partdefinition, "right_head", -4.0f);
        GFModelUtil.addOrReplaceOrthusHead(partdefinition, "left_head", 2.0f);
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(18, 14).addBox(-4.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("mane", CubeListBuilder.create().texOffs(21, 0).addBox(-4.0f, 2.0f, -4.0f, 8.0f, 6.0f, 7.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-1.0f, (float)14.0f, (float)2.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(0, 18).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)-2.5f, (float)16.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(0, 18).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)0.5f, (float)16.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(0, 18).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)-2.5f, (float)16.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 18).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)0.5f, (float)16.0f, (float)-4.0f));
        PartDefinition tail = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        tail.addOrReplaceChild("real_tail", CubeListBuilder.create().texOffs(9, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.rightHead, (Object)this.leftHead);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.mane, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.tail);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float bobAmount, float netHeadYaw, float headPitch) {
        this.rightHead.y = 12.5f;
        float headXRot = headPitch * ((float)Math.PI / 180);
        float headYRot = netHeadYaw * ((float)Math.PI / 180);
        this.rightHead.xRot = headXRot;
        this.rightHead.yRot = headYRot * 0.8f + 0.3491f;
        this.leftHead.xRot = headXRot;
        this.leftHead.yRot = headYRot * 0.8f - 0.3491f;
        this.tail.xRot = bobAmount;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        float headZRot;
        this.leftHead.zRot = headZRot = ((Orthus)((Object)entity)).getHeadRollAngle(partialTick);
        this.rightHead.zRot = headZRot;
        this.tail.yRot = entity.isAngry() ? 0.0f : -Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        if (entity.isInSittingPose() || entity.isOrderedToSit()) {
            this.mane.setPos(-1.0f, 14.0f, -7.5f);
            this.mane.xRot = 1.2566371f;
            this.mane.yRot = 0.0f;
            this.body.setPos(0.0f, 18.0f, 0.0f);
            this.body.xRot = 0.7853982f;
            this.tail.setPos(-1.0f, 21.0f, 6.0f);
            this.rightHindLeg.setPos(-2.5f, 22.7f, 2.0f);
            this.rightHindLeg.xRot = 4.712389f;
            this.leftHindLeg.setPos(0.5f, 22.7f, 2.0f);
            this.leftHindLeg.xRot = 4.712389f;
            this.rightFrontLeg.xRot = 5.811947f;
            this.rightFrontLeg.setPos(-2.49f, 17.0f, -4.0f);
            this.leftFrontLeg.xRot = 5.811947f;
            this.leftFrontLeg.setPos(0.51f, 17.0f, -4.0f);
        } else {
            this.body.setPos(0.0f, 13.0f, 2.0f);
            this.body.xRot = 1.5707964f;
            this.mane.setPos(-1.0f, 12.0f, -8.0f);
            this.mane.xRot = this.body.xRot;
            this.tail.setPos(-1.0f, 12.0f, 8.0f);
            this.rightHindLeg.setPos(-2.5f, 16.0f, 7.0f);
            this.leftHindLeg.setPos(0.5f, 16.0f, 7.0f);
            this.rightFrontLeg.setPos(-2.5f, 16.0f, -4.0f);
            this.leftFrontLeg.setPos(0.5f, 16.0f, -4.0f);
            this.rightHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.leftHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }
    }
}

