/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import greekfantasy.entity.Pegasus;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class PegasusModel<T extends Pegasus>
extends HorseModel<T> {
    public static final ModelLayerLocation PEGASUS_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"pegasus"), "pegasus");
    protected final ModelPart wings;
    protected final ModelPart leftWing;
    protected final ModelPart leftOuterWing;
    protected final ModelPart rightWing;
    protected final ModelPart rightOuterWing;

    public PegasusModel(ModelPart root) {
        super(root);
        this.wings = root.getChild("wings");
        this.leftWing = this.wings.getChild("left_wing");
        this.leftOuterWing = this.leftWing.getChild("left_outer_wing");
        this.rightWing = this.wings.getChild("right_wing");
        this.rightOuterWing = this.rightWing.getChild("right_outer_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HorseModel.createBodyMesh((CubeDeformation)CubeDeformation.NONE);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition wings = partdefinition.addOrReplaceChild("wings", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)11.0f, (float)5.0f));
        PartDefinition leftWing = wings.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 0).mirror(true).addBox(-6.0f, 0.0f, 0.0f, 11.0f, 10.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)5.0f, (float)3.0f, (float)-1.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        leftWing.addOrReplaceChild("left_outer_wing", CubeListBuilder.create().texOffs(0, 21).mirror(true).addBox(-6.0f, 0.0f, 0.0f, 11.0f, 10.0f, 1.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition rightWing = wings.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 0).mirror(false).addBox(-6.0f, 0.0f, 0.0f, 11.0f, 10.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-5.0f, (float)3.0f, (float)-1.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        rightWing.addOrReplaceChild("right_outer_wing", CubeListBuilder.create().texOffs(0, 21).mirror(false).addBox(-6.0f, 0.0f, 0.0f, 11.0f, 10.0f, 1.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)10.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
        this.wings.copyFrom(this.body);
        float wingSpan = 0.4f;
        float wingSpeed = 0.08f;
        if (((Pegasus)entity).isFlying()) {
            wingSpan += 0.2f;
        }
        if (entity.isVehicle()) {
            wingSpeed += 0.32f;
        }
        float wingAngle = Mth.cos((float)(((float)(((Pegasus)entity).tickCount + entity.getId() * 3) + partialTick) * wingSpeed)) * wingSpan;
        this.leftWing.zRot = -(1.5708f + wingAngle * 0.75f);
        this.leftOuterWing.xRot = -(wingAngle * 0.5f);
        this.rightWing.zRot = 1.5708f + wingAngle * 0.75f;
        this.rightOuterWing.xRot = this.leftOuterWing.xRot;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    public void renderWings(T entity, PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.leftWing.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
        this.rightWing.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
    }

    public ModelPart getWings() {
        return this.wings;
    }
}

