/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.google.common.collect.ImmutableList;
import greekfantasy.entity.boss.Python;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class PythonModel<T extends Python>
extends AgeableListModel<T> {
    public static final ModelLayerLocation PYTHON_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"python"), "python");
    private final ModelPart head;
    private final ModelPart mouth;
    private final ModelPart body1;
    private final ModelPart body2;
    private final ModelPart body3;
    private final ModelPart body4;
    private final ModelPart body5;
    private final ModelPart body6;
    private final ModelPart body7;
    private final ModelPart body8;

    public PythonModel(ModelPart root) {
        super(true, 0.0f, 0.0f);
        this.head = root.getChild("head");
        this.mouth = this.head.getChild("mouth");
        this.body1 = root.getChild("body1");
        this.body2 = this.body1.getChild("body2");
        this.body3 = this.body2.getChild("body3");
        this.body4 = this.body3.getChild("body4");
        this.body5 = this.body4.getChild("body5");
        this.body6 = this.body5.getChild("body6");
        this.body7 = this.body6.getChild("body7");
        this.body8 = this.body7.getChild("body8");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -10.0f, -10.0f, 8.0f, 8.0f, 10.0f, CubeDeformation.NONE).texOffs(27, 0).addBox(-3.0f, -6.0f, -15.0f, 6.0f, 3.0f, 5.0f, CubeDeformation.NONE).texOffs(51, 0).addBox(1.0f, -3.5f, -14.5f, 1.0f, 2.0f, 1.0f, CubeDeformation.NONE).texOffs(51, 0).addBox(-2.0f, -3.5f, -14.5f, 1.0f, 2.0f, 1.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)10.0f, (float)-4.0f));
        head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(37, 12).addBox(-3.0f, 0.0f, -5.0f, 6.0f, 1.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-10.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("left_horn", CubeListBuilder.create().texOffs(56, 0).addBox(0.0f, -4.0f, -2.0f, 2.0f, 4.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)1.0f, (float)-10.0f, (float)-5.0f, (float)0.48f, (float)0.0f, (float)0.1745f));
        head.addOrReplaceChild("right_horn", CubeListBuilder.create().texOffs(56, 0).addBox(-2.0f, -4.0f, -2.0f, 2.0f, 4.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-1.0f, (float)-10.0f, (float)-5.0f, (float)0.48f, (float)0.0f, (float)-0.1745f));
        PartDefinition body1 = partdefinition.addOrReplaceChild("body1", CubeListBuilder.create().texOffs(0, 20).addBox(-3.0f, -4.5f, -4.0f, 6.0f, 6.0f, 8.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)-4.5f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition body2 = body1.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(0, 20).addBox(-2.99f, -2.0f, -3.5f, 6.0f, 6.0f, 8.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)6.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition body3 = body2.addOrReplaceChild("body3", CubeListBuilder.create().texOffs(0, 20).addBox(-3.0f, -6.0f, 0.0f, 6.0f, 6.0f, 8.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)4.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition body4 = body3.addOrReplaceChild("body4", CubeListBuilder.create().texOffs(0, 35).addBox(-2.99f, -6.0f, 0.0f, 6.0f, 6.0f, 6.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)8.0f, (float)0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition body5 = body4.addOrReplaceChild("body5", CubeListBuilder.create().texOffs(0, 35).addBox(-3.0f, -6.0f, 0.0f, 6.0f, 6.0f, 6.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)5.5f));
        PartDefinition body6 = body5.addOrReplaceChild("body6", CubeListBuilder.create().texOffs(0, 48).addBox(-2.5f, -5.0f, 0.0f, 5.0f, 5.0f, 6.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)5.5f));
        PartDefinition body7 = body6.addOrReplaceChild("body7", CubeListBuilder.create().texOffs(30, 24).addBox(-2.0f, -4.0f, 0.0f, 4.0f, 4.0f, 6.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)5.5f));
        PartDefinition body8 = body7.addOrReplaceChild("body8", CubeListBuilder.create().texOffs(30, 35).addBox(-1.5f, -3.0f, 0.0f, 3.0f, 3.0f, 6.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)5.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float partialTick, float rotationYaw, float rotationPitch) {
        this.head.yRot = rotationYaw * ((float)Math.PI / 180);
        this.head.xRot = rotationPitch * ((float)Math.PI / 180);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
        float limbSwingCos = Mth.cos((float)limbSwing);
        float idleSwingCos = Mth.cos((float)(((float)((Python)((Object)entity)).tickCount + partialTick) * 0.22f));
        this.mouth.xRot = 0.5236f + 0.06f * idleSwingCos;
        this.body4.yRot = limbSwingCos * 0.15f;
        this.body5.yRot = limbSwingCos * -0.6f;
        this.body6.yRot = limbSwingCos * 0.85f;
        this.body7.yRot = limbSwingCos * -0.65f;
        this.body8.yRot = limbSwingCos * 0.35f;
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body1);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }
}

