/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import greekfantasy.client.entity.model.HoofedHumanoidModel;
import greekfantasy.entity.Satyr;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class SatyrModel<T extends Satyr>
extends HoofedHumanoidModel<T> {
    public static final ModelLayerLocation SATYR_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"satyr"), "satyr");
    public static final ModelLayerLocation SATYR_INNER_ARMOR_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"satyr_inner_armor"), "satyr_inner_armor");

    public SatyrModel(ModelPart root) {
        super(root, true, true);
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition meshdefinition = HoofedHumanoidModel.createMesh(cubeDeformation);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDeformation).texOffs(24, 0).addBox(-1.0f, -3.0f, -5.0f, 2.0f, 1.0f, 1.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(56, 16).addBox(-1.5f, -1.0f, 0.0f, 1.0f, 2.0f, 3.0f, cubeDeformation), PartPose.offsetAndRotation((float)-3.0f, (float)-4.0f, (float)-1.0f, (float)-0.2618f, (float)-0.3491f, (float)0.0f));
        head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(56, 22).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 3.0f, cubeDeformation), PartPose.offsetAndRotation((float)4.0f, (float)-4.0f, (float)-1.0f, (float)-0.2618f, (float)0.3491f, (float)0.0f));
        PartDefinition right_horn_lower = head.addOrReplaceChild("right_horn_lower", CubeListBuilder.create().texOffs(47, 48).addBox(-5.0f, -4.0f, -1.0f, 1.0f, 4.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)-1.0f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition right_horn_middle = right_horn_lower.addOrReplaceChild("right_horn_middle", CubeListBuilder.create().texOffs(47, 54).addBox(-1.25f, -3.0f, 0.0f, 1.0f, 3.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)-4.0f, (float)-4.0f, (float)-1.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition right_horn_upper = right_horn_middle.addOrReplaceChild("right_horn_upper", CubeListBuilder.create().texOffs(47, 59).addBox(-1.5f, -3.0f, 0.0f, 1.0f, 3.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition left_horn_lower = head.addOrReplaceChild("left_horn_lower", CubeListBuilder.create().texOffs(54, 48).addBox(4.0f, -4.0f, -1.0f, 1.0f, 4.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)-1.0f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition left_horn_middle = left_horn_lower.addOrReplaceChild("left_horn_middle", CubeListBuilder.create().texOffs(54, 54).addBox(8.25f, -3.0f, 0.0f, 1.0f, 3.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)-4.0f, (float)-4.0f, (float)-1.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition left_horn_upper = left_horn_middle.addOrReplaceChild("left_horn_upper", CubeListBuilder.create().texOffs(54, 59).addBox(8.5f, -3.0f, 0.0f, 1.0f, 3.0f, 2.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float partialTick, float rotationYaw, float rotationPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, partialTick, rotationYaw, rotationPitch);
        if (((Satyr)entity).holdingPanfluteTime > 0) {
            float armPercent = ((Satyr)entity).getArmMovementPercent(partialTick);
            this.rightArm.xRot = -1.31f * armPercent;
            this.rightArm.yRot = -0.68f * armPercent;
            this.leftArm.xRot = -1.22f * armPercent;
            this.leftArm.yRot = -0.43f * armPercent;
            this.leftArm.zRot = 1.17f * armPercent;
        }
    }
}

