/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import greekfantasy.client.entity.model.GFModelUtil;
import greekfantasy.entity.boss.Scylla;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class ScyllaModel
extends HumanoidModel<Scylla> {
    public static final ModelLayerLocation SCYLLA_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"scylla"), "scylla");
    public static final int LEG_COUNT = 8;
    protected final ModelPart monsterBody;
    protected final ModelPart torso;
    protected final ModelPart legs;
    protected final List<GFModelUtil.Tuple4<ModelPart>> legsList;

    public ScyllaModel(ModelPart root) {
        super(root);
        this.torso = this.body.getChild("torso");
        this.monsterBody = this.torso.getChild("monster_body");
        this.legs = this.body.getChild("legs");
        this.legsList = GFModelUtil.getScyllaLegs(this.legs, 8);
        this.leftLeg.visible = false;
        this.rightLeg.visible = false;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)-3.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 22).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)-3.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(48, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 54).mirror().addBox(-1.0f, -0.5f, -2.0f, 3.0f, 12.0f, 4.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)5.0f, (float)-2.5f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 54).addBox(-3.0f, -0.5f, -2.0f, 3.0f, 12.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)-4.0f, (float)-2.5f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 38).addBox(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)9.0f, (float)0.0f));
        body.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(50, 54).addBox(-4.01f, 0.0f, 0.0f, 8.0f, 4.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-11.0f, (float)-2.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition torso = body.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(48, 38).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 5.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        torso.addOrReplaceChild("monster_body", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, 0.0f, -6.0f, 12.0f, 10.0f, 12.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition legs = body.addOrReplaceChild("legs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)15.0f, (float)0.0f));
        GFModelUtil.addOrReplaceScyllaLegs(legs, 8);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(Scylla entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.head.setPos(0.0f, -3.0f, 0.0f);
        this.hat.setPos(0.0f, -3.0f, 0.0f);
        this.body.setPos(0.0f, 9.0f, 0.0f);
        this.leftArm.setPos(5.0f, -2.5f, 0.0f);
        this.rightArm.setPos(-4.0f, -2.5f, 0.0f);
        this.setupArmAnim(entity, ageInTicks);
    }

    public void setupArmAnim(Scylla entity, float ageInTicks) {
        int n = this.legsList.size();
        for (int i = 0; i < n; ++i) {
            GFModelUtil.Tuple4<ModelPart> leg = this.legsList.get(i);
            float idleSwing = 0.5f + 0.5f * Mth.cos((float)(ageInTicks * 0.11f + (float)i * 1.62f));
            GFModelUtil.setupScyllaLegAnim(leg, idleSwing);
        }
    }
}

