/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.projectile.Projectile;

public class SpellModel<T extends Projectile>
extends EntityModel<T> {
    public static final ModelLayerLocation SPELL_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"spell"), "spell");
    private final boolean usePackedLight;
    private final ModelPart root;
    private final ModelPart outerCube;
    private final ModelPart innerCube;

    public SpellModel(ModelPart root) {
        this(root, true);
    }

    public SpellModel(ModelPart root, boolean usePackedLight) {
        this.root = root;
        this.usePackedLight = usePackedLight;
        this.outerCube = root.getChild("outer_cube");
        this.innerCube = root.getChild("inner_cube");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("outer_cube", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("inner_cube", CubeListBuilder.create().texOffs(0, 12).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.outerCube.xRot = (ageInTicks + 5.0f) * 0.122f;
        this.innerCube.xRot = -this.outerCube.xRot;
        this.outerCube.zRot = ageInTicks * 0.14f;
        this.innerCube.zRot = -this.outerCube.zRot;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.root.render(poseStack, vertexConsumer, this.usePackedLight ? packedLight : 0xF000F0, packedOverlay, color);
    }
}

