/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import greekfantasy.entity.monster.Stymphalian;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class StymphalianModel<T extends Stymphalian>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation STYMPHALIAN_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"stymphalian"), "stymphalian");
    protected final ModelPart root;
    protected final ModelPart body;
    protected final ModelPart neck;
    protected final ModelPart head;
    protected final ModelPart mouth;
    protected final ModelPart leftLeg;
    protected final ModelPart rightLeg;
    protected final ModelPart leftWing;
    protected final ModelPart leftUpperWing;
    protected final ModelPart leftLowerWing;
    protected final ModelPart rightWing;
    protected final ModelPart rightUpperWing;
    protected final ModelPart rightLowerWing;

    public StymphalianModel(ModelPart root) {
        this.root = root;
        this.body = root.getChild("body");
        this.neck = this.body.getChild("neck");
        this.head = this.neck.getChild("head");
        this.mouth = this.head.getChild("mouth");
        this.leftLeg = root.getChild("left_leg");
        this.rightLeg = root.getChild("right_leg");
        this.leftWing = this.body.getChild("left_wing");
        this.leftUpperWing = this.leftWing.getChild("left_upper_wing");
        this.leftLowerWing = this.leftUpperWing.getChild("left_lower_wing");
        this.rightWing = this.body.getChild("right_wing");
        this.rightUpperWing = this.rightWing.getChild("right_upper_wing");
        this.rightLowerWing = this.rightUpperWing.getChild("right_lower_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 12).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 8.0f, 4.0f, CubeDeformation.NONE).texOffs(21, 10).addBox(-2.0f, 5.0f, -2.0f, 4.0f, 1.0f, 3.0f, CubeDeformation.NONE).texOffs(0, 25).addBox(-3.0f, 0.0f, 1.0f, 6.0f, 5.0f, 1.0f, CubeDeformation.NONE).texOffs(15, 25).addBox(-3.0f, -8.0f, -3.0f, 6.0f, 5.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)0.0f, (float)-2.4435f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 8).addBox(-1.0f, 0.0f, -2.0f, 2.0f, 1.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.5f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -0.5f, -1.5f, 3.0f, 3.0f, 4.0f, CubeDeformation.NONE).texOffs(30, 25).addBox(0.0f, 2.5f, -2.5f, 1.0f, 2.0f, 4.0f, CubeDeformation.NONE).texOffs(37, 6).addBox(-1.0f, 0.0f, 2.5f, 2.0f, 1.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-1.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("beak_tip", CubeListBuilder.create().texOffs(37, 11).addBox(-0.99f, -0.75f, -0.25f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f, -0.25f, -0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)5.5f, (float)1.0472f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(37, 0).addBox(-1.0f, -0.73f, -1.0f, 2.0f, 1.0f, 4.0f, new CubeDeformation(-0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)2.5f));
        PartDefinition leftWing = body.addOrReplaceChild("left_wing", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition upperLeftWing = leftWing.addOrReplaceChild("left_upper_wing", CubeListBuilder.create().texOffs(14, 0).addBox(0.0f, -8.0f, 0.0f, 5.0f, 8.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)3.0f, (float)0.0f, (float)-3.0f, (float)0.0f, (float)-1.2217f, (float)0.0f));
        upperLeftWing.addOrReplaceChild("left_lower_wing", CubeListBuilder.create().texOffs(25, 0).addBox(0.0f, -8.0f, 0.0f, 5.0f, 8.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.0472f, (float)0.0f));
        PartDefinition rightWing = body.addOrReplaceChild("right_wing", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition upperRightWing = rightWing.addOrReplaceChild("right_upper_wing", CubeListBuilder.create().texOffs(14, 0).mirror().addBox(-5.0f, -8.0f, 0.0f, 5.0f, 8.0f, 1.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)-3.0f, (float)0.0f, (float)-3.0f));
        upperRightWing.addOrReplaceChild("right_lower_wing", CubeListBuilder.create().texOffs(25, 0).mirror().addBox(-5.0f, -8.0f, 0.0f, 5.0f, 8.0f, 1.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)-5.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(21, 19).addBox(0.0f, -0.5f, 0.0f, 1.0f, 4.0f, 1.0f, CubeDeformation.NONE), PartPose.offset((float)1.0f, (float)20.5f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(21, 19).addBox(0.0f, -0.5f, 0.0f, 1.0f, 4.0f, 1.0f, CubeDeformation.NONE), PartPose.offset((float)-2.0f, (float)20.5f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.neck.xRot = headPitch * ((float)Math.PI / 180) - 0.3491f;
        this.head.yRot = -netHeadYaw * ((float)Math.PI / 180);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
        float ticks = (float)(entity.getId() * 2 + ((Stymphalian)((Object)entity)).tickCount) + partialTick;
        float flyingTime = ((Stymphalian)((Object)entity)).getFlyingTime(partialTick);
        float flyingTimeLeft = 1.0f - flyingTime;
        float downSwing = -0.5f;
        float wingAngle = 0.64f;
        float wingSpeed = 0.82f;
        float cosTicks = flyingTime * Mth.cos((float)(ticks * 0.82f));
        float cosIdle = Mth.cos((float)(ticks * 0.11f));
        this.leftUpperWing.yRot = 0.0f + (cosTicks + -0.5f) * 0.64f * flyingTime - 1.2217f * flyingTimeLeft + 0.015f * cosIdle;
        this.leftLowerWing.yRot = this.leftUpperWing.yRot * 0.8f;
        this.rightUpperWing.yRot = -this.leftUpperWing.yRot;
        this.rightLowerWing.yRot = -this.leftLowerWing.yRot;
        this.rightLeg.xRot = Mth.cos((float)(ticks * 0.6662f)) * 0.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(ticks * 0.6662f + (float)Math.PI)) * 0.4f * limbSwingAmount;
        float y = cosTicks * 0.2f;
        this.body.y = 19.0f + y;
        this.rightLeg.y = this.leftLeg.y = 20.5f + y;
        this.mouth.xRot = entity.isAggressive() ? -0.361799f : 0.0f;
    }

    public ModelPart root() {
        return this.root;
    }
}

