/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.entity.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;

public class TritonModel<T extends PathfinderMob>
extends HumanoidModel<T> {
    public static final ModelLayerLocation TRITON_MODEL_RESOURCE = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"triton"), "triton");
    protected final ModelPart chest;
    protected final ModelPart upperTail;
    protected final ModelPart middleTail;
    protected final ModelPart lowerTail;

    public TritonModel(ModelPart root) {
        super(root);
        this.chest = this.body.getChild("chest");
        this.upperTail = root.getChild("upper_tail");
        this.middleTail = this.upperTail.getChild("middle_tail");
        this.lowerTail = this.middleTail.getChild("lower_tail");
        this.leftLeg.visible = false;
        this.rightLeg.visible = false;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, -2.0f, -2.0f, 8.0f, 12.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 17).addBox(-4.01f, 0.0f, 0.0f, 8.0f, 4.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-2.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition upper_tail = partdefinition.addOrReplaceChild("upper_tail", CubeListBuilder.create().texOffs(0, 32).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 6.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)2.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition middle_tail = upper_tail.addOrReplaceChild("middle_tail", CubeListBuilder.create().texOffs(0, 46).addBox(-3.0f, 0.0f, 0.0f, 6.0f, 6.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)-4.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition lower_tail = middle_tail.addOrReplaceChild("lower_tail", CubeListBuilder.create().texOffs(0, 23).addBox(-2.0f, 0.0f, 0.0f, 4.0f, 5.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition fin = lower_tail.addOrReplaceChild("fin", CubeListBuilder.create().texOffs(0, 56).addBox(-5.0f, -1.0f, 2.0f, 10.0f, 7.0f, 1.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 48).addBox(0.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)4.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)-4.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.leftArm, (Object)this.rightArm, (Object)this.upperTail, (Object)this.hat);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack item = entity.getMainHandItem();
        if (item.getUseAnimation() == UseAnim.SPEAR && entity.isAggressive()) {
            if (entity.getMainArm() == HumanoidArm.RIGHT) {
                this.rightArmPose = HumanoidModel.ArmPose.THROW_SPEAR;
            } else {
                this.leftArmPose = HumanoidModel.ArmPose.THROW_SPEAR;
            }
        } else {
            this.rightArmPose = this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        }
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.head.y += -2.0f;
        this.hat.copyFrom(this.head);
        this.leftArm.x += -1.0f;
        this.leftArm.y += -2.0f;
        this.rightArm.x += 1.0f;
        this.rightArm.y += -2.0f;
        if (entity.isSwimming() || entity.isInWater()) {
            float tailAngle = 0.21f;
            float tailSpeed = 0.14f;
            float cosTail = Mth.cos((float)((ageInTicks + (float)(entity.getId() * 3)) * 0.14f)) * 0.21f;
            this.upperTail.xRot = -0.2618f + cosTail * 0.4f;
            this.middleTail.xRot = 0.5236f + cosTail * 0.6f;
            this.lowerTail.xRot = 0.2618f + cosTail * 0.8f;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        if (this.swimAmount > 0.0f) {
            poseStack.translate(0.0, (double)this.swimAmount * 1.175, (double)this.swimAmount * -0.4);
            poseStack.mulPose(Axis.XP.rotationDegrees(this.swimAmount * 90.0f));
        }
        super.renderToBuffer(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

