/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import greekfantasy.client.entity.GorgonRenderer;
import greekfantasy.client.entity.model.GorgonModel;
import greekfantasy.entity.monster.Gorgon;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;

public class GorgonParticle
extends Particle {
    private final GorgonModel<Gorgon> model = new GorgonModel(Minecraft.getInstance().getEntityModels().bakeLayer(GorgonModel.GORGON_MODEL_RESOURCE));
    private static final RenderType renderType = RenderType.entityTranslucent((ResourceLocation)GorgonRenderer.GORGON_TEXTURE);
    private static final float distanceCoefficient = 4.2411504f;

    public GorgonParticle(ClientLevel level, double posX, double posY, double posZ, double motX, double motY, double motZ) {
        super(level, posX, posY, posZ, motX, motY, motZ);
        this.gravity = 0.0f;
        this.age = 0;
        this.lifetime = 78;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTick) {
        float ageInTicks = (float)this.age + partialTick;
        float agePercent = ageInTicks / (float)this.lifetime;
        float zOffset = Mth.sin((float)(agePercent * 4.2411504f)) - 0.5f;
        this.alpha = 0.15f + 0.65f * agePercent;
        PoseStack poseStack = new PoseStack();
        poseStack.mulPose(renderInfo.rotation());
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        poseStack.scale(-1.0f, 1.0f, -1.0f);
        poseStack.translate(0.0, 0.31, 2.15 + (double)(0.75f * zOffset));
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer vertexconsumer = multibuffersource$buffersource.getBuffer(renderType);
        this.model.setupSnakeAnim(ageInTicks);
        this.model.getHead().render(poseStack, vertexconsumer, 0xF000F0, OverlayTexture.NO_OVERLAY, -1);
        multibuffersource$buffersource.endBatch();
    }

    public AABB getRenderBoundingBox(float partialTicks) {
        return AABB.INFINITE;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new GorgonParticle(level, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

