/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import greekfantasy.GreekFantasy;
import greekfantasy.client.screen.radial.NoteRadialMenuItem;
import greekfantasy.client.screen.radial.RadialMenuHelper;
import greekfantasy.client.screen.radial.RadialMenuItem;
import greekfantasy.item.InstrumentItem;
import greekfantasy.util.Song;
import greekfantasy.util.SongManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class InstrumentScreen
extends Screen {
    private static final ResourceLocation WIDGETS = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/gui/song_widgets.png");
    private static final String[] NOTE_NAMES = new String[]{"G", "G#", "A", "A#", "B", "C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B", "C", "C#", "D", "D#", "E", "F", "F#"};
    private static final int VISIBLE_NOTE_COUNT = 12;
    private static final int GROUP_COUNT = 2;
    private static final int RADIAL_WIDTH = 80;
    private static final int RADIAL_HEIGHT = 80;
    private static final int RADIAL_ITEM_WIDTH = 40;
    private static final int RADIAL_ITEM_HEIGHT = 40;
    private static final int VISIBLE_SONG_COUNT = 6;
    private static final int SONG_WIDTH = 170;
    private static final int SONG_HEIGHT = 24;
    private static final int SONG_RADIAL_MARGIN = 12;
    private static final int SCROLL_WIDTH = 12;
    private static final int SCROLL_HEIGHT = 15;
    private static final int BACKGROUND_COLOR = 0x3F000000;
    private static final int BACKGROUND_HOVER_COLOR = 0x3FFFFFFF;
    private final RadialMenuHelper helper;
    private final int itemSlot;
    private final ItemStack itemStack;
    private final InstrumentItem instrument;
    private NoteRadialMenuItem[] items = new NoteRadialMenuItem[24];
    private final List<RadialMenuItem> visibleItems;
    private int group;
    private float x;
    private float y;
    private List<ResourceLocation> songs;
    private SongButton[] songButtons;
    private ScrollButton scrollButton;
    private ResourceLocation song;
    private int tickCount;
    private float scrollAmount;
    private boolean songsVisible;
    private boolean isDraggingScrollbar;
    private Component octaveControlComponent;
    private Component songVisibilityComponent;

    public InstrumentScreen(int itemSlot, ItemStack itemStack) {
        super((Component)Component.empty());
        if (!(itemStack.getItem() instanceof InstrumentItem)) {
            throw new IllegalArgumentException("Instrument Screen received an item that is not InstrumentItem");
        }
        this.instrument = (InstrumentItem)itemStack.getItem();
        this.visibleItems = new ArrayList<RadialMenuItem>();
        this.helper = new RadialMenuHelper(this, this.visibleItems, 40.0f, 80.0f, 0x3F000000, 0x3FFFFFFF);
        this.itemSlot = itemSlot;
        this.itemStack = itemStack;
        int n = this.items.length;
        for (int i = 0; i < n; ++i) {
            this.items[i] = new NoteRadialMenuItem(this, (Component)Component.literal((String)NOTE_NAMES[i]), i + 1);
        }
        this.songs = new ArrayList<ResourceLocation>(GreekFantasy.SONG_MAP.keySet());
    }

    protected void init() {
        super.init();
        this.x = (float)this.width / 2.0f;
        this.y = (float)this.height / 2.0f - 9.0f;
        this.octaveControlComponent = Component.translatable((String)"screen.greekfantasy.controls.octave");
        this.songVisibilityComponent = Component.translatable((String)"screen.greekfantasy.controls.songs");
        int songY = (int)this.y - 72;
        this.songButtons = new SongButton[6];
        for (int i = 0; i < 6; ++i) {
            this.songButtons[i] = (SongButton)this.addRenderableWidget((GuiEventListener)new SongButton(this, 0, songY + 24 * i));
        }
        this.scrollButton = (ScrollButton)this.addRenderableWidget((GuiEventListener)new ScrollButton(this, 0, songY));
        this.setGroup(0);
        this.setSongScrollAmount(0.0f);
        this.setSongsVisible(false);
    }

    public void tick() {
        super.tick();
        ++this.tickCount;
        if (this.song != null) {
            SongManager.playMusic((LivingEntity)this.getMinecraft().player, this.instrument, this.song, this.tickCount, this.instrument.getVolume(), this.instrument.getVolume() * 0.5f);
        }
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
    }

    public void render(GuiGraphics poseStack, int mouseX, int mouseY, float partialTick) {
        this.helper.drawBackground(poseStack, this.x, this.y, 0.0f);
        super.render(poseStack, mouseX, mouseY, partialTick);
        this.helper.drawItems(poseStack, (int)this.x, (int)this.y, 0.0f, 40, 40, this.font, Minecraft.getInstance().getItemRenderer());
        float octaveX = this.x - (float)this.font.width((FormattedText)this.octaveControlComponent) / 2.0f;
        poseStack.drawString(this.font, this.octaveControlComponent.getString(), octaveX, this.y + 80.0f + 4.0f, 0xFFFFFF, false);
        float visibilityX = this.x - (float)this.font.width((FormattedText)this.songVisibilityComponent) / 2.0f;
        String string = this.songVisibilityComponent.getString();
        Objects.requireNonNull(this.font);
        poseStack.drawString(this.font, string, visibilityX, this.y + 80.0f + 4.0f + 9.0f + 1.0f, 0xFFFFFF, false);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.helper.processMouse(this.x, this.y, (int)mouseX, (int)mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.songsVisible && mouseX < (double)(this.x - 80.0f - 12.0f)) {
            float scrollAmount = Mth.clamp((float)(this.scrollAmount - (float)scrollY * (1.0f / (float)Math.max(1, this.songs.size() - 6))), (float)0.0f, (float)1.0f);
            this.setSongScrollAmount(scrollAmount);
            this.scrollButton.setScrollAmount(scrollAmount);
        } else {
            this.setGroup((int)((double)this.group + scrollY));
        }
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isDraggingScrollbar = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32) {
            this.setSongsVisible(!this.songsVisible);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void setGroup(int group) {
        this.group = Mth.clamp((int)group, (int)0, (int)1);
        this.visibleItems.clear();
        int n = (this.group + 1) * 12;
        for (int i = this.group * 12; i < n; ++i) {
            this.visibleItems.add(this.items[i]);
        }
    }

    private void setSongScrollAmount(float amount) {
        this.scrollAmount = Mth.clamp((float)amount, (float)0.0f, (float)1.0f);
        int startIndex = Math.max(0, Math.round(this.scrollAmount * (float)this.songs.size()) - 6);
        for (int buttonId = 0; buttonId < 6; ++buttonId) {
            int index = buttonId + startIndex;
            this.songButtons[buttonId].setSong(this.songsVisible && index < this.songs.size() ? this.songs.get(index) : null);
        }
        this.scrollButton.setScrollAmount(this.scrollAmount);
    }

    private void setSongsVisible(boolean songsVisible) {
        this.songsVisible = songsVisible;
        this.x = songsVisible ? (float)this.width / 2.0f + 85.0f : (float)this.width / 2.0f;
        this.setSongScrollAmount(this.scrollAmount);
        this.scrollButton.visible = songsVisible;
    }

    public void playNote(int note) {
        SongManager.playNoteAt((LivingEntity)this.minecraft.player, this.instrument, note, this.instrument.getVolume());
    }

    private static class SongButton
    extends Button {
        private final InstrumentScreen screen;
        private ResourceLocation songId;
        private Component name;
        private Component credits;

        public SongButton(InstrumentScreen screen, int x, int y) {
            super(x, y, 170, 24, (Component)Component.empty(), b -> {}, Button.DEFAULT_NARRATION);
            this.screen = screen;
            this.visible = false;
        }

        public void renderWidget(GuiGraphics poseStack, int mouseX, int mouseY, float partialTick) {
            if (this.visible) {
                int color = this.isSelected() ? 0x3FFFFFFF : 0x3F000000;
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color >> 0 & 0xFF;
                int a = color >> 24 & 0xFF;
                RenderSystem.enableBlend();
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)WIDGETS);
                RenderSystem.setShaderColor((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)((float)a / 255.0f));
                poseStack.blit(WIDGETS, this.getX(), this.getY(), 0, 0, this.width, this.height);
                RenderSystem.disableBlend();
                poseStack.drawString(this.screen.font, this.name, this.getX() + 3, this.getY() + 4, 0);
                Font font = this.screen.font;
                int n = this.getX() + 3;
                int n2 = this.getY() + 5;
                Objects.requireNonNull(this.screen.font);
                poseStack.drawString(font, this.credits, n, n2 + 9, 0);
            }
        }

        protected boolean isSelected() {
            return this.isHovered || this.screen.song == this.songId;
        }

        public void onPress() {
            super.onPress();
            this.screen.tickCount = 0;
            this.screen.song = this.screen.song != null && this.screen.song == this.songId ? null : this.songId;
        }

        public void setSong(ResourceLocation songId) {
            this.songId = songId;
            if (songId != null) {
                this.setX((int)this.screen.x - 80 - 12 - 170);
                this.visible = true;
                Song song = GreekFantasy.SONG_MAP.getOrDefault(songId, Song.EMPTY);
                this.name = song.getName().copy().withStyle(ChatFormatting.WHITE);
                this.credits = song.getCredits().copy().withStyle(ChatFormatting.GRAY);
            } else {
                this.visible = false;
            }
        }
    }

    private static class ScrollButton
    extends Button {
        private InstrumentScreen screen;
        private int scrollY;

        public ScrollButton(InstrumentScreen screen, int x, int y) {
            super(x, y, 12, 144, (Component)Component.empty(), b -> {}, Button.DEFAULT_NARRATION);
            this.screen = screen;
        }

        public void renderWidget(GuiGraphics poseStack, int mouseX, int mouseY, float partialTick) {
            if (this.visible) {
                int color = this.isHoveredOrFocused() || this.screen.isDraggingScrollbar ? 0x3FFFFFFF : 0x3F000000;
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color >> 0 & 0xFF;
                int a = color >> 24 & 0xFF;
                RenderSystem.enableBlend();
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)WIDGETS);
                RenderSystem.setShaderColor((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)((float)a / 255.0f));
                poseStack.blit(WIDGETS, this.getX(), this.scrollY, 0, 26, 12, 15);
                RenderSystem.disableBlend();
            }
        }

        public void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
            this.screen.isDraggingScrollbar = true;
            float scrollAmount = Mth.clamp((float)((float)(mouseY - (double)this.getY()) / (float)this.height), (float)0.0f, (float)1.0f);
            this.screen.setSongScrollAmount(scrollAmount);
            this.setScrollAmount(scrollAmount);
        }

        public void setScrollAmount(float scrollAmount) {
            this.setX((int)this.screen.x - 80 - 12 - 170 - this.width - 2);
            this.scrollY = this.getY() + (int)(scrollAmount * (float)(this.height - 15));
        }
    }
}

