/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.util.Quest;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class QuestScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/gui/quest.png");
    private static final int IMAGE_WIDTH = 195;
    private static final int IMAGE_HEIGHT = 146;
    private static final int MARGIN_Y = 14;
    private static final int MARGIN_X = 12;
    private final int itemSlot;
    private final ItemStack itemStack;
    private final ResourceLocation questId;
    private final Quest quest;
    private int x;
    private int y;
    private MutableComponent title;
    private List<MutableComponent> components;

    protected QuestScreen(int itemSlot, ItemStack itemStack) {
        super((Component)Component.empty());
        this.itemSlot = itemSlot;
        this.itemStack = itemStack;
        CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (itemStack.is((Item)GFRegistry.ItemReg.QUEST.get()) && !customData.isEmpty() && customData.copyTag().contains("QuestId")) {
            this.questId = ResourceLocation.tryParse((String)customData.copyTag().getString("QuestId"));
            this.quest = GreekFantasy.QUEST_MAP.getOrDefault(this.questId, Quest.EMPTY);
        } else {
            this.questId = ResourceLocation.withDefaultNamespace((String)"empty");
            this.quest = Quest.EMPTY;
        }
    }

    protected void init() {
        super.init();
        this.x = (this.width - 195) / 2;
        this.y = (this.height - 146) / 2;
        this.title = this.quest.getDescription().withStyle(ChatFormatting.UNDERLINE);
        this.components = this.quest.getComponents();
    }

    public void render(GuiGraphics poseStack, int mouseX, int mouseY, float partialTick) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        poseStack.blit(BACKGROUND, this.x, this.y, 0, 0, 195, 146);
        int maxWidth = 171;
        float startX = (float)(this.width - this.font.width((FormattedText)this.title)) / 2.0f;
        float startY = this.y + 14;
        poseStack.drawString(this.font, this.title.getString(), startX, startY, 0, false);
        startX = this.x + 12;
        Objects.requireNonNull(this.font);
        startY += (float)(9 + 4);
        for (MutableComponent text : this.components) {
            poseStack.drawWordWrap(this.font, FormattedText.of((String)text.getString()), (int)startX, (int)startY, maxWidth, 0);
            startY += (float)(this.font.wordWrapHeight(text.getString(), maxWidth) + 2);
        }
        super.render(poseStack, mouseX, mouseY, partialTick);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean isPauseScreen() {
        return false;
    }
}

