/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.screen.radial;

import greekfantasy.client.screen.InstrumentScreen;
import greekfantasy.client.screen.radial.DrawingContext;
import greekfantasy.client.screen.radial.RadialMenuItem;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class NoteRadialMenuItem
extends RadialMenuItem {
    private final InstrumentScreen screen;
    private final Component text;
    private final int note;
    private final int color;

    public NoteRadialMenuItem(InstrumentScreen owner, Component text, int note) {
        this(owner, text, note, -1);
    }

    public NoteRadialMenuItem(InstrumentScreen owner, Component text, int note, int color) {
        super(owner);
        this.screen = owner;
        this.text = text;
        this.note = note;
        double noteColorData = (float)Math.pow(2.0, (double)note / 24.0);
        int noteColorR = (int)(255.0f * Math.max(0.0f, Mth.sin((float)(((float)noteColorData + 0.0f) * ((float)Math.PI * 2))) * 0.65f + 0.35f));
        int noteColorG = (int)(255.0f * Math.max(0.0f, Mth.sin((float)(((float)noteColorData + 0.33333334f) * ((float)Math.PI * 2))) * 0.65f + 0.35f));
        int noteColorB = (int)(255.0f * Math.max(0.0f, Mth.sin((float)(((float)noteColorData + 0.6666667f) * ((float)Math.PI * 2))) * 0.65f + 0.35f));
        this.color = 0xFF000000 | (noteColorR & 0xFF) << 16 | (noteColorG & 0xFF) << 8 | noteColorB & 0xFF;
    }

    public Component getText() {
        return this.text;
    }

    public int getColor() {
        return this.color;
    }

    @Override
    public void draw(DrawingContext context) {
        String textString = this.text.getString();
        float x = context.x - (float)context.fontRenderer.width(textString) / 2.0f;
        float f = context.y;
        Objects.requireNonNull(context.fontRenderer);
        float y = f - 9.0f / 2.0f;
        context.poseStack.drawString(context.fontRenderer, textString, x, y, this.color, true);
    }

    @Override
    public void setHovered(boolean hovered) {
        if (hovered && !this.isHovered()) {
            this.screen.playNote(this.note);
        }
        super.setHovered(hovered);
    }

    @Override
    public void drawTooltips(DrawingContext context) {
    }
}

