/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.client.screen.radial;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import greekfantasy.client.screen.radial.DrawingContext;
import greekfantasy.client.screen.radial.RadialMenuItem;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.util.TriConsumer;

public final class RadialMenuHelper {
    private static final float PRECISION = 0.0069444445f;
    private static final double TWO_PI = Math.PI * 2;
    public final int backgroundColor;
    public final int backgroundColorHover;
    private Screen screen;
    private DrawingContext.IDrawingHelper drawingHelper;
    private List<RadialMenuItem> items;
    private float radiusIn;
    private float radiusOut;
    private float itemRadius;

    public RadialMenuHelper(Screen screen, List<RadialMenuItem> items, float radiusIn, float radiusOut, int backgroundColor, int backgroundColorHover) {
        this.screen = screen;
        this.drawingHelper = (poseStack, mouseX, mouseY) -> {};
        this.items = items;
        this.radiusIn = radiusIn;
        this.radiusOut = radiusOut;
        this.itemRadius = (radiusOut + radiusIn) / 2.0f;
        this.backgroundColor = backgroundColor;
        this.backgroundColorHover = backgroundColorHover;
    }

    public void drawBackground(GuiGraphics poseStack, float x, float y, float z) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        this.iterateVisible((TriConsumer<RadialMenuItem, Float, Float>)((TriConsumer)(item, s, e) -> {
            int color = item.isHovered() ? this.backgroundColorHover : this.backgroundColor;
            this.drawPieArc(buffer, x, y, z, this.radiusIn, this.radiusOut, s.floatValue(), e.floatValue(), color);
        }));
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public void drawItems(GuiGraphics poseStack, int x, int y, float z, int width, int height, Font font, ItemRenderer itemRenderer) {
        this.iterateVisible((TriConsumer<RadialMenuItem, Float, Float>)((TriConsumer)(item, s, e) -> {
            float middle = (s.floatValue() + e.floatValue()) * 0.5f;
            float posX = (float)x + this.itemRadius * (float)Math.cos(middle);
            float posY = (float)y + this.itemRadius * (float)Math.sin(middle);
            DrawingContext context = new DrawingContext(poseStack, width, height, posX, posY, z, font, itemRenderer, this.drawingHelper);
            item.draw(context);
        }));
    }

    private void iterateVisible(TriConsumer<RadialMenuItem, Float, Float> consumer) {
        int numItems = this.items.size();
        for (int i = 0; i < numItems; ++i) {
            float s = (float)this.getAngleFor((double)i - 0.5, numItems);
            float e = (float)this.getAngleFor((double)i + 0.5, numItems);
            RadialMenuItem item = this.items.get(i);
            consumer.accept((Object)item, (Object)Float.valueOf(s), (Object)Float.valueOf(e));
        }
    }

    private void drawPieArc(BufferBuilder buffer, float x, float y, float z, float radiusIn, float radiusOut, float startAngle, float endAngle, int color) {
        float angle = endAngle - startAngle;
        int sections = Math.max(1, Mth.ceil((float)(angle / 0.0069444445f)));
        angle = endAngle - startAngle;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        int a = color >> 24 & 0xFF;
        float slice = angle / (float)sections;
        for (int i = 0; i < sections; ++i) {
            float angle1 = startAngle + (float)i * slice;
            float angle2 = startAngle + (float)(i + 1) * slice;
            float pos1InX = x + radiusIn * (float)Math.cos(angle1);
            float pos1InY = y + radiusIn * (float)Math.sin(angle1);
            float pos1OutX = x + radiusOut * (float)Math.cos(angle1);
            float pos1OutY = y + radiusOut * (float)Math.sin(angle1);
            float pos2OutX = x + radiusOut * (float)Math.cos(angle2);
            float pos2OutY = y + radiusOut * (float)Math.sin(angle2);
            float pos2InX = x + radiusIn * (float)Math.cos(angle2);
            float pos2InY = y + radiusIn * (float)Math.sin(angle2);
            buffer.addVertex(pos1OutX, pos1OutY, z).setColor(r, g, b, a);
            buffer.addVertex(pos1InX, pos1InY, z).setColor(r, g, b, a);
            buffer.addVertex(pos2InX, pos2InY, z).setColor(r, g, b, a);
            buffer.addVertex(pos2OutX, pos2OutY, z).setColor(r, g, b, a);
        }
    }

    public void processMouse(float x, float y, int mouseX, int mouseY) {
        double a;
        int numItems = this.items.size();
        double d = Math.sqrt(Math.pow((float)mouseX - x, 2.0) + Math.pow((float)mouseY - y, 2.0));
        if (numItems > 0) {
            double s0 = this.getAngleFor(-0.5, numItems);
            double s1 = this.getAngleFor((double)numItems - 0.5, numItems);
            for (a = Math.atan2((float)mouseY - y, (float)mouseX - x); a < s0; a += Math.PI * 2) {
            }
            while (a >= s1) {
                a -= Math.PI * 2;
            }
        }
        int hovered = -1;
        for (int i = 0; i < numItems; ++i) {
            float s = (float)this.getAngleFor((double)i - 0.5, numItems);
            float e = (float)this.getAngleFor((double)i + 0.5, numItems);
            if (!(a >= (double)s) || !(a < (double)e) || !(d >= (double)this.radiusIn) || !(d < (double)this.radiusOut)) continue;
            hovered = i;
            break;
        }
        this.setHovered(hovered);
    }

    private void setHovered(int which) {
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get(i).setHovered(i == which);
        }
    }

    private double getAngleFor(double i, int numItems) {
        if (numItems == 0) {
            return 0.0;
        }
        double angle = (i / (double)numItems + 0.25) * (Math.PI * 2) + Math.PI;
        return angle;
    }
}

