/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.enchantment;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class EnchantmentUtils {
    @Nullable
    public static Holder<Enchantment> getHolder(Level level, ResourceKey<Enchantment> enchantmentKey) {
        if (level == null || level.registryAccess().registry(Registries.ENCHANTMENT).isEmpty()) {
            return null;
        }
        Registry registry = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        return registry.getHolder(enchantmentKey).orElse(null);
    }

    public static void enchant(Level level, ItemStack stack, ResourceKey<Enchantment> enchantmentKey, int level_) {
        Holder<Enchantment> holder = EnchantmentUtils.getHolder(level, enchantmentKey);
        if (holder != null) {
            stack.enchant(holder, level_);
        }
    }

    public static int getEnchantmentLevel(Level level, ResourceKey<Enchantment> enchantmentKey, ItemStack stack) {
        if (level == null || level.registryAccess().registry(Registries.ENCHANTMENT).isEmpty()) {
            return 0;
        }
        Registry registry = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Holder holder = registry.getHolder(enchantmentKey).orElse(null);
        if (holder == null) {
            return 0;
        }
        return EnchantmentHelper.getItemEnchantmentLevel((Holder)holder, (ItemStack)stack);
    }

    public static int getEnchantmentLevel(ResourceKey<Enchantment> enchantmentKey, LivingEntity entity, ItemStack stack) {
        if (entity == null || entity.level() == null) {
            return 0;
        }
        return EnchantmentUtils.getEnchantmentLevel(entity.level(), enchantmentKey, stack);
    }

    public static boolean hasEnchantment(Level level, ResourceKey<Enchantment> enchantmentKey, ItemStack stack) {
        return EnchantmentUtils.getEnchantmentLevel(level, enchantmentKey, stack) > 0;
    }
}

