/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class Arion
extends Horse {
    public static final TagKey<Item> FOOD = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"arion_food"));
    public static final TagKey<Item> TRIGGER = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"arion_trigger"));

    public Arion(EntityType<? extends Arion> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractHorse.createBaseHorseAttributes().add(Attributes.ARMOR, 2.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public void registerGoals() {
        super.registerGoals();
    }

    public static Arion spawnArion(ServerLevel level, Player player, Horse horse) {
        Arion entity = (Arion)((EntityType)GFRegistry.EntityReg.ARION.get()).create((Level)level);
        entity.copyPosition((Entity)horse);
        entity.yBodyRot = horse.yBodyRot;
        if (horse.hasCustomName()) {
            entity.setCustomName(horse.getCustomName());
            entity.setCustomNameVisible(horse.isCustomNameVisible());
        }
        entity.setOwnerUUID(horse.getOwnerUUID());
        entity.setTamed(horse.isTamed());
        entity.setPersistenceRequired();
        entity.setPortalCooldown();
        entity.setAge(horse.getAge());
        level.addFreshEntity((Entity)entity);
        entity.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(horse.blockPosition()), MobSpawnType.CONVERSION, null);
        entity.copyInventory(horse);
        horse.discard();
        entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 60));
        entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 60));
        entity.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 60));
        level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), SoundEvents.PLAYER_LEVELUP, entity.getSoundSource(), 1.0f, 1.0f, false);
        return entity;
    }

    public void copyInventory(Horse horse) {
    }

    public boolean canMate(Animal otherAnimal) {
        return false;
    }

    public boolean canWearArmor() {
        return true;
    }

    public Variant getVariant() {
        return Variant.WHITE;
    }

    public Markings getMarkings() {
        return Markings.NONE;
    }

    public int getMaxTemper() {
        return 200;
    }

    protected float generateRandomMaxHealth(RandomSource random) {
        return Horse.generateMaxHealth(arg_0 -> ((RandomSource)random).nextInt(arg_0)) + 30.0f;
    }

    protected double generateRandomJumpStrength(RandomSource random) {
        return Horse.generateJumpStrength(() -> ((RandomSource)random).nextDouble()) + 0.25;
    }

    protected double generateRandomSpeed(RandomSource random) {
        return Horse.generateSpeed(() -> ((RandomSource)random).nextDouble()) + (double)0.21f;
    }

    protected boolean handleEating(Player player, ItemStack stack) {
        if (stack.is(FOOD)) {
            return super.handleEating(player, stack);
        }
        return false;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(FOOD);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (!this.isBaby()) {
            if (this.isTamed() && player.isSecondaryUseActive()) {
                this.openCustomInventoryScreen(player);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (this.isVehicle()) {
                return super.mobInteract(player, hand);
            }
        }
        if (!itemstack.isEmpty()) {
            boolean flag;
            if (this.isFood(itemstack)) {
                return this.fedFood(player, itemstack);
            }
            InteractionResult actionresulttype = itemstack.interactLivingEntity(player, (LivingEntity)this, hand);
            if (actionresulttype.consumesAction()) {
                return actionresulttype;
            }
            if (!this.isTamed()) {
                this.makeMad();
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            boolean bl = flag = !this.isBaby() && !this.isSaddled() && itemstack.is(Items.SADDLE);
            if (this.isBodyArmorItem(itemstack) || flag) {
                this.openCustomInventoryScreen(player);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
        }
        if (this.isTamed() && !this.isBaby()) {
            this.doPlayerRide(player);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return InteractionResult.PASS;
    }
}

