/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import greekfantasy.entity.ai.CooldownRangedAttackGoal;
import greekfantasy.entity.util.HasCustomCooldown;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class Automaton
extends AbstractGolem
implements RangedAttackMob,
HasCustomCooldown {
    protected static final TagKey<Item> BRONZE_INGOT = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"ingots/bronze"));
    protected static final TagKey<EntityType<?>> BOSSES = TagKey.create((ResourceKey)BuiltInRegistries.ENTITY_TYPE.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"bosses"));
    protected static final EntityDataAccessor<Byte> STATE = SynchedEntityData.defineId(Automaton.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    protected static final String KEY_STATE = "AutomatonState";
    protected static final String KEY_SPAWN = "SpawnTime";
    protected static final String KEY_SHOOT = "ShootTime";
    protected static final byte NONE = 0;
    protected static final byte SPAWNING = 1;
    protected static final byte SHOOT = 2;
    protected static final byte SPAWN_EVENT = 8;
    protected static final byte SHOOT_EVENT = 9;
    protected static final byte ATTACK_EVENT = 10;
    protected int spawnTime0;
    protected int spawnTime;
    protected int shootTime;
    protected float shootAngle0;
    protected float shootAngle;
    protected int attackCooldown;
    protected static final int MAX_ATTACK_TIMER = 10;
    protected int attackTimer;
    protected int crackiness;

    public Automaton(EntityType<? extends Automaton> type, Level level) {
        super(type, level);
        this.xpReward = 5;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 160.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ATTACK_DAMAGE, 9.5).add(Attributes.ATTACK_KNOCKBACK, 0.5249999999999999).add(Attributes.ARMOR, 10.0).add(Attributes.STEP_HEIGHT, (double)0.2f);
    }

    public static Automaton spawnAutomaton(Level level, BlockPos pos, float yaw) {
        Automaton entity = (Automaton)((EntityType)GFRegistry.EntityReg.AUTOMATON.get()).create(level);
        entity.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5, yaw, 0.0f);
        entity.yBodyRot = yaw;
        level.addFreshEntity((Entity)entity);
        entity.setSpawning(true);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            entity.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(pos), MobSpawnType.MOB_SUMMONED, null);
            for (ServerPlayer player : serverLevel.getEntitiesOfClass(ServerPlayer.class, entity.getBoundingBox().inflate(15.0))) {
                CriteriaTriggers.SUMMONED_ENTITY.trigger(player, (Entity)entity);
            }
        }
        return entity;
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new SpawningGoal());
        this.goalSelector.addGoal(3, (Goal)new AutomatonRangedAttackGoal(4, 25.0f, this.getRangedAttackCooldown()));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.registerAutomatonGoals();
    }

    protected void registerAutomatonGoals() {
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(5, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)Ingredient.of(BRONZE_INGOT), false));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, false, false, e -> e instanceof Enemy && e.canChangeDimensions(e.level(), e.level()) && !e.getType().is(BOSSES)));
    }

    protected int getRangedAttackCooldown() {
        return 188;
    }

    protected int getMeleeAttackCooldown() {
        return 0;
    }

    protected double getBonusAttackKnockback() {
        return 0.45;
    }

    protected int getMaxSpawnTime() {
        return 70;
    }

    protected int getMaxShootTime() {
        return 16;
    }

    public float getMaxShootingAngle() {
        return -1.4708f;
    }

    protected boolean isHealItem(ItemStack itemStack) {
        return itemStack.is(BRONZE_INGOT);
    }

    public void travel(Vec3 vec) {
        Vec3 travelVec = vec;
        if (this.isInWaterRainOrBubble() && !this.isInWaterOrBubble()) {
            double multiplier = 1.0 - (double)this.getWaterSlowDown() * 0.5;
            travelVec = vec.multiply(multiplier, 1.0, multiplier);
        }
        super.travel(travelVec);
    }

    public boolean canAttack(LivingEntity entity) {
        if (this.getType() == GFRegistry.EntityReg.AUTOMATON.get() && entity instanceof Player) {
            return false;
        }
        return super.canAttack(entity);
    }

    public void aiStep() {
        super.aiStep();
        this.crackiness = Mth.floor((double)((double)(this.getHealth() / this.getMaxHealth()) * 4.0));
        this.tickCustomCooldown();
        this.spawnTime0 = this.spawnTime;
        if ((this.isSpawning() || this.spawnTime > 0) && --this.spawnTime <= 0) {
            this.setSpawning(false);
        }
        if (this.attackTimer > 0 && ++this.attackTimer >= 10) {
            this.attackTimer = 0;
        }
        this.shootAngle0 = this.shootAngle;
        if (this.isShooting() || this.shootTime > 0) {
            this.shootAngle = Math.min(1.0f, this.shootAngle + 0.08f);
            if (this.shootTime++ >= this.getMaxShootTime()) {
                this.setShooting(false);
                this.shootTime = 0;
            }
        } else {
            this.shootAngle = Math.max(0.0f, this.shootAngle - 0.08f);
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide() && this.getDeltaMovement().horizontalDistanceSqr() > 2.500000277905201E-7 && this.random.nextInt(3) == 0) {
            int i = Mth.floor((double)this.getX());
            int j = Mth.floor((double)(this.getY() - (double)0.2f));
            int k = Mth.floor((double)this.getZ());
            BlockPos pos = new BlockPos(i, j, k);
            BlockState blockstate = this.level().getBlockState(pos);
            if (!this.level().isEmptyBlock(pos)) {
                BlockParticleOption data = new BlockParticleOption(ParticleTypes.BLOCK, blockstate).setPos(pos);
                double radius = this.getBbWidth() * 0.8f;
                double motion = 4.0;
                this.level().addParticle((ParticleOptions)data, this.getX() + (this.random.nextDouble() - 0.5) * radius * 2.0, this.getY() + 0.1, this.getZ() + (this.random.nextDouble() - 0.5) * radius * 2.0, 4.0 * (this.random.nextDouble() - 0.5), 0.45, (this.random.nextDouble() - 0.5) * 4.0);
            }
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (this.getHealth() < this.getMaxHealth() && this.isHealItem(itemstack)) {
            if (!this.level().isClientSide()) {
                this.heal(this.getMaxHealth() * 0.5f);
                if (!player.isCreative()) {
                    itemstack.shrink(1);
                }
                this.playSound(SoundEvents.IRON_GOLEM_REPAIR, 1.0f, 1.0f);
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.INSTANT_EFFECT, this.getX(), this.getEyeY(), this.getZ(), 8, 0.5, 0.5, 0.5, 0.5);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.mobInteract(player, hand);
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (super.doHurtTarget(entityIn)) {
            double knockbackFactor = this.getBonusAttackKnockback();
            Vec3 myPos = this.position();
            Vec3 ePos = entityIn.position();
            double dX = Math.signum(ePos.x - myPos.x) * knockbackFactor;
            double dZ = Math.signum(ePos.z - myPos.z) * knockbackFactor;
            entityIn.push(dX, knockbackFactor / 2.0, dZ);
            entityIn.hurtMarked = true;
            this.attackTimer = 1;
            this.playSound(SoundEvents.IRON_GOLEM_ATTACK, 1.0f, 0.6f + this.random.nextFloat() * 0.2f);
            this.level().broadcastEntityEvent((Entity)this, (byte)10);
            return true;
        }
        return false;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData result = super.finalizeSpawn(level, difficulty, spawnType, spawnDataIn);
        this.setSpawning(true);
        return result;
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    public boolean removeWhenFarAway(double disToPlayer) {
        return false;
    }

    protected boolean canRide(Entity entityIn) {
        return false;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return this.isSpawning() || source.is(DamageTypeTags.IS_DROWNING) || source == this.damageSources().inWall() || source.is(DamageTypeTags.WITHER_IMMUNE_TO) || super.isInvulnerableTo(source);
    }

    public boolean hurt(DamageSource source, float amount) {
        float hurtAmount = amount;
        if (source.getDirectEntity() instanceof AbstractArrow) {
            hurtAmount = amount * 0.1f;
        }
        return super.hurt(source, hurtAmount);
    }

    public int getAmbientSoundInterval() {
        return 280;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.BLAZE_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.IRON_GOLEM_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.IRON_GOLEM_DEATH;
    }

    public float getVoicePitch() {
        return 0.6f + this.random.nextFloat() * 0.25f;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte(KEY_STATE, this.getState());
        compound.putInt(KEY_SPAWN, this.spawnTime);
        compound.putInt(KEY_SHOOT, this.shootTime);
        this.saveCustomCooldown(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setState(compound.getByte(KEY_STATE));
        this.spawnTime = compound.getInt(KEY_SPAWN);
        this.shootTime = compound.getInt(KEY_SHOOT);
        this.readCustomCooldown(compound);
    }

    public byte getState() {
        return (Byte)this.getEntityData().get(STATE);
    }

    public void setState(byte state) {
        this.getEntityData().set(STATE, (Object)state);
    }

    public boolean isNoneState() {
        return this.getState() == 0;
    }

    public boolean isSpawning() {
        return this.spawnTime > 0 || this.getState() == 1;
    }

    public void setShooting(boolean shoot) {
        this.setState(shoot ? (byte)2 : 0);
    }

    public boolean isShooting() {
        return this.getState() == 2;
    }

    public void setSpawning(boolean spawning) {
        this.spawnTime = spawning ? this.getMaxSpawnTime() : 0;
        this.setState(spawning ? (byte)1 : 0);
        if (spawning && !this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)8);
        }
    }

    public int getCrackiness() {
        return this.crackiness;
    }

    public void handleEntityEvent(byte id) {
        switch (id) {
            case 8: {
                this.setSpawning(true);
                break;
            }
            case 9: {
                this.shootTime = 1;
                this.playSound(SoundEvents.STONE_PRESSURE_PLATE_CLICK_ON, 1.1f, 1.0f);
                break;
            }
            case 10: {
                this.attackTimer = 1;
                this.playSound(SoundEvents.IRON_GOLEM_ATTACK, 1.0f, 0.6f + this.random.nextFloat() * 0.2f);
                break;
            }
            default: {
                super.handleEntityEvent(id);
            }
        }
    }

    public float getSpawnPercent(float partialTick) {
        return 1.0f - Mth.lerp((float)partialTick, (float)this.spawnTime0, (float)this.spawnTime) / (float)this.getMaxSpawnTime();
    }

    public float getShootAnglePercent(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.shootAngle0, (float)this.shootAngle);
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    public float getAttackPercent(float partialTick) {
        if (this.attackTimer <= 0) {
            return 0.0f;
        }
        return Mth.lerp((float)partialTick, (float)(this.attackTimer - 1), (float)this.attackTimer) / 10.0f;
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (this.level().isClientSide() || !this.isShooting() || this.shootTime < this.getMaxShootTime() / 4) {
            return;
        }
        ItemStack itemstack = new ItemStack((ItemLike)Items.ARROW);
        AbstractArrow arrow = ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)itemstack, (float)distanceFactor, null);
        arrow.setPos(this.getX() - (double)this.getBbWidth() * 0.85 * (double)Mth.sin((float)(this.yBodyRot * ((float)Math.PI / 180) + 1.0f)), this.getEyeY() - 0.74, this.getZ() + (double)this.getBbWidth() * 0.85 * (double)Mth.cos((float)(this.yBodyRot * ((float)Math.PI / 180) + 1.0f)));
        double dx = target.getX() - arrow.getX();
        double dy = target.getY(0.67) - arrow.getY();
        double dz = target.getZ() - arrow.getZ();
        double dis = Math.sqrt(dx * dx + dz * dz);
        arrow.shoot(dx, dy + dis * (double)0.2f, dz, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
        arrow.setBaseDamage(1.0 + (double)this.level().getDifficulty().getId() * 0.25);
        arrow.setOwner((Entity)this);
        this.playSound(SoundEvents.ARROW_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)arrow);
    }

    @Override
    public void setCustomCooldown(int cooldown) {
        this.attackCooldown = cooldown;
    }

    @Override
    public int getCustomCooldown() {
        return this.attackCooldown;
    }

    class SpawningGoal
    extends Goal {
        public SpawningGoal() {
            this.setFlags(EnumSet.allOf(Goal.Flag.class));
        }

        public boolean canUse() {
            return Automaton.this.isSpawning();
        }

        public void tick() {
            Automaton.this.getNavigation().stop();
            Automaton.this.getLookControl().setLookAt(Automaton.this.getX(), Automaton.this.getY(), Automaton.this.getZ());
            Automaton.this.setRot(0.0f, 0.0f);
            Automaton.this.setTarget(null);
        }
    }

    class AutomatonRangedAttackGoal
    extends CooldownRangedAttackGoal {
        public AutomatonRangedAttackGoal(int interval, float attackDistance, int cooldown) {
            super(Automaton.this, interval, attackDistance, cooldown);
        }

        @Override
        public boolean canUse() {
            return Automaton.this.isNoneState() && super.canUse();
        }

        @Override
        public void start() {
            super.start();
            Automaton.this.setShooting(true);
            Automaton.this.level().broadcastEntityEvent((Entity)Automaton.this, (byte)9);
            Automaton.this.shootTime = 1;
        }

        public boolean canContinueToUse() {
            return Automaton.this.shootTime > 0 && Automaton.this.isShooting();
        }

        @Override
        public void tick() {
            super.tick();
        }

        public void stop() {
            Automaton.this.setState((byte)0);
            Automaton.this.shootTime = 0;
            super.stop();
        }
    }
}

