/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GreekFantasy;
import greekfantasy.entity.ai.MoveToStructureGoal;
import greekfantasy.entity.ai.TradeWithPlayerGoal;
import greekfantasy.entity.util.HasHorseVariant;
import greekfantasy.entity.util.TradingMob;
import greekfantasy.util.Quest;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class Centaur
extends PathfinderMob
implements NeutralMob,
RangedAttackMob,
HasHorseVariant,
TradingMob {
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.defineId(Centaur.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final String KEY_VARIANT = "Variant";
    private static final byte START_REARING_EVENT = 6;
    private static final byte STOP_REARING_EVENT = 7;
    private static final byte FINISH_TRADE_EVENT = 8;
    protected static final TagKey<Item> CENTAUR_TRADE = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"centaur_trade"));
    private static final UniformInt ANGER_RANGE = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;
    private boolean isRearing;
    private int tailCounter;
    private float rearingAmount;
    private float prevRearingAmount;
    private int rearingCounter;
    private Player tradingPlayer;

    public Centaur(EntityType<? extends Centaur> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.MAX_HEALTH, 34.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5).add(Attributes.ARMOR, 1.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new RangedAttackGoal(this, 1.0, this.hasBullHead() ? 50 : 35, 15.0f));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Centaur)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Phantom.class, true, false));
        this.targetSelector.addGoal(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
        this.addCentaurGoals();
    }

    protected void addCentaurGoals() {
        this.goalSelector.addGoal(2, new TradeWithPlayerGoal<Centaur>(this, 40 + this.random.nextInt(20)));
        if (((Boolean)GreekFantasy.CONFIG.CENTAUR_SEEK_CAMP.get()).booleanValue()) {
            this.goalSelector.addGoal(4, (Goal)new MoveToStructureGoal((PathfinderMob)this, 1.0, 3, 8, 4, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"centaur_camp"), DefaultRandomPos::getPos));
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT, (Object)0);
    }

    public void aiStep() {
        super.aiStep();
        if (this.random.nextInt(200) == 0) {
            this.moveTail();
        }
        if (!this.level().isClientSide()) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    public void tick() {
        super.tick();
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
        this.prevRearingAmount = this.rearingAmount;
        if (this.isRearing()) {
            this.rearingAmount += (1.0f - this.rearingAmount) * 0.4f + 0.05f;
            if (this.rearingAmount > 1.0f) {
                this.rearingAmount = 1.0f;
            }
        } else {
            this.rearingAmount += (0.8f * this.rearingAmount * this.rearingAmount * this.rearingAmount - this.rearingAmount) * 0.6f - 0.05f;
            if (this.rearingAmount < 0.0f) {
                this.rearingAmount = 0.0f;
            }
        }
        if (this.isEffectiveAi() && this.rearingCounter > 0 && ++this.rearingCounter > 20) {
            this.rearingCounter = 0;
            this.setRearing(false);
        }
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (source.getEntity() != null && source.getEntity().getType() == this.getType()) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    public boolean canBeLeashed() {
        return false;
    }

    public boolean canFireProjectileWeapon(ProjectileWeaponItem item) {
        return item instanceof BowItem;
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        ItemStack itemstack = this.getProjectile(this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow arrow = ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)itemstack, (float)distanceFactor, null);
        if (this.getMainHandItem().getItem() instanceof BowItem) {
            arrow = ((BowItem)this.getMainHandItem().getItem()).customArrow(arrow, this.getMainHandItem(), itemstack);
        }
        arrow.setPos(this.getX() - (double)(this.getBbWidth() + 1.0f) * 0.5 * (double)Mth.sin((float)(this.yBodyRot * ((float)Math.PI / 180))), this.getEyeY() - (double)0.1f, this.getZ() + (double)(this.getBbWidth() + 1.0f) * 0.5 * (double)Mth.cos((float)(this.yBodyRot * ((float)Math.PI / 180))));
        double dx = target.getX() - arrow.getX();
        double dy = target.getY(0.67) - arrow.getY();
        double dz = target.getZ() - arrow.getZ();
        double dis = Math.sqrt(dx * dx + dz * dz);
        arrow.shoot(dx, dy + dis * (double)0.2f, dz, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
        this.playSound(SoundEvents.ARROW_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)arrow);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte(KEY_VARIANT, (byte)this.getVariant().getId());
        this.addPersistentAngerSaveData(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setVariant(Variant.byId((int)compound.getByte(KEY_VARIANT)));
        this.readPersistentAngerSaveData(this.level(), compound);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_RANGE.sample(this.random));
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.angerTime = time;
    }

    public int getRemainingPersistentAngerTime() {
        return this.angerTime;
    }

    public void setPersistentAngerTarget(@Nullable UUID target) {
        this.angerTarget = target;
    }

    public UUID getPersistentAngerTarget() {
        return this.angerTarget;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnDataIn) {
        Variant color = this.getVariant();
        if (spawnType != MobSpawnType.STRUCTURE) {
            if (spawnDataIn instanceof GroupData) {
                color = ((GroupData)spawnDataIn).variant;
            } else {
                color = (Variant)Util.getRandom((Object[])Variant.values(), (RandomSource)this.getRandom());
                spawnDataIn = new GroupData(color);
            }
        }
        this.setVariant(color, (Markings)Util.getRandom((Object[])Markings.values(), (RandomSource)this.getRandom()));
        if (this.random.nextInt(3) > 0) {
            this.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.BOW));
        }
        return super.finalizeSpawn(worldIn, difficulty, spawnType, spawnDataIn);
    }

    protected int calculateFallDamage(float distance, float damageMultiplier) {
        return Mth.ceil((float)((distance * 0.5f - 3.0f) * damageMultiplier));
    }

    public boolean onClimbable() {
        return false;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        if (this.random.nextInt(3) == 0) {
            this.makeRear();
        }
        return null;
    }

    protected SoundEvent getAmbientSound() {
        if (this.random.nextInt(10) == 0 && !this.isImmobile()) {
            this.makeRear();
        }
        return null;
    }

    protected float getSoundVolume() {
        return 0.8f;
    }

    public int getAmbientSoundInterval() {
        return 400;
    }

    public void handleEntityEvent(byte id) {
        switch (id) {
            case 6: {
                this.isRearing = true;
                break;
            }
            case 7: {
                this.isRearing = false;
                break;
            }
            case 8: {
                this.swing(InteractionHand.OFF_HAND, true);
                this.playSound(SoundEvents.BOOK_PAGE_TURN, this.getSoundVolume(), this.getVoicePitch());
                break;
            }
            default: {
                super.handleEntityEvent(id);
            }
        }
    }

    public void makeRear() {
        if (this.isEffectiveAi()) {
            this.rearingCounter = 1;
            this.setRearing(true);
        }
    }

    public void setRearing(boolean rearing) {
        this.isRearing = rearing;
        this.level().broadcastEntityEvent((Entity)this, rearing ? (byte)6 : 7);
    }

    @Override
    public boolean isRearing() {
        return this.isRearing;
    }

    public void moveTail() {
        this.tailCounter = 1;
    }

    @Override
    public float getRearingAmount(float partialTick) {
        return partialTick > 0.99f ? this.rearingAmount : Mth.lerp((float)partialTick, (float)this.prevRearingAmount, (float)this.rearingAmount);
    }

    @Override
    public int getTailCounter() {
        return this.tailCounter;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        InteractionResult tradeResult = this.startTrading(this, player, hand);
        if (tradeResult != InteractionResult.PASS) {
            return tradeResult;
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public TagKey<Item> getTradeTag() {
        return CENTAUR_TRADE;
    }

    @Override
    public ResourceLocation getTradeLootTable() {
        return BuiltInLootTables.EMPTY.location();
    }

    @Override
    public Player getTradingPlayer() {
        return this.tradingPlayer;
    }

    @Override
    public void setTradingPlayer(@Nullable Player player) {
        this.tradingPlayer = player;
    }

    @Override
    public void trade(PathfinderMob self, @Nullable Player player, ItemStack tradeItem) {
        TradingMob.super.trade(self, player, tradeItem);
        this.level().broadcastEntityEvent((Entity)this, (byte)8);
    }

    @Override
    public List<ItemStack> getTradeResult(PathfinderMob self, @Nullable Player player, ItemStack tradeItem) {
        return List.of(Quest.createQuestItemStack(Quest.getRandomQuestId(self.getRandom())));
    }

    @Override
    public void setPackedVariant(int packedColorsTypes) {
        this.entityData.set(DATA_VARIANT, (Object)packedColorsTypes);
    }

    @Override
    public int getPackedVariant() {
        return (Integer)this.entityData.get(DATA_VARIANT);
    }

    public boolean hasBullHead() {
        return false;
    }

    class RangedAttackGoal
    extends net.minecraft.world.entity.ai.goal.RangedAttackGoal {
        public RangedAttackGoal(RangedAttackMob entity, double moveSpeed, int attackInterval, float attackDistance) {
            super(entity, moveSpeed, attackInterval, attackDistance);
        }

        public boolean canUse() {
            return super.canUse() && Centaur.this.getMainHandItem().getItem() instanceof BowItem;
        }

        public void start() {
            super.start();
            Centaur.this.setAggressive(true);
        }

        public void stop() {
            super.stop();
            Centaur.this.setAggressive(false);
        }
    }

    public static class GroupData
    implements SpawnGroupData {
        public final Variant variant;

        public GroupData(Variant color) {
            this.variant = color;
        }
    }
}

