/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import greekfantasy.entity.ai.GFBegGoal;
import greekfantasy.entity.boss.Hydra;
import greekfantasy.entity.misc.Curse;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class Cerastes
extends TamableAnimal {
    protected static final TagKey<Item> FOOD = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"cerastes_food"));
    private static final byte STANDING_START_EVENT = 4;
    private static final byte STANDING_END_EVENT = 5;
    private static final byte HIDING_START_EVENT = 6;
    private static final byte HIDING_END_EVENT = 7;
    private final EntityDimensions hiddenSize = EntityDimensions.scalable((float)0.8f, (float)0.2f);
    private final int MAX_TONGUE_TIME = 10;
    private int tongueTime0;
    private int tongueTime;
    private final int MAX_STANDING_TIME = 8;
    private int standingTime0;
    private int standingTime;
    private final int MAX_HIDING_TIME = 10;
    private int hidingTime0;
    private int hidingTime;
    private boolean isHiding;
    private boolean isStanding;
    private boolean isGoingToSand;

    public Cerastes(EntityType<? extends Cerastes> type, Level worldIn) {
        super(type, worldIn);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -0.5f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -0.5f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
    }

    public static boolean checkCerastesSpawnRules(EntityType<? extends PathfinderMob> entityType, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos pos, RandomSource rand) {
        return Mob.checkMobSpawnRules(entityType, (LevelAccessor)level, (MobSpawnType)mobSpawnType, (BlockPos)pos, (RandomSource)rand) && level.getBlockState(pos.below()).is(BlockTags.SAND);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 24.0).add(Attributes.MOVEMENT_SPEED, 0.31).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.FOLLOW_RANGE, 5.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new CerastesBegGoal(6.0f));
        this.goalSelector.addGoal(2, (Goal)new HideGoal(this));
        this.goalSelector.addGoal(3, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.1, false));
        this.goalSelector.addGoal(5, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 8.0f, 2.0f));
        this.goalSelector.addGoal(6, (Goal)new GoToSandGoal(10, 0.8f));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean canUse() {
                return !Cerastes.this.isHiding() && !Cerastes.this.isGoingToSand && Cerastes.this.random.nextInt(600) == 0 && super.canUse();
            }
        });
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, false, false, e -> !this.isOwnedBy((LivingEntity)e) && !e.getMainHandItem().is(FOOD) && !e.getOffhandItem().is(FOOD)));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Rabbit.class, 10, false, false, e -> !this.isHiding() || this.distanceToSqr((Entity)e) < 5.0));
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob parent) {
        return null;
    }

    public boolean canMate(Animal animal) {
        return false;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(FOOD);
    }

    public void aiStep() {
        super.aiStep();
        if (this.isEffectiveAi()) {
            if (!(this.isHiding || this.getTarget() == null && this.random.nextInt(600) != 0)) {
                this.setStanding(true);
            } else if (this.isStanding() && (float)this.standingTime > 0.9f && this.random.nextInt(60) == 0) {
                this.setStanding(false);
            }
        }
        if (this.getTarget() != null) {
            this.isGoingToSand = false;
        }
    }

    public void tick() {
        super.tick();
        this.tongueTime0 = this.tongueTime;
        if (this.tongueTime == 0) {
            if (!this.isStanding() && this.random.nextInt(100) == 0) {
                this.tongueTime = 1;
            }
        } else if (++this.tongueTime > 10) {
            this.tongueTime0 = 0;
            this.tongueTime = 0;
        }
        this.standingTime0 = this.standingTime;
        if (this.isStanding()) {
            this.standingTime = Math.min(this.standingTime + 1, 8);
        } else if ((float)this.standingTime > 0.0f) {
            this.standingTime = Math.max(0, this.standingTime - 1);
        }
        this.hidingTime0 = this.hidingTime;
        if (this.isHiding()) {
            this.hidingTime = Math.min(this.hidingTime + 1, 10);
        } else if ((float)this.hidingTime > 0.0f) {
            this.hidingTime = Math.max(0, this.hidingTime - 1);
        }
    }

    public void handleEntityEvent(byte id) {
        switch (id) {
            case 4: {
                this.isStanding = true;
                this.isHiding = false;
                break;
            }
            case 5: {
                this.isStanding = false;
                break;
            }
            case 6: {
                this.isHiding = true;
                this.isStanding = false;
                this.refreshDimensions();
                break;
            }
            case 7: {
                this.isHiding = false;
                this.refreshDimensions();
                break;
            }
            default: {
                super.handleEntityEvent(id);
            }
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean hurt = super.hurt(source, amount);
        this.setHiding(false);
        this.setStanding(true);
        this.setOrderedToSit(false);
        this.setInSittingPose(false);
        if (hurt && source.getDirectEntity() instanceof Curse && this.level() instanceof ServerLevel) {
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 2.5f, Level.ExplosionInteraction.TNT);
            Hydra.spawnHydra((ServerLevel)this.level(), this);
        }
        return hurt;
    }

    protected void doPush(Entity entityIn) {
        if (entityIn instanceof LivingEntity && !this.level().isClientSide() && this.random.nextInt(10) == 0) {
            this.setHiding(false);
            this.setStanding(true);
        }
        super.doPush(entityIn);
    }

    public boolean canAttackType(EntityType<?> typeIn) {
        if (typeIn == this.getType() || typeIn == EntityType.CREEPER) {
            return false;
        }
        return super.canAttackType(typeIn);
    }

    public boolean doHurtTarget(Entity entity) {
        if (super.doHurtTarget(entity)) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 120, 0));
                if ((double)this.random.nextFloat() < 0.15) {
                    livingEntity.addEffect(new MobEffectInstance(GFRegistry.MobEffectReg.STUNNED, 40, 0));
                }
            }
            return true;
        }
        return false;
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    public boolean onClimbable() {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.SPIDER_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.SPIDER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SPIDER_DEATH;
    }

    protected float getSoundVolume() {
        return 0.8f;
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (this.level().isClientSide()) {
            boolean consume = this.isOwnedBy((LivingEntity)player) || this.isTame() || this.isFood(itemstack) && !this.isTame();
            return consume ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.isTame()) {
            if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                if (!player.isCreative()) {
                    itemstack.shrink(1);
                }
                this.heal(itemstack.getFoodProperties((LivingEntity)this).nutrition());
                this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
                return InteractionResult.SUCCESS;
            }
            InteractionResult interactionresult = super.mobInteract(player, hand);
            if ((!interactionresult.consumesAction() || this.isBaby()) && this.isOwnedBy((LivingEntity)player)) {
                this.setOrderedToSit(!this.isOrderedToSit());
                this.jumping = false;
                this.navigation.stop();
                this.setTarget(null);
                return InteractionResult.SUCCESS;
            }
            return interactionresult;
        }
        if (itemstack.is(FOOD)) {
            if (!player.isCreative()) {
                itemstack.shrink(1);
            }
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)player)) {
                this.tame(player);
                this.navigation.stop();
                this.setTarget(null);
                this.setOrderedToSit(true);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void setStanding(boolean standing) {
        this.isStanding = standing;
        if (standing) {
            this.isHiding = false;
        }
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, standing ? (byte)4 : 5);
        }
    }

    public boolean isStanding() {
        return this.isStanding;
    }

    public float getTonguePercent(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.tongueTime0, (float)this.tongueTime) / 10.0f;
    }

    public float getStandingPercent(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.standingTime0, (float)this.standingTime) / 8.0f;
    }

    public void setHiding(boolean hiding) {
        this.isHiding = hiding;
        if (hiding) {
            this.isStanding = false;
        }
        this.level().broadcastEntityEvent((Entity)this, hiding ? (byte)6 : 7);
        this.refreshDimensions();
    }

    public boolean isHiding() {
        return this.isHiding;
    }

    public float getHidingPercent(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.hidingTime0, (float)this.hidingTime) / 10.0f;
    }

    class CerastesBegGoal
    extends GFBegGoal {
        public CerastesBegGoal(float minDistance) {
            super((Mob)Cerastes.this, minDistance, 10, item -> item.is(FOOD));
        }

        public void start() {
            super.start();
            Cerastes.this.setStanding(false);
            Cerastes.this.setHiding(false);
        }
    }

    static class HideGoal
    extends Goal {
        final Cerastes entity;
        final int MAX_HIDE_TIME = 600;
        final int MAX_COOLDOWN = 500;
        int cooldown;

        public HideGoal(Cerastes entityIn) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.entity = entityIn;
            this.cooldown = entityIn.getRandom().nextInt(500);
        }

        public boolean canUse() {
            if (this.cooldown > 0) {
                --this.cooldown;
            } else {
                if (this.entity.getTarget() != null || !this.entity.getNavigation().isDone() || this.entity.isHiding()) {
                    return false;
                }
                if (this.entity.getRandom().nextInt(10) == 0) {
                    BlockPos blockpos = new BlockPos((int)this.entity.getX(), (int)(this.entity.getY() - 0.5), (int)this.entity.getZ());
                    BlockState blockstate = this.entity.level().getBlockState(blockpos);
                    return blockstate.is(BlockTags.SAND);
                }
            }
            return false;
        }

        public void start() {
            this.entity.setHiding(true);
            this.entity.isGoingToSand = false;
        }

        public void tick() {
            super.tick();
            if (this.entity.getTarget() != null || this.entity.getRandom().nextInt(600) == 0) {
                this.stop();
                return;
            }
            this.entity.getNavigation().stop();
        }

        public boolean canContinueToUse() {
            return this.entity.isHiding();
        }

        public void stop() {
            super.stop();
            this.entity.setHiding(false);
            this.cooldown = 500;
        }
    }

    class GoToSandGoal
    extends MoveToBlockGoal {
        public GoToSandGoal(int radiusIn, double speedIn) {
            super((PathfinderMob)Cerastes.this, speedIn, radiusIn);
        }

        public boolean canUse() {
            return !Cerastes.this.isHiding() && !Cerastes.this.isOrderedToSit() && Cerastes.this.getTarget() == null && super.canUse();
        }

        public void tick() {
            super.tick();
            if (this.isReachedTarget()) {
                Cerastes.this.isGoingToSand = false;
            }
        }

        protected boolean isValidTarget(LevelReader worldIn, BlockPos pos) {
            if (!worldIn.getBlockState(pos).blocksMotion() && worldIn.getBlockState(pos.below()).is(BlockTags.SAND)) {
                Cerastes.this.isGoingToSand = true;
                return true;
            }
            return false;
        }
    }
}

