/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import com.google.common.collect.ImmutableMap;
import greekfantasy.GFRegistry;
import greekfantasy.entity.Satyr;
import greekfantasy.entity.ai.FindBlockGoal;
import greekfantasy.entity.ai.TradeWithPlayerGoal;
import greekfantasy.entity.util.NymphVariant;
import greekfantasy.entity.util.TradingMob;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;

public class Dryad
extends PathfinderMob
implements NeutralMob,
TradingMob {
    protected static final EntityDataAccessor<String> DATA_VARIANT = SynchedEntityData.defineId(Dryad.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    protected static final String KEY_VARIANT = "Variant";
    protected static final String KEY_TREE_POS = "Tree";
    protected static final String KEY_HIDING = "HidingTime";
    protected static final TagKey<Item> DRYAD_TRADE = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"dryad_trade"));
    private static final byte FINISH_TRADE_EVENT = 9;
    protected NymphVariant variant = Variant.OAK;
    protected BlockPos treePos = null;
    protected Player tradingPlayer = null;
    protected static final UniformInt ANGER_RANGE = TimeUtil.rangeOfSeconds((int)4, (int)10);
    protected int angerTime;
    protected UUID angerTarget;
    protected boolean isGoingToTree;
    protected int hidingTime;

    public Dryad(EntityType<? extends Dryad> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, 0.28).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ARMOR, 4.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.1, false));
        this.goalSelector.addGoal(2, new TradeWithPlayerGoal<Dryad>(this, 50 + this.random.nextInt(20)));
        this.goalSelector.addGoal(3, (Goal)new FindTreeGoal(8, 28));
        this.goalSelector.addGoal(4, (Goal)new HideGoal(640));
        this.goalSelector.addGoal(5, (Goal)new GoToTreeGoal(0.9f, 320));
        this.goalSelector.addGoal(7, (Goal)new AvoidEntityGoal((PathfinderMob)this, Satyr.class, 10.0f, 1.2, 1.1, entity -> !this.isHiding() && !this.isGoingToTree && this.tradingPlayer != null));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollWhenNotHidingGoal(0.8f, 140));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Dryad)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT, (Object)Variant.OAK.getSerializedName());
    }

    public void aiStep() {
        super.aiStep();
        if (this.tickCount % 28 == 0 && this.treePos != null && !Dryad.isTreeAt((BlockGetter)this.level(), this.treePos, this.getVariant().getLogs())) {
            this.tryExitTree();
            this.isGoingToTree = false;
            this.setHiding(false);
            this.setTreePos(null);
        }
        if (this.treePos != null && this.isHiding() && this.random.nextInt(400) == 1) {
            this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 60));
        }
        if (!this.level().isClientSide()) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    public void move(MoverType type, Vec3 vec) {
        super.move(type, vec);
        this.checkInsideBlocks();
    }

    public void tick() {
        boolean isHidingInTree;
        boolean bl = isHidingInTree = this.isHiding() && this.isWithinDistanceOfTree(2.05) && this.getNavigation().isDone();
        if (isHidingInTree) {
            this.noPhysics = true;
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.0, 1.0));
            Vec3 treeVec = this.getTreeVec();
            this.setPos(treeVec.x(), treeVec.y(), treeVec.z());
        }
        super.tick();
        this.setNoGravity(isHidingInTree);
        this.noPhysics = false;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (source == this.damageSources().inWall() && this.isHiding()) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    public boolean doHurtTarget(Entity entity) {
        if (super.doHurtTarget(entity)) {
            if (entity.getUUID().equals(this.getPersistentAngerTarget())) {
                this.setPersistentAngerTarget(null);
            }
            return true;
        }
        return false;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString(KEY_VARIANT, (String)this.getEntityData().get(DATA_VARIANT));
        this.addPersistentAngerSaveData(compound);
        if (this.treePos != null) {
            compound.putInt("Tree.x", this.treePos.getX());
            compound.putInt("Tree.y", this.treePos.getY());
            compound.putInt("Tree.z", this.treePos.getZ());
        }
        compound.putInt(KEY_HIDING, this.hidingTime);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setVariant(this.getVariantByName(compound.getString(KEY_VARIANT)));
        this.readPersistentAngerSaveData(this.level(), compound);
        if (compound.contains("Tree.x")) {
            int x = compound.getInt("Tree.x");
            int y = compound.getInt("Tree.y");
            int z = compound.getInt("Tree.z");
            this.setTreePos(new BlockPos(x, y, z));
        }
        this.hidingTime = compound.getInt(KEY_HIDING);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType mobType, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData result = super.finalizeSpawn(worldIn, difficultyIn, mobType, spawnDataIn);
        NymphVariant variant = mobType == MobSpawnType.COMMAND || mobType == MobSpawnType.SPAWN_EGG || mobType == MobSpawnType.SPAWNER || mobType == MobSpawnType.DISPENSER ? this.getRandomVariant(this.getRandom()) : this.getVariantForBiome((Holder<Biome>)worldIn.getBiome(this.blockPosition()));
        this.setVariant(variant);
        return result;
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)this.getVariant().getDeathLootTable());
    }

    public boolean canBeLeashed() {
        return false;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_RANGE.sample(this.random));
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.angerTime = time;
    }

    public int getRemainingPersistentAngerTime() {
        return this.angerTime;
    }

    public void setPersistentAngerTarget(@Nullable UUID target) {
        this.angerTarget = target;
    }

    public UUID getPersistentAngerTarget() {
        return this.angerTarget;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return null == this.treePos && this.tickCount > 4800;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        InteractionResult tradeResult = this.startTrading(this, player, hand);
        if (tradeResult != InteractionResult.PASS) {
            return tradeResult;
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public Player getTradingPlayer() {
        return this.tradingPlayer;
    }

    @Override
    public void setTradingPlayer(@Nullable Player player) {
        this.tradingPlayer = player;
    }

    @Override
    public TagKey<Item> getTradeTag() {
        return DRYAD_TRADE;
    }

    @Override
    public ResourceLocation getTradeLootTable() {
        return this.getVariant().getTradeLootTable();
    }

    @Override
    public void trade(PathfinderMob self, @Nullable Player player, ItemStack tradeItem) {
        TradingMob.super.trade(self, player, tradeItem);
        this.level().broadcastEntityEvent((Entity)this, (byte)9);
    }

    public void handleEntityEvent(byte id) {
        switch (id) {
            case 9: {
                this.swing(InteractionHand.MAIN_HAND, true);
                for (int i = 0; i < 4; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getX() + 0.5 * (this.random.nextDouble() - 0.5), this.getEyeY() + 0.5 * (this.random.nextDouble() - 0.5), this.getZ() + 0.5 * (this.random.nextDouble() - 0.5), 0.0, 0.0, 0.0);
                }
                break;
            }
            default: {
                super.handleEntityEvent(id);
            }
        }
    }

    public void setVariant(NymphVariant variantIn) {
        this.variant = variantIn;
        this.getEntityData().set(DATA_VARIANT, (Object)variantIn.getSerializedName());
    }

    public NymphVariant getVariant() {
        return this.variant;
    }

    public NymphVariant getVariantByName(String name) {
        return Variant.getByName(name);
    }

    public NymphVariant getRandomVariant(RandomSource rand) {
        return Variant.getRandom(rand);
    }

    public NymphVariant getVariantForBiome(Holder<Biome> biome) {
        return Variant.getForBiome(biome);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key.equals(DATA_VARIANT)) {
            this.variant = this.getVariantByName((String)this.getEntityData().get(DATA_VARIANT));
        }
    }

    public BlockPos getTreePos() {
        return this.treePos;
    }

    public Vec3 getTreeVec() {
        if (this.treePos != null) {
            return Vec3.atBottomCenterOf((Vec3i)this.treePos.above());
        }
        return null;
    }

    public boolean isHiding() {
        return this.hidingTime > 0 || this.level().getBlockState(this.blockPosition().above()).is(this.getVariant().getLogs());
    }

    public void setHiding(boolean hiding) {
        this.hidingTime = hiding ? 1 : 0;
    }

    public void setTreePos(@Nullable BlockPos pos) {
        this.treePos = pos;
        if (pos != null) {
            this.restrictTo(pos, (int)this.getAttribute(Attributes.FOLLOW_RANGE).getBaseValue());
        } else {
            this.restrictTo(BlockPos.ZERO, -1);
        }
    }

    public static boolean isTreeAt(BlockGetter level, BlockPos pos, TagKey<Block> logs) {
        BlockState soil = level.getBlockState(pos);
        return soil.is(BlockTags.DIRT) && level.getBlockState(pos.above(1)).is(logs) && level.getBlockState(pos.above(2)).is(logs);
    }

    public boolean tryExitTree() {
        if (this.treePos != null && this.isWithinDistanceOfTree(2.0) && this.getNavigation().isDone()) {
            int radius = 2;
            for (int i = 0; i < 10; ++i) {
                double x = this.getX() + (double)this.random.nextInt(radius * 2) - (double)radius;
                double y = this.getY() + (double)this.random.nextInt(radius) - (double)radius / 2.0;
                double z = this.getZ() + (double)this.random.nextInt(radius * 2) - (double)radius;
                if (!this.level().noCollision((Entity)this, this.makeBoundingBox().move(x - this.getX(), y - this.getY(), z - this.getZ()))) continue;
                this.getNavigation().moveTo(x, y, z, 1.0);
                return true;
            }
        }
        return false;
    }

    public boolean isWithinDistanceOfTree(double dis) {
        Vec3 treeVec = this.getTreeVec();
        if (treeVec != null) {
            return treeVec.closerThan((Position)this.position(), dis);
        }
        return false;
    }

    public static class Variant
    implements NymphVariant {
        public static final Variant ACACIA = new Variant("acacia", ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"is_savanna"), () -> Blocks.ACACIA_SAPLING);
        public static final Variant BIRCH = new Variant("birch", ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"is_birch"), () -> Blocks.BIRCH_SAPLING);
        public static final Variant DARK_OAK = new Variant("dark_oak", ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"is_spooky"), () -> Blocks.DARK_OAK_SAPLING);
        public static final Variant JUNGLE = new Variant("jungle", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"is_jungle"), () -> Blocks.JUNGLE_SAPLING);
        public static final Variant OAK = new Variant("oak", ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"is_plains"), () -> Blocks.OAK_SAPLING);
        public static final Variant SPRUCE = new Variant("spruce", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"is_taiga"), () -> Blocks.SPRUCE_SAPLING);
        public static final Variant OLIVE = new Variant("greekfantasy", "olive", ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"is_olive"), () -> (Block)GFRegistry.BlockReg.OLIVE_SAPLING.get());
        public static ImmutableMap<String, Variant> OVERWORLD = ImmutableMap.builder().put((Object)Variant.ACACIA.name, (Object)ACACIA).put((Object)Variant.BIRCH.name, (Object)BIRCH).put((Object)Variant.DARK_OAK.name, (Object)DARK_OAK).put((Object)Variant.JUNGLE.name, (Object)JUNGLE).put((Object)Variant.OAK.name, (Object)OAK).put((Object)Variant.SPRUCE.name, (Object)SPRUCE).put((Object)Variant.OLIVE.name, (Object)OLIVE).build();
        protected final String name;
        protected final Supplier<Block> sapling;
        protected final TagKey<Block> tag;
        protected final TagKey<Biome> biomeTag;
        protected final ResourceLocation deathLootTable;
        protected final ResourceLocation tradeLootTable;

        protected Variant(String nameIn, ResourceLocation biomeTag, Supplier<Block> saplingIn) {
            this("minecraft", nameIn, (TagKey<Biome>)TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)biomeTag), "dryad", "logs", saplingIn);
        }

        protected Variant(String modid, String nameIn, ResourceLocation biomeTag, Supplier<Block> saplingIn) {
            this(modid, nameIn, (TagKey<Biome>)TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)biomeTag), "dryad", "logs", saplingIn);
        }

        protected Variant(String modid, String nameIn, TagKey<Biome> biome, String entityIn, String tagSuffixIn, Supplier<Block> saplingIn) {
            this.name = nameIn;
            this.biomeTag = biome;
            this.sapling = saplingIn;
            this.deathLootTable = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)("entities/" + entityIn + "/" + this.name));
            this.tradeLootTable = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)("gameplay/" + entityIn + "_trade"));
            ResourceLocation tagId = ResourceLocation.fromNamespaceAndPath((String)modid, (String)(this.name + "_" + tagSuffixIn));
            this.tag = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)tagId);
        }

        public static Variant getForBiome(Holder<Biome> biome) {
            for (Variant variant : OVERWORLD.values()) {
                if (!biome.is(variant.biomeTag)) continue;
                return variant;
            }
            return OAK;
        }

        public static Variant getRandom(RandomSource rand) {
            int len = OVERWORLD.size();
            return len > 0 ? (Variant)((Map.Entry)OVERWORLD.entrySet().asList().get(rand.nextInt(len))).getValue() : OAK;
        }

        public static Variant getByName(String n) {
            return (Variant)OVERWORLD.getOrDefault((Object)n, (Object)OAK);
        }

        @Override
        public TagKey<Block> getLogs() {
            return this.tag;
        }

        @Override
        public TagKey<Biome> getBiome() {
            return this.biomeTag;
        }

        @Override
        public BlockState getSapling() {
            return this.sapling.get().defaultBlockState();
        }

        @Override
        public ResourceLocation getDeathLootTable() {
            return this.deathLootTable;
        }

        @Override
        public ResourceLocation getTradeLootTable() {
            return this.tradeLootTable;
        }

        public String getSerializedName() {
            return this.name;
        }
    }

    class FindTreeGoal
    extends FindBlockGoal {
        public FindTreeGoal(int radius, int cooldown) {
            super(Dryad.this, radius, cooldown);
        }

        @Override
        public boolean canUse() {
            return (null == Dryad.this.getTreePos() || Dryad.this.getRandom().nextInt(500) == 0) && super.canUse();
        }

        @Override
        public boolean isTargetBlock(LevelReader worldIn, BlockPos pos) {
            if (!Dryad.isTreeAt((BlockGetter)worldIn, pos, Dryad.this.getVariant().getLogs())) {
                return false;
            }
            List dryads = Dryad.this.level().getEntitiesOfClass(Dryad.class, Dryad.this.getBoundingBox().inflate(10.0), e -> pos.equals((Object)e.treePos));
            return dryads.isEmpty();
        }

        @Override
        public void onFoundBlock(LevelReader worldIn, BlockPos target) {
            Dryad.this.setTreePos(target);
        }
    }

    class HideGoal
    extends Goal {
        private final int maxHidingTime;
        private final int maxCooldown;
        private int cooldown;

        public HideGoal(int maxHidingTimeIn) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.maxHidingTime = maxHidingTimeIn;
            this.maxCooldown = 120;
        }

        public boolean canUse() {
            if (this.cooldown > 0) {
                --this.cooldown;
            } else if (Dryad.this.treePos != null && Dryad.this.isWithinDistanceOfTree(1.5) && Dryad.this.getTarget() == null) {
                return Dryad.isTreeAt((BlockGetter)Dryad.this.level(), Dryad.this.treePos, Dryad.this.getVariant().getLogs());
            }
            return false;
        }

        public void start() {
            Dryad.this.setHiding(true);
            Dryad.this.isGoingToTree = false;
        }

        public void tick() {
            super.tick();
            Dryad.this.getNavigation().stop();
            Dryad.this.hidingTime = Math.min(Dryad.this.hidingTime + 1, this.maxHidingTime);
            if (Dryad.this.hidingTime >= this.maxHidingTime && Dryad.this.getRandom().nextInt(100) == 0 && Dryad.this.tryExitTree()) {
                this.cooldown = this.maxCooldown;
            }
        }

        public void stop() {
            Dryad.this.tryExitTree();
            this.cooldown = this.maxCooldown;
        }
    }

    class GoToTreeGoal
    extends Goal {
        private final double speed;
        private final int chance;

        public GoToTreeGoal(double speedIn, int chanceIn) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.speed = speedIn;
            this.chance = chanceIn;
        }

        public boolean canUse() {
            return !Dryad.this.isHiding() && Dryad.this.getTreePos() != null && Dryad.this.getTarget() == null && Dryad.this.getRandom().nextInt(this.chance) == 0;
        }

        public boolean canContinueToUse() {
            return Dryad.this.isGoingToTree && Dryad.this.getTreePos() != null && !Dryad.this.getNavigation().isDone() && Dryad.this.getTarget() == null;
        }

        public void start() {
            Dryad.this.isGoingToTree = true;
            Vec3 vec = Dryad.this.getTreeVec();
            Dryad.this.getNavigation().moveTo(vec.x(), vec.y(), vec.z(), this.speed);
        }

        public void stop() {
            Dryad.this.getNavigation().stop();
            Dryad.this.isGoingToTree = false;
        }
    }

    class RandomStrollWhenNotHidingGoal
    extends RandomStrollGoal {
        public RandomStrollWhenNotHidingGoal(double speed, int chance) {
            super((PathfinderMob)Dryad.this, speed, chance);
        }

        public boolean canUse() {
            return !Dryad.this.isHiding() && !Dryad.this.isGoingToTree && Dryad.this.getTarget() == null && super.canUse();
        }
    }
}

