/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import java.util.EnumSet;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class Elpis
extends PathfinderMob
implements FlyingAnimal {
    private static final EntityDataAccessor<Byte> STATE = SynchedEntityData.defineId(Elpis.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final String KEY_STATE = "ElpisState";
    private static final String KEY_HOME = "ElpisHome";
    private static final String KEY_AGE = "ElpisAge";
    private static final String KEY_DESPAWN_TIMER = "DespawnTimer";
    protected static final TagKey<Item> ELPIS_TRADE = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"elpis_trade"));
    protected static final Supplier<ItemStack> TRADE_RESULT = () -> new ItemStack((ItemLike)GFRegistry.ItemReg.ICHOR.get());
    public static final int wanderDistance = 8;
    private static final int maxAge = 4800;
    private static final int maxDespawnTime = 40;
    protected static final byte STATE_NONE = 5;
    protected static final byte STATE_TRADING = 6;
    protected static final byte STATE_DESPAWNING = 7;
    private static final byte DESPAWN_EVENT = 10;
    private static final byte TRADE_SUCCESS_EVENT = 11;
    private int despawnTime;
    private int age;

    public Elpis(EntityType<? extends Elpis> type, Level world) {
        super(type, world);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 24.0).add(Attributes.MOVEMENT_SPEED, 0.15).add(Attributes.ATTACK_DAMAGE, 0.5).add(Attributes.FLYING_SPEED, 0.4);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)5);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new DoNothingGoal());
        this.goalSelector.addGoal(2, (Goal)new TradeGoal(TRADE_RESULT, 80));
        this.goalSelector.addGoal(3, (Goal)new PanicGoal(1.0));
        this.goalSelector.addGoal(4, (Goal)new ElpisWanderGoal(20, 0.75));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void aiStep() {
        super.aiStep();
        ++this.age;
        if (this.despawnTime > 0 && this.despawnTime++ >= 40) {
            this.discard();
        }
    }

    public void tick() {
        super.tick();
        this.setNoGravity(true);
        if (this.level().isClientSide() && this.random.nextInt(9) == 0) {
            double radius = 0.25;
            if (this.isTrading()) {
                this.level().addParticle((ParticleOptions)ParticleTypes.INSTANT_EFFECT, this.getX() + (this.level().random.nextDouble() - 0.5) * 0.25, this.getEyeY() + (this.level().random.nextDouble() - 0.5) * 0.25 * 0.75, this.getZ() + (this.level().random.nextDouble() - 0.5) * 0.25, 0.0, 0.0, 0.0);
            } else {
                this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)1.0f, (float)0.6f, (float)0.92f), this.getX() + (this.level().random.nextDouble() - 0.5) * 0.25, this.getEyeY() + (this.level().random.nextDouble() - 0.5) * 0.25 * 0.75, this.getZ() + (this.level().random.nextDouble() - 0.5) * 0.25, 0.0, 0.0, 0.0);
            }
        }
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.isNoneState() && stack.is(ELPIS_TRADE)) {
            this.setState((byte)6);
            this.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)stack.getItem()));
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            player.setItemInHand(hand, stack);
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(player, hand);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundEvents.NOTE_BLOCK_CHIME.value();
    }

    protected float getSoundVolume() {
        return 0.8f;
    }

    public SoundSource getSoundSource() {
        return SoundSource.NEUTRAL;
    }

    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader worldIn) {
        return worldIn.isEmptyBlock(pos) ? 10.0f : 0.0f;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected PathNavigation createNavigation(Level worldIn) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, worldIn);
        flyingpathnavigator.setCanOpenDoors(false);
        flyingpathnavigator.setCanFloat(false);
        flyingpathnavigator.setCanPassDoors(true);
        return flyingpathnavigator;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte(KEY_STATE, ((Byte)this.getEntityData().get(STATE)).byteValue());
        compound.putInt(KEY_AGE, this.age);
        compound.putInt(KEY_DESPAWN_TIMER, this.despawnTime);
        if (this.getRestrictCenter() != BlockPos.ZERO && this.getRestrictRadius() > -1.0f) {
            compound.putInt("ElpisHome.x", this.getRestrictCenter().getX());
            compound.putInt("ElpisHome.y", this.getRestrictCenter().getY());
            compound.putInt("ElpisHome.z", this.getRestrictCenter().getZ());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.getEntityData().set(STATE, (Object)compound.getByte(KEY_STATE));
        this.age = compound.getInt(KEY_AGE);
        this.despawnTime = compound.getInt(KEY_DESPAWN_TIMER);
        if (compound.contains("ElpisHome.x")) {
            int x = compound.getInt("ElpisHome.x");
            int y = compound.getInt("ElpisHome.y");
            int z = compound.getInt("ElpisHome.z");
            this.restrictTo(new BlockPos(x, y, z), 8);
        }
    }

    public boolean removeWhenFarAway(double disToPlayer) {
        return this.isNoneState() && this.age > 4800 && disToPlayer > 12.0;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData result = super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
        this.setState((byte)5);
        this.setLeftHanded(false);
        return result;
    }

    public void setState(byte state) {
        this.getEntityData().set(STATE, (Object)state);
        if (state == 7) {
            this.despawnTime = 1;
            if (!this.level().isClientSide()) {
                this.level().broadcastEntityEvent((Entity)this, (byte)10);
            }
        }
    }

    public byte getState() {
        return (Byte)this.getEntityData().get(STATE);
    }

    public boolean isNoneState() {
        return this.getState() == 5;
    }

    public boolean isTrading() {
        return this.getState() == 6;
    }

    public boolean isDespawning() {
        return this.getState() == 7;
    }

    public void handleEntityEvent(byte id) {
        switch (id) {
            case 10: {
                this.setState((byte)7);
                break;
            }
            case 11: {
                this.playSound(SoundEvents.PLAYER_LEVELUP, 0.8f, 1.0f);
                break;
            }
            default: {
                super.handleEntityEvent(id);
            }
        }
    }

    public float getAlpha(float partialTick) {
        if (this.isRemoved()) {
            return 0.0f;
        }
        byte state = this.getState();
        switch (state) {
            case 6: {
                return 1.0f;
            }
            case 7: {
                return 1.0f - this.getDespawnPercent(partialTick);
            }
        }
        return 1.0f - Math.max(0.0f, Mth.cos((float)(((float)this.tickCount + partialTick) * 0.08f)) - 0.35f) * 0.45f;
    }

    public float getDespawnPercent(float partialTick) {
        return ((float)this.despawnTime - partialTick) / 40.0f;
    }

    public boolean isFlying() {
        return this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).isAir();
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.setFlags(EnumSet.allOf(Goal.Flag.class));
        }

        public boolean canUse() {
            return Elpis.this.isDespawning();
        }
    }

    class TradeGoal
    extends Goal {
        final Supplier<ItemStack> result;
        final int duration;
        Player player;
        int progress;

        public TradeGoal(Supplier<ItemStack> resultStack, int durationIn) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.result = resultStack;
            this.duration = durationIn;
        }

        public boolean canUse() {
            this.player = Elpis.this.level().getNearestPlayer((Entity)Elpis.this, 8.0);
            return this.player != null && Elpis.this.isTrading();
        }

        public void tick() {
            Elpis.this.getLookControl().setLookAt(Elpis.this.getEyePosition(1.0f).add(0.0, -0.125, 0.0));
            Elpis.this.getNavigation().stop();
            if (this.progress++ >= this.duration) {
                Vec3 tradeTarget;
                if (this.player != null) {
                    tradeTarget = this.player.position();
                } else {
                    tradeTarget = LandRandomPos.getPos((PathfinderMob)Elpis.this, (int)4, (int)2);
                    if (null == tradeTarget) {
                        tradeTarget = Elpis.this.position();
                    }
                }
                Vec3 tradeTargetPos = tradeTarget.add(0.0, 1.0, 0.0);
                BehaviorUtils.throwItem((LivingEntity)Elpis.this, (ItemStack)TRADE_RESULT.get(), (Vec3)tradeTargetPos);
                Elpis.this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                Elpis.this.setState((byte)7);
                Elpis.this.level().broadcastEntityEvent((Entity)Elpis.this, (byte)10);
            }
        }

        public void stop() {
            if (Elpis.this.isTrading()) {
                Elpis.this.setState((byte)5);
            }
            this.progress = 0;
        }
    }

    class PanicGoal
    extends net.minecraft.world.entity.ai.goal.PanicGoal {
        public PanicGoal(double speed) {
            super((PathfinderMob)Elpis.this, speed);
        }

        protected boolean findRandomPosition() {
            Vec3 vec3 = AirAndWaterRandomPos.getPos((PathfinderMob)Elpis.this, (int)5, (int)4, (int)-2, (double)(Elpis.this.random.nextInt(10) - 5), (double)(Elpis.this.random.nextInt(10) - 5), (double)1.5707963705062866);
            if (vec3 == null) {
                return false;
            }
            this.posX = vec3.x;
            this.posY = vec3.y;
            this.posZ = vec3.z;
            return true;
        }
    }

    class ElpisWanderGoal
    extends Goal {
        protected final double speed;
        protected final int chance;

        ElpisWanderGoal(int chance, double speed) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.speed = speed;
            this.chance = Math.min(1, chance);
        }

        public boolean canUse() {
            return Elpis.this.navigation.isDone() && !Elpis.this.isTrading() && Elpis.this.random.nextInt(this.chance) == 0;
        }

        public boolean canContinueToUse() {
            return Elpis.this.navigation.isInProgress();
        }

        public void start() {
            Vec3 vec3 = this.findPos();
            if (vec3 != null) {
                Elpis.this.navigation.moveTo(Elpis.this.navigation.createPath(new BlockPos((int)vec3.x, (int)vec3.y, (int)vec3.z), 1), this.speed);
            }
        }

        @Nullable
        private Vec3 findPos() {
            Vec3 targetPos;
            if (!Elpis.this.isWithinRestriction()) {
                Vec3 vec31 = Vec3.atCenterOf((Vec3i)Elpis.this.getRestrictCenter());
                targetPos = vec31.subtract(Elpis.this.position()).normalize();
            } else {
                targetPos = Elpis.this.getViewVector(0.0f);
            }
            Vec3 hoverVec = HoverRandomPos.getPos((PathfinderMob)Elpis.this, (int)8, (int)7, (double)targetPos.x, (double)targetPos.z, (float)1.5707964f, (int)3, (int)1);
            return hoverVec != null ? hoverVec : AirAndWaterRandomPos.getPos((PathfinderMob)Elpis.this, (int)8, (int)4, (int)-2, (double)targetPos.x, (double)targetPos.z, (double)1.5707963267948966);
        }
    }
}

