/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.enchantment.EnchantmentUtils;
import greekfantasy.entity.ai.MoveToStructureGoal;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class Gigante
extends PathfinderMob
implements NeutralMob {
    private static final int ATTACK_COOLDOWN = 32;
    private int attackCooldown;
    private static final UniformInt ANGER_RANGE = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;

    public Gigante(EntityType<? extends Gigante> type, Level level) {
        super(type, level);
        this.xpReward = 10;
        this.setPathfindingMalus(PathType.WATER, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.MOVEMENT_SPEED, 0.22).add(Attributes.KNOCKBACK_RESISTANCE, 0.9).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_DAMAGE, 5.5).add(Attributes.ATTACK_KNOCKBACK, 0.9750000000000001).add(Attributes.ARMOR, 5.0).add(Attributes.STEP_HEIGHT, (double)0.6f);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(3, (Goal)new GiganteAttackGoal(1.0, false));
        if (((Boolean)GreekFantasy.CONFIG.GIGANTE_SEEK_CAMP.get()).booleanValue()) {
            this.goalSelector.addGoal(4, (Goal)new MoveToStructureGoal((PathfinderMob)this, 1.0, 6, 15, 10, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"gigante_camp"), DefaultRandomPos::getPos));
        }
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.9));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Gigante)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public void aiStep() {
        super.aiStep();
        this.attackCooldown = Math.max(this.attackCooldown - 1, 0);
        if (this.level().isClientSide() && this.getDeltaMovement().horizontalDistanceSqr() > 2.500000277905201E-7 && this.random.nextInt(5) == 0) {
            int i = Mth.floor((double)this.getX());
            int j = Mth.floor((double)(this.getY() - (double)0.2f));
            int k = Mth.floor((double)this.getZ());
            BlockPos pos = new BlockPos(i, j, k);
            BlockState blockstate = this.level().getBlockState(pos);
            if (!blockstate.isAir()) {
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockstate).setPos(pos), this.getX() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), this.getY() + 0.1, this.getZ() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), 4.0 * ((double)this.random.nextFloat() - 0.5), 0.5, ((double)this.random.nextFloat() - 0.5) * 4.0);
            }
        }
        if (!this.level().isClientSide()) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    protected float getJumpPower() {
        return 1.2f * super.getJumpPower();
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (super.doHurtTarget(entityIn)) {
            double knockbackFactor = 0.2;
            Vec3 myPos = this.position();
            Vec3 ePos = entityIn.position();
            double dX = Math.signum(ePos.x - myPos.x) * 0.2;
            double dZ = Math.signum(ePos.z - myPos.z) * 0.2;
            entityIn.push(dX, 0.1, dZ);
            entityIn.hurtMarked = true;
            return true;
        }
        return false;
    }

    protected void dropEquipment() {
        ItemStack mainhand = this.getMainHandItem();
        if (mainhand.isDamageableItem()) {
            int damage = Mth.floor((float)((0.3f + 0.2f * this.random.nextFloat()) * (float)mainhand.getMaxDamage()));
            mainhand.setDamageValue(damage);
        }
        super.dropEquipment();
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        if (random.nextBoolean()) {
            Item club = random.nextBoolean() ? (Item)GFRegistry.ItemReg.STONE_CLUB.get() : (Item)GFRegistry.ItemReg.WOODEN_CLUB.get();
            ItemStack itemStack = new ItemStack((ItemLike)club);
            if (random.nextFloat() < 0.1f * difficulty.getSpecialMultiplier()) {
                EnchantmentUtils.enchant(this.level(), itemStack, (ResourceKey<Enchantment>)Enchantments.KNOCKBACK, 1);
            }
            this.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
            this.setDropChance(EquipmentSlot.MAINHAND, 0.165f);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType mobType, @Nullable SpawnGroupData spawnDataIn) {
        this.populateDefaultEquipmentSlots(this.getRandom(), difficulty);
        SpawnGroupData result = super.finalizeSpawn(worldIn, difficulty, mobType, spawnDataIn);
        return result;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.VILLAGER_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.VILLAGER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.VILLAGER_DEATH;
    }

    protected float getSoundVolume() {
        return 0.8f;
    }

    public float getVoicePitch() {
        return 0.12f;
    }

    public boolean canBeLeashed() {
        return false;
    }

    public boolean removeWhenFarAway(double dis) {
        return false;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.addPersistentAngerSaveData(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.readPersistentAngerSaveData(this.level(), compound);
    }

    public boolean isPushable() {
        return false;
    }

    public void push(Entity entityIn) {
        if (this.isPushable()) {
            super.push(entityIn);
        }
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_RANGE.sample(this.random));
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.angerTime = time;
    }

    public int getRemainingPersistentAngerTime() {
        return this.angerTime;
    }

    public void setPersistentAngerTarget(@Nullable UUID target) {
        this.angerTarget = target;
    }

    public UUID getPersistentAngerTarget() {
        return this.angerTarget;
    }

    public void setAttackCooldown() {
        this.attackCooldown = 32;
    }

    public boolean hasNoCooldown() {
        return this.attackCooldown <= 0;
    }

    class GiganteAttackGoal
    extends MeleeAttackGoal {
        public GiganteAttackGoal(double speedIn, boolean useLongMemory) {
            super((PathfinderMob)Gigante.this, speedIn, useLongMemory);
        }

        public void tick() {
            if (Gigante.this.hasNoCooldown()) {
                super.tick();
            }
        }

        protected void resetAttackCooldown() {
            super.resetAttackCooldown();
            Gigante.this.setAttackCooldown();
        }
    }
}

