/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootTable;

public class GoldenRam
extends Sheep
implements NeutralMob {
    public static final TagKey<Item> TRIGGER = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"golden_ram_trigger"));
    private static final UniformInt ANGER_RANGE = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;

    public GoldenRam(EntityType<? extends GoldenRam> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Sheep.createAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ARMOR, 4.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_KNOCKBACK, 1.5);
    }

    public static GoldenRam spawnGoldenRam(ServerLevel level, Player player, Sheep sheep) {
        GoldenRam entity = (GoldenRam)((EntityType)GFRegistry.EntityReg.GOLDEN_RAM.get()).create((Level)level);
        entity.copyPosition((Entity)sheep);
        entity.yBodyRot = sheep.yBodyRot;
        if (sheep.hasCustomName()) {
            entity.setCustomName(sheep.getCustomName());
            entity.setCustomNameVisible(sheep.isCustomNameVisible());
        }
        entity.setPersistenceRequired();
        entity.setPortalCooldown();
        entity.setAge(sheep.getAge());
        level.addFreshEntityWithPassengers((Entity)entity);
        entity.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(sheep.blockPosition()), MobSpawnType.CONVERSION, null);
        sheep.discard();
        entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 60));
        entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 60));
        entity.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 60));
        entity.playSound(SoundEvents.PLAYER_LEVELUP, 1.2f, 1.0f);
        return entity;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.54, true));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((GoldenRam)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide()) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
        if (this.isSheared()) {
            Sheep entity = (Sheep)EntityType.SHEEP.create(this.level());
            entity.copyPosition((Entity)this);
            entity.yBodyRot = this.yBodyRot;
            entity.setPortalCooldown();
            entity.setColor(this.getColor());
            entity.setSheared(true);
            entity.setAge(this.getAge());
            this.level().addFreshEntity((Entity)entity);
            this.discard();
        }
    }

    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level level, BlockPos pos, int fortune) {
        level.playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 0.8f);
        if (!level.isClientSide()) {
            this.setSheared(true);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            items.add(new ItemStack((ItemLike)GFRegistry.ItemReg.GOLDEN_FLEECE.get()));
            if (this.random.nextBoolean() || fortune > 0) {
                items.add(new ItemStack((ItemLike)GFRegistry.ItemReg.HORN.get()));
            }
            return items;
        }
        return Collections.emptyList();
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public ResourceKey<LootTable> getDefaultLootTable() {
        return this.getType().getDefaultLootTable();
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public boolean canMate(Animal otherAnimal) {
        return false;
    }

    @Nullable
    public Sheep getBreedOffspring(ServerLevel world, AgeableMob parentB) {
        return null;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData result = super.finalizeSpawn(level, difficulty, mobSpawnType, spawnDataIn);
        this.setColor(DyeColor.YELLOW);
        this.setBaby(false);
        return result;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.addPersistentAngerSaveData(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.readPersistentAngerSaveData(this.level(), compound);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_RANGE.sample(this.random));
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.angerTime = time;
    }

    public int getRemainingPersistentAngerTime() {
        return this.angerTime;
    }

    public void setPersistentAngerTarget(@Nullable UUID target) {
        this.angerTarget = target;
    }

    public UUID getPersistentAngerTarget() {
        return this.angerTarget;
    }
}

