/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import com.google.common.collect.ImmutableMap;
import greekfantasy.GFRegistry;
import greekfantasy.entity.Dryad;
import greekfantasy.entity.util.NymphVariant;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class Lampad
extends Dryad {
    protected static final TagKey<Item> LAMPAD_TRADES = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"lampad_trade"));

    public Lampad(EntityType<? extends Lampad> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, 0.28).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ARMOR, 4.0);
    }

    @Override
    public NymphVariant getVariantByName(String name) {
        return Variant.getByName(name);
    }

    @Override
    public NymphVariant getRandomVariant(RandomSource rand) {
        return Variant.getRandom(rand);
    }

    @Override
    public NymphVariant getVariantForBiome(Holder<Biome> biome) {
        return Variant.getForBiome(biome);
    }

    @Override
    public TagKey<Item> getTradeTag() {
        return LAMPAD_TRADES;
    }

    public static class Variant
    extends Dryad.Variant {
        public static final Variant CRIMSON = new Variant("crimson", ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"has_structure/huge_crimson_fungus"), () -> Blocks.CRIMSON_FUNGUS);
        public static final Variant WARPED = new Variant("warped", ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"has_structure/huge_warped_fungus"), () -> Blocks.WARPED_FUNGUS);
        public static final Variant POMEGRANATE = new Variant("greekfantasy", "pomegranate", (TagKey<Biome>)TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"is_nether_forest")), "lampad", "logs", (Supplier<Block>)GFRegistry.BlockReg.POMEGRANATE_SAPLING);
        public static ImmutableMap<String, Variant> NETHER = ImmutableMap.builder().put((Object)CRIMSON.getSerializedName(), (Object)CRIMSON).put((Object)POMEGRANATE.getSerializedName(), (Object)POMEGRANATE).put((Object)WARPED.getSerializedName(), (Object)WARPED).build();

        protected Variant(String nameIn, ResourceLocation biomeTag, Supplier<Block> saplingIn) {
            this("minecraft", nameIn, (TagKey<Biome>)TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)biomeTag), "lampad", "stems", saplingIn);
        }

        protected Variant(String modid, String nameIn, ResourceLocation biomeTag, Supplier<Block> saplingIn) {
            this(modid, nameIn, (TagKey<Biome>)TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)biomeTag), "lampad", "stems", saplingIn);
        }

        protected Variant(String modid, String nameIn, TagKey<Biome> biome, String entityIn, String tagSuffixIn, Supplier<Block> saplingIn) {
            super(modid, nameIn, biome, entityIn, tagSuffixIn, saplingIn);
        }

        public static Variant getForBiome(Holder<Biome> biome) {
            for (Variant variant : NETHER.values()) {
                if (!biome.is(variant.biomeTag)) continue;
                return variant;
            }
            return CRIMSON;
        }

        public static Variant getRandom(RandomSource rand) {
            int len = NETHER.size();
            return len > 0 ? (Variant)((Map.Entry)NETHER.entrySet().asList().get(rand.nextInt(len))).getValue() : CRIMSON;
        }

        public static Variant getByName(String n) {
            return (Variant)NETHER.getOrDefault((Object)n, (Object)CRIMSON);
        }
    }
}

