/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class Makhai
extends TamableAnimal {
    protected static final EntityDataAccessor<Byte> STATE = SynchedEntityData.defineId(Makhai.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    protected static final String KEY_STATE = "MakhaiState";
    protected static final String KEY_TAME = "MakhaiTame";
    private static final byte NONE = 0;
    private static final byte SPAWNING = 1;
    private static final byte DESPAWNING = 2;
    private static final byte SPAWN_EVENT = 9;
    private static final byte DESPAWN_EVENT = 10;
    protected final int maxSpawnTime = 15;
    protected int spawnTime;
    protected int despawnTime;

    public Makhai(EntityType<? extends Makhai> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.MOVEMENT_SPEED, 0.29).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ARMOR, 3.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new SpawningGoal());
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(3, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.78));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, false, false, e -> !this.isAlliedTo((Entity)e)));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, e -> e instanceof Enemy && !this.isAlliedTo((Entity)e)));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)0);
    }

    public void aiStep() {
        super.aiStep();
        if (this.isSpawning() && --this.spawnTime <= 0) {
            this.setSpawning(false);
        }
        if (this.isDespawning() && --this.despawnTime <= 0) {
            this.setDespawning(false);
            this.discard();
            return;
        }
        if (!(this.level().isClientSide() || this.isNoAi() || this.getTarget() != null && !this.getNavigation().isDone() || this.isDespawning() || this.random.nextInt(280) != 0)) {
            this.setDespawning(true);
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide() && (this.isSpawning() || this.isDespawning())) {
            double x = this.getX();
            double y = this.getY() + 0.5;
            double z = this.getZ();
            double motion = 0.06;
            double radius = (double)this.getBbWidth() * 1.15;
            for (int i = 0; i < 4; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, x + (this.level().random.nextDouble() - 0.5) * radius, y + (this.level().random.nextDouble() - 0.5) * radius, z + (this.level().random.nextDouble() - 0.5) * radius, (this.level().random.nextDouble() - 0.5) * 0.06, (this.level().random.nextDouble() - 0.5) * 0.07, (this.level().random.nextDouble() - 0.5) * 0.06);
            }
        }
    }

    public void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.IRON_SWORD));
        this.setItemInHand(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.GOLDEN_SWORD));
        this.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
        this.setDropChance(EquipmentSlot.OFFHAND, 0.0f);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData result = super.finalizeSpawn(worldIn, difficulty, mobSpawnType, spawnDataIn);
        this.populateDefaultEquipmentSlots(this.getRandom(), difficulty);
        this.setSpawning(true);
        this.setBaby(false);
        return result;
    }

    public boolean isFood(ItemStack item) {
        return false;
    }

    public byte getState() {
        return (Byte)this.getEntityData().get(STATE);
    }

    public void setState(byte state) {
        this.getEntityData().set(STATE, (Object)state);
    }

    public boolean isNoneState() {
        return this.getState() == 0;
    }

    public boolean isSpawning() {
        return this.getState() == 1;
    }

    public boolean isDespawning() {
        return this.getState() == 2;
    }

    public void setSpawning(boolean spawning) {
        if (spawning) {
            this.spawnTime = 15;
            this.setState((byte)1);
            if (!this.level().isClientSide()) {
                this.level().broadcastEntityEvent((Entity)this, (byte)9);
            }
        } else {
            this.spawnTime = 0;
            this.setState((byte)0);
        }
    }

    public void setDespawning(boolean despawning) {
        if (despawning) {
            this.despawnTime = 15;
            this.setState((byte)2);
            if (!this.level().isClientSide()) {
                this.level().broadcastEntityEvent((Entity)this, (byte)10);
            }
        } else {
            this.despawnTime = 0;
            this.setState((byte)0);
        }
    }

    public void handleEntityEvent(byte id) {
        switch (id) {
            case 9: {
                this.setSpawning(true);
                break;
            }
            case 10: {
                this.setDespawning(true);
                break;
            }
            default: {
                super.handleEntityEvent(id);
            }
        }
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.DROWNED_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.DROWNED_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.PHANTOM_DEATH;
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound(SoundEvents.ZOMBIE_STEP, 0.15f, 1.0f);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.isTame();
    }

    public boolean canBeLeashed() {
        return false;
    }

    public boolean canMate(Animal otherAnimal) {
        return false;
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob mate) {
        return null;
    }

    public void setOrderedToSit(boolean sitting) {
    }

    public void die(DamageSource cause) {
        this.setOwnerUUID(null);
        super.die(cause);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte(KEY_STATE, this.getState());
        compound.putBoolean(KEY_TAME, this.isTame());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setState(compound.getByte(KEY_STATE));
        this.setTame(compound.getBoolean(KEY_TAME), false);
    }

    public boolean canAttack(LivingEntity entity) {
        if (this.isOwnedBy(entity)) {
            return false;
        }
        if (this.isTame() && entity instanceof Player) {
            return false;
        }
        return super.canAttack(entity);
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        AbstractHorse horse;
        if (target instanceof Ghast) {
            return false;
        }
        if (target instanceof TamableAnimal) {
            TamableAnimal tamable = (TamableAnimal)target;
            return !tamable.isTame() || tamable.getOwner() != owner;
        }
        if (this.isTame() && target instanceof Player) {
            Player playerOwner;
            Player playerTarget = (Player)target;
            if (owner instanceof Player && !(playerOwner = (Player)owner).canHarmPlayer(playerTarget)) {
                return false;
            }
        }
        return !(target instanceof AbstractHorse) || !(horse = (AbstractHorse)target).isTamed();
    }

    class SpawningGoal
    extends Goal {
        public SpawningGoal() {
            this.setFlags(EnumSet.allOf(Goal.Flag.class));
        }

        public boolean canUse() {
            return Makhai.this.isSpawning() || Makhai.this.isDespawning();
        }

        public void tick() {
            Makhai.this.getNavigation().stop();
        }
    }
}

