/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import com.google.common.collect.ImmutableMap;
import greekfantasy.GFRegistry;
import greekfantasy.entity.Satyr;
import greekfantasy.entity.ai.GoToWaterGoal;
import greekfantasy.entity.ai.TridentRangedAttackGoal;
import greekfantasy.entity.ai.WaterAnimalMoveControl;
import greekfantasy.entity.boss.Charybdis;
import greekfantasy.entity.boss.Scylla;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootTable;

public class Naiad
extends PathfinderMob
implements RangedAttackMob,
NeutralMob {
    protected static final EntityDataAccessor<String> DATA_VARIANT = SynchedEntityData.defineId(Naiad.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    protected static final String KEY_VARIANT = "Variant";
    protected Variant variant = Variant.RIVER;
    protected final WaterBoundPathNavigation waterNavigation;
    protected final GroundPathNavigation groundNavigation;
    protected static final UniformInt ANGER_RANGE = TimeUtil.rangeOfSeconds((int)4, (int)10);
    protected int angerTime;
    protected UUID angerTarget;
    protected EntityDimensions swimmingDimensions;

    public Naiad(EntityType<? extends Naiad> type, Level level) {
        super(type, level);
        this.moveControl = new WaterAnimalMoveControl(this);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.waterNavigation = new WaterBoundPathNavigation((Mob)this, level);
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
        this.swimmingDimensions = EntityDimensions.scalable((float)0.48f, (float)0.48f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 24.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ARMOR, 1.0).add(Attributes.STEP_HEIGHT, 0.6);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT, (Object)Variant.OCEAN.getSerializedName());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new GoToWaterGoal(this, 1.0, false));
        this.goalSelector.addGoal(2, (Goal)new TridentRangedAttackGoal(this, 1.0, 40, 10.0f));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.1, false));
        this.goalSelector.addGoal(6, (Goal)new AvoidEntityGoal((PathfinderMob)this, Satyr.class, 10.0f, 1.2, 1.1));
        this.goalSelector.addGoal(6, (Goal)new AvoidEntityGoal((PathfinderMob)this, Charybdis.class, 12.0f, 1.0, 1.0));
        this.goalSelector.addGoal(6, (Goal)new AvoidEntityGoal((PathfinderMob)this, Scylla.class, 12.0f, 1.0, 1.0));
        this.goalSelector.addGoal(7, (Goal)new RandomSwimmingGoal(this, 0.8, 120){

            public boolean canUse() {
                return Naiad.this.isInWater() && super.canUse();
            }
        });
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal(this, 0.9){

            public boolean canUse() {
                return !Naiad.this.isInWater() && super.canUse();
            }
        });
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Naiad)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Drowned.class, false));
        this.targetSelector.addGoal(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public void baseTick() {
        int i = this.getAirSupply();
        super.baseTick();
        if (this.isInWater()) {
            this.setAirSupply(i);
        }
    }

    public void tick() {
        Level level;
        super.tick();
        if (this.isInWater() && this.getDeltaMovement().horizontalDistanceSqr() > 0.0012) {
            this.setPose(Pose.SWIMMING);
        } else if (this.getPose() == Pose.SWIMMING) {
            this.setPose(Pose.STANDING);
        }
        if (!this.level().isClientSide() && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getVariant() == Variant.OCEAN && this.hasEffect((Holder)GFRegistry.MobEffectReg.CURSE_OF_CIRCE)) {
                Scylla.spawnScylla(serverLevel, this);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, this.getX(), this.getY() + (double)this.getBbHeight() / 2.0, this.getZ(), 40, (double)this.getBbWidth(), (double)this.getBbHeight() / 2.0, (double)this.getBbWidth(), 0.0);
            }
        }
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_RANGE.sample(this.random));
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.angerTime = time;
    }

    public int getRemainingPersistentAngerTime() {
        return this.angerTime;
    }

    public void setPersistentAngerTarget(@Nullable UUID target) {
        this.angerTarget = target;
    }

    public UUID getPersistentAngerTarget() {
        return this.angerTarget;
    }

    public boolean doHurtTarget(Entity entity) {
        if (super.doHurtTarget(entity)) {
            if (entity.getUUID().equals(this.getPersistentAngerTarget())) {
                this.setPersistentAngerTarget(null);
            }
            return true;
        }
        return false;
    }

    public void setVariant(Variant variantIn) {
        this.variant = variantIn;
        this.getEntityData().set(DATA_VARIANT, (Object)variantIn.getSerializedName());
    }

    public Variant getVariant() {
        return this.variant;
    }

    public Variant getVariantByName(String name) {
        return Variant.getByName(name);
    }

    public Variant getRandomVariant(RandomSource rand) {
        return Variant.getRandom(rand);
    }

    public Variant getVariantForBiome(Holder<Biome> biome) {
        return Variant.getForBiome(biome);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key.equals(DATA_VARIANT)) {
            this.variant = this.getVariantByName((String)this.getEntityData().get(DATA_VARIANT));
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString(KEY_VARIANT, (String)this.getEntityData().get(DATA_VARIANT));
        this.addPersistentAngerSaveData(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setVariant(this.getVariantByName(compound.getString(KEY_VARIANT)));
        this.readPersistentAngerSaveData(this.level(), compound);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType mobType, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData result = super.finalizeSpawn(worldIn, difficultyIn, mobType, spawnDataIn);
        Variant variant = mobType == MobSpawnType.COMMAND || mobType == MobSpawnType.SPAWN_EGG || mobType == MobSpawnType.SPAWNER || mobType == MobSpawnType.DISPENSER ? this.getRandomVariant(this.getRandom()) : this.getVariantForBiome((Holder<Biome>)worldIn.getBiome(this.blockPosition()));
        this.setVariant(variant);
        this.populateDefaultEquipmentSlots(this.getRandom(), difficultyIn);
        return result;
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)this.getVariant().getDeathLootTable());
    }

    public boolean canBeLeashed() {
        return false;
    }

    protected int decreaseAirSupply(int airSupply) {
        return airSupply;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (source.getDirectEntity() instanceof ThrownTrident && source.getEntity() != null && source.getEntity().getType() == this.getType()) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        float tridentChance;
        float f = tridentChance = this.getVariant() == Variant.OCEAN ? 0.55f : 0.31f;
        if (random.nextFloat() < tridentChance) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.TRIDENT));
        }
    }

    public boolean checkSpawnObstruction(LevelReader level) {
        return level.isUnobstructed((Entity)this);
    }

    public boolean isPushedByFluid() {
        return !this.isSwimming();
    }

    public void updateSwimming() {
        if (!this.level().isClientSide) {
            if (this.isEffectiveAi() && this.isInWater()) {
                this.navigation = this.waterNavigation;
                this.setSwimming(true);
            } else {
                this.navigation = this.groundNavigation;
                this.setSwimming(false);
            }
        }
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        ThrownTrident throwntrident = new ThrownTrident(this.level(), (LivingEntity)this, new ItemStack((ItemLike)Items.TRIDENT));
        double d0 = target.getX() - this.getX();
        double d1 = target.getY(0.33) - throwntrident.getY();
        double d2 = target.getZ() - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        throwntrident.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
        this.playSound((SoundEvent)SoundEvents.TRIDENT_THROW.value(), 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)throwntrident);
    }

    public static class Variant
    implements StringRepresentable {
        public static final Variant RIVER = new Variant("river", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"is_river"));
        public static final Variant OCEAN = new Variant("ocean", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"is_ocean"));
        protected final String name;
        protected final TagKey<Biome> biomeTag;
        protected final ResourceLocation deathLootTable;
        public static ImmutableMap<String, Variant> WATER = ImmutableMap.builder().put((Object)RIVER.getSerializedName(), (Object)RIVER).put((Object)OCEAN.getSerializedName(), (Object)OCEAN).build();

        protected Variant(String nameIn, ResourceLocation biomeTag) {
            this.name = nameIn;
            this.biomeTag = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)biomeTag);
            this.deathLootTable = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)("entities/naiad/" + this.name));
        }

        public static Variant getForBiome(Holder<Biome> biome) {
            for (Variant variant : WATER.values()) {
                if (!biome.is(variant.biomeTag)) continue;
                return variant;
            }
            return RIVER;
        }

        public static Variant getRandom(RandomSource rand) {
            int len = WATER.size();
            return len > 0 ? (Variant)((Map.Entry)WATER.entrySet().asList().get(rand.nextInt(len))).getValue() : RIVER;
        }

        public static Variant getByName(String n) {
            return (Variant)WATER.getOrDefault((Object)n, (Object)RIVER);
        }

        public TagKey<Biome> getBiome() {
            return this.biomeTag;
        }

        public ResourceLocation getDeathLootTable() {
            return this.deathLootTable;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

