/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import greekfantasy.entity.ai.GFBegGoal;
import greekfantasy.entity.ai.ShootFireGoal;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class Orthus
extends TamableAnimal
implements NeutralMob {
    private static final EntityDataAccessor<Boolean> INTERESTED = SynchedEntityData.defineId(Orthus.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final TagKey<Item> FOOD = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"orthus_food"));
    protected static final String KEY_LIFE_TICKS = "LifeTicks";
    private static final byte CLIENT_START_FIRE_EVENT = 11;
    private static final byte CLIENT_STOP_FIRE_EVENT = 12;
    protected static final double FIRE_RANGE = 4.5;
    protected static final int MAX_FIRE_TIME = 52;
    protected static final UniformInt ANGER_RANGE = TimeUtil.rangeOfSeconds((int)20, (int)39);
    protected int angerTime;
    protected UUID angerTarget;
    protected boolean limitedLifespan;
    protected int limitedLifeTicks;
    protected int fireTime;
    private float interestedAngle;
    private float interestedAngle0;

    public Orthus(EntityType<? extends Orthus> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 24.0).add(Attributes.MOVEMENT_SPEED, 0.29).add(Attributes.ATTACK_DAMAGE, 4.5);
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(INTERESTED, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new OrthusBegGoal(8.0));
        this.goalSelector.addGoal(3, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(4, (Goal)new FireAttackGoal(52, 165, 4.5));
        this.goalSelector.addGoal(5, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(7, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 4.0f));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(9, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(11, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, e -> this.isAngryAt((LivingEntity)e) || this.wantsToAttack((LivingEntity)e, this.getOwner())));
        this.targetSelector.addGoal(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, e -> e.getType() == EntityType.STRIDER));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
        this.targetSelector.addGoal(7, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public void aiStep() {
        super.aiStep();
        if (this.limitedLifespan && --this.limitedLifeTicks <= 0) {
            this.limitedLifeTicks = 40;
            this.hurt(this.damageSources().starve(), 1.0f);
        }
    }

    public void tick() {
        super.tick();
        if (this.isAlive()) {
            this.interestedAngle0 = this.interestedAngle;
            this.interestedAngle = this.isInterested() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
            if (this.level().isClientSide() && this.isFireAttack()) {
                this.spawnFireParticles();
            }
        }
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        return effectInstance.getEffect().value() != MobEffects.WITHER && super.canBeAffected(effectInstance);
    }

    public boolean wantsToAttack(LivingEntity target, @Nullable LivingEntity owner) {
        AbstractHorse horse;
        if (target instanceof Ghast) {
            return false;
        }
        if (target instanceof TamableAnimal) {
            TamableAnimal tamable = (TamableAnimal)target;
            return !tamable.isTame() || tamable.getOwner() != owner;
        }
        if (target instanceof Player) {
            Player ownerPlayer;
            Player targetPlayer = (Player)target;
            if (owner instanceof Player && !(ownerPlayer = (Player)owner).canHarmPlayer(targetPlayer)) {
                return false;
            }
        }
        return !(target instanceof AbstractHorse) || !(horse = (AbstractHorse)target).isTamed();
    }

    public boolean canBeLeashed() {
        return true;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_RANGE.sample(this.random));
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.angerTime = time;
    }

    public int getRemainingPersistentAngerTime() {
        return this.angerTime;
    }

    public void setPersistentAngerTarget(@Nullable UUID target) {
        this.angerTarget = target;
    }

    public UUID getPersistentAngerTarget() {
        return this.angerTarget;
    }

    public float getTailAngle() {
        if (this.isAngry()) {
            return 1.5393804f;
        }
        return this.isTame() ? (0.55f - (this.getMaxHealth() - this.getHealth()) * 0.02f) * (float)Math.PI : 0.62831855f;
    }

    public void setLimitedLife(int life) {
        this.limitedLifespan = true;
        this.limitedLifeTicks = life;
    }

    protected SoundEvent getAmbientSound() {
        if (this.random.nextInt(3) == 0) {
            return SoundEvents.WOLF_AMBIENT;
        }
        if (this.random.nextInt(3) == 0) {
            return SoundEvents.WOLF_PANT;
        }
        return SoundEvents.WOLF_GROWL;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.WOLF_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.WOLF_DEATH;
    }

    protected float getSoundVolume() {
        return 0.8f;
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound(SoundEvents.WOLF_STEP, 0.15f, 1.0f);
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return this.limitedLifespan ? BuiltInLootTables.EMPTY : super.getDefaultLootTable();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.limitedLifespan) {
            compound.putInt(KEY_LIFE_TICKS, this.limitedLifeTicks);
        }
        this.addPersistentAngerSaveData(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains(KEY_LIFE_TICKS)) {
            this.setLimitedLife(compound.getInt(KEY_LIFE_TICKS));
        }
        this.readPersistentAngerSaveData(this.level(), compound);
    }

    public void spawnFireParticles() {
        if (!this.level().isClientSide()) {
            return;
        }
        Vec3 lookVec = this.getLookAngle();
        Vec3 pos = this.getEyePosition(1.0f);
        double motion = 0.06;
        double radius = 0.75;
        for (int i = 0; i < 5; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, pos.x + (this.level().random.nextDouble() - 0.5) * 0.75, pos.y + (this.level().random.nextDouble() - 0.5) * 0.75, pos.z + (this.level().random.nextDouble() - 0.5) * 0.75, lookVec.x * 0.06 * 4.5, lookVec.y * 0.06 * 0.5, lookVec.z * 0.06 * 4.5);
        }
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob parent) {
        Orthus baby = (Orthus)((EntityType)GFRegistry.EntityReg.ORTHUS.get()).create((Level)level);
        UUID uuid = this.getOwnerUUID();
        if (uuid != null) {
            baby.setOwnerUUID(uuid);
            baby.setTame(true, false);
        }
        return baby;
    }

    public void setTame(boolean tamed, boolean applyTamingSideEffects) {
        super.setTame(tamed, applyTamingSideEffects);
        if (tamed) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(36.0);
            this.setHealth(36.0f);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(24.0);
        }
    }

    public void tame(Player player) {
        super.tame(player);
        this.setFireAttack(false);
        this.setTarget(null);
        this.setLastHurtByMob(null);
        this.forgetCurrentTargetAndRefreshUniversalAnger();
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(FOOD);
    }

    public boolean canMate(Animal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.isTame()) {
            return false;
        }
        if (!(otherAnimal instanceof Orthus)) {
            return false;
        }
        Orthus orthus = (Orthus)otherAnimal;
        if (!orthus.isTame()) {
            return false;
        }
        if (orthus.isInSittingPose()) {
            return false;
        }
        return this.isInLove() && orthus.isInLove();
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (this.level().isClientSide()) {
            boolean flag = this.isOwnedBy((LivingEntity)player) || this.isTame() || heldItem.is(FOOD) && !this.isTame();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.isTame()) {
            if (this.isFood(heldItem) && this.getHealth() < this.getMaxHealth()) {
                if (!player.isCreative()) {
                    heldItem.shrink(1);
                }
                this.heal(heldItem.getFoodProperties((LivingEntity)this) != null ? (float)heldItem.getFoodProperties((LivingEntity)this).nutrition() : 1.0f);
                return InteractionResult.SUCCESS;
            }
            InteractionResult actionresulttype = super.mobInteract(player, hand);
            if ((!actionresulttype.consumesAction() || this.isBaby()) && this.isOwnedBy((LivingEntity)player)) {
                this.setOrderedToSit(!this.isOrderedToSit());
                this.jumping = false;
                this.navigation.stop();
                this.setFireAttack(false);
                this.setTarget(null);
                this.setLastHurtByMob(null);
                this.forgetCurrentTargetAndRefreshUniversalAnger();
                return InteractionResult.SUCCESS;
            }
            return actionresulttype;
        }
        if (heldItem.is(FOOD)) {
            if (this.isAngry()) {
                this.setPersistentAngerTarget(null);
            }
            if (!player.isCreative()) {
                heldItem.shrink(1);
            }
            if (this.random.nextInt(4) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)player)) {
                this.tame(player);
                this.setFireAttack(false);
                this.setTarget(null);
                this.setLastHurtByMob(null);
                this.forgetCurrentTargetAndRefreshUniversalAnger();
                this.navigation.stop();
                this.setTarget(null);
                this.setOrderedToSit(true);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void handleEntityEvent(byte event) {
        switch (event) {
            case 11: {
                this.setFireAttack(true);
                break;
            }
            case 12: {
                this.setFireAttack(false);
                break;
            }
            default: {
                super.handleEntityEvent(event);
            }
        }
    }

    public void setInterested(boolean interested) {
        this.getEntityData().set(INTERESTED, (Object)interested);
    }

    public boolean isInterested() {
        return (Boolean)this.getEntityData().get(INTERESTED);
    }

    public float getHeadRollAngle(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.interestedAngle0, (float)this.interestedAngle) * 0.15f * (float)Math.PI;
    }

    public void setFireAttack(boolean shooting) {
        if (shooting) {
            this.fireTime = 52;
            if (!this.level().isClientSide()) {
                this.level().broadcastEntityEvent((Entity)this, (byte)11);
            }
        } else {
            this.fireTime = 0;
            if (!this.level().isClientSide()) {
                this.level().broadcastEntityEvent((Entity)this, (byte)12);
            }
        }
    }

    public boolean isFireAttack() {
        return this.fireTime > 0;
    }

    class OrthusBegGoal
    extends GFBegGoal {
        protected OrthusBegGoal(double rangeIn) {
            super((Mob)Orthus.this, rangeIn, 10, item -> item.is(FOOD));
        }

        public void start() {
            super.start();
            if (Orthus.this.isFireAttack()) {
                Orthus.this.setFireAttack(false);
            }
            Orthus.this.setInterested(true);
        }

        @Override
        public void tick() {
            super.tick();
        }

        public void stop() {
            super.stop();
            Orthus.this.setInterested(false);
        }
    }

    class FireAttackGoal
    extends ShootFireGoal {
        protected FireAttackGoal(int fireTimeIn, int maxCooldownIn, double fireRange) {
            super((Mob)Orthus.this, fireTimeIn, maxCooldownIn, fireRange);
        }

        @Override
        public boolean canUse() {
            return super.canUse() && !Orthus.this.isFireAttack() && !Orthus.this.isOrderedToSit() && !Orthus.this.isInSittingPose();
        }

        @Override
        public boolean canContinueToUse() {
            return Orthus.this.getTarget() != null && Orthus.this.wantsToAttack(Orthus.this.getTarget(), Orthus.this.getOwner()) && !Orthus.this.getTarget().fireImmune() && Orthus.this.isFireAttack() && super.canContinueToUse();
        }

        @Override
        public void start() {
            super.start();
            Orthus.this.setFireAttack(true);
        }

        @Override
        public void tick() {
            super.tick();
        }

        @Override
        public void stop() {
            super.stop();
            Orthus.this.setFireAttack(false);
        }
    }
}

