/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import com.google.common.collect.ImmutableList;
import greekfantasy.GFRegistry;
import greekfantasy.block.PalladiumLightBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class Palladium
extends LivingEntity {
    public long lastHit;

    public Palladium(EntityType<? extends Palladium> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    public static Palladium createPalladium(Level level, BlockPos pos, Direction facing) {
        Palladium entity = (Palladium)((EntityType)GFRegistry.EntityReg.PALLADIUM.get()).create(level);
        float f = facing.toYRot();
        entity.absMoveTo((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, f, 0.0f);
        entity.yHeadRot = f;
        entity.yBodyRot = f;
        return entity;
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(Entity entityIn) {
    }

    protected void pushEntities() {
    }

    public boolean attackable() {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void kill() {
        this.remove(Entity.RemovalReason.KILLED);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (!this.level().isClientSide && !this.isRemoved()) {
            if (this.damageSources().outOfBorder().equals(source)) {
                this.kill();
                return false;
            }
            if (!this.isInvulnerableTo(source)) {
                if (source.is(DamageTypeTags.IS_EXPLOSION)) {
                    this.brokenByAnything(source);
                    this.kill();
                    return false;
                }
                if (this.damageSources().inFire().equals(source)) {
                    if (this.isOnFire()) {
                        this.causeDamage(source, 0.15f);
                    } else {
                        this.igniteForSeconds(5.0f);
                    }
                    return false;
                }
                if (this.damageSources().onFire().equals(source) && this.getHealth() > 0.5f) {
                    this.causeDamage(source, 4.0f);
                    return false;
                }
                boolean flag = source.getDirectEntity() instanceof AbstractArrow;
                boolean flag1 = flag && ((AbstractArrow)source.getDirectEntity()).getPierceLevel() > 0;
                boolean flag2 = "player".equals(source.getMsgId());
                if (!flag2 && !flag) {
                    return false;
                }
                if (source.getEntity() instanceof Player && !((Player)source.getEntity()).getAbilities().mayBuild) {
                    return false;
                }
                if (source.isCreativePlayer()) {
                    this.playBrokenSound();
                    this.showBreakingParticles();
                    this.kill();
                    return flag1;
                }
                long i = this.level().getGameTime();
                if (i - this.lastHit > 5L && !flag) {
                    this.level().broadcastEntityEvent((Entity)this, (byte)32);
                    this.lastHit = i;
                } else {
                    this.brokenByPlayer(source);
                    this.showBreakingParticles();
                    this.kill();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public Iterable<ItemStack> getArmorSlots() {
        return ImmutableList.of();
    }

    public ItemStack getItemBySlot(EquipmentSlot p_21127_) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot p_21036_, ItemStack p_21037_) {
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide && this.tickCount % 4 == 1) {
            BlockPos posIn = this.getOnPos().above();
            BlockState blockIn = this.level().getBlockState(posIn);
            if (!(!blockIn.isAir() && blockIn.getFluidState().isEmpty() || ((Block)GFRegistry.BlockReg.LIGHT.get()).defaultBlockState().is(blockIn.getBlock()))) {
                boolean waterlogged = blockIn.getFluidState().isSource() && blockIn.getFluidState().is(FluidTags.WATER);
                BlockState lightBlock = (BlockState)((BlockState)((Block)GFRegistry.BlockReg.LIGHT.get()).defaultBlockState().setValue((Property)PalladiumLightBlock.LEVEL, (Comparable)Integer.valueOf(11))).setValue((Property)PalladiumLightBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
                this.level().setBlock(posIn, lightBlock, 3);
            }
        }
    }

    private void showBreakingParticles() {
        if (this.level() instanceof ServerLevel) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.STONE.defaultBlockState()), this.getX(), this.getY(0.66), this.getZ(), 10, (double)(this.getBbWidth() / 4.0f), (double)(this.getBbHeight() / 4.0f), (double)(this.getBbWidth() / 4.0f), 0.05);
        }
    }

    private void causeDamage(DamageSource source, float amount) {
        float f = this.getHealth();
        if ((f -= amount) <= 0.5f) {
            this.brokenByAnything(source);
            this.kill();
        } else {
            this.setHealth(f);
        }
    }

    private void brokenByPlayer(DamageSource p_213815_1_) {
        ItemStack altarItem = new ItemStack((ItemLike)GFRegistry.ItemReg.PALLADIUM.get());
        Block.popResource((Level)this.level(), (BlockPos)this.blockPosition().above(), (ItemStack)altarItem);
        this.brokenByAnything(p_213815_1_);
    }

    private void brokenByAnything(DamageSource source) {
        this.playBrokenSound();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.dropAllDeathLoot(serverLevel, source);
        }
    }

    private void playBrokenSound() {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.STONE_BREAK, this.getSoundSource(), 1.0f, 1.0f);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
    }

    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }
}

