/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import greekfantasy.entity.util.HasHorseVariant;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.Vec3;

public class Pegasus
extends AbstractHorse
implements FlyingAnimal,
HasHorseVariant {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(Pegasus.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final String KEY_VARIANT = "Variant";
    private static final int FLYING_INTERVAL = 8;
    protected int flyingTime;
    protected boolean isFlying;
    protected GroundPathNavigation groundNavigation;
    protected FlyingPathNavigation flyingNavigation;

    public Pegasus(EntityType<? extends Pegasus> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractHorse.createBaseHorseAttributes().add(Attributes.ARMOR, 1.0).add(Attributes.GRAVITY, 0.04).add(Attributes.FLYING_SPEED, (double)1.32f);
    }

    protected PathNavigation createNavigation(Level level) {
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
        this.flyingNavigation = new FlyingPathNavigation((Mob)this, level);
        return this.groundNavigation;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)0);
    }

    public void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(4, (Goal)new AvoidPlayersGoal(this, this));
    }

    public PathNavigation getNavigation() {
        if (this.isPassenger() && this.getVehicle() instanceof Mob) {
            Mob mob = (Mob)this.getVehicle();
            return mob.getNavigation();
        }
        if (this.isFlying()) {
            return this.flyingNavigation;
        }
        return this.groundNavigation;
    }

    public void aiStep() {
        super.aiStep();
        if (this.flyingTime > 0) {
            --this.flyingTime;
        }
        if (!this.isVehicle()) {
            this.isFlying = false;
        }
        this.setOnGround(true);
        if (this.isVehicle() && this.getDeltaMovement().y < -0.1) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.95, 1.0));
        }
        if (this.position().y > (double)(this.level().getHeight() + 16)) {
            this.hurt(this.damageSources().outOfBorder(), 2.0f);
        }
    }

    public boolean requiresCustomPersistence() {
        return this.isTamed() || super.requiresCustomPersistence();
    }

    protected void randomizeAttributes(RandomSource random) {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)this.generateRandomMaxHealth(random));
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(this.generateRandomSpeed(random));
        this.getAttribute(Attributes.JUMP_STRENGTH).setBaseValue(this.generateRandomJumpStrength(random));
        this.getAttribute(Attributes.FLYING_SPEED).setBaseValue(this.getAttributeValue(Attributes.MOVEMENT_SPEED) + 1.15);
    }

    protected float generateRandomMaxHealth(RandomSource random) {
        return AbstractHorse.generateMaxHealth(arg_0 -> ((RandomSource)random).nextInt(arg_0)) + 10.0f;
    }

    protected double generateRandomJumpStrength(RandomSource random) {
        return AbstractHorse.generateJumpStrength(() -> ((RandomSource)random).nextDouble()) + (double)0.2f;
    }

    protected double generateRandomSpeed(RandomSource random) {
        return AbstractHorse.generateSpeed(() -> ((RandomSource)random).nextDouble());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnDataIn) {
        Variant color;
        if (spawnDataIn instanceof Horse.HorseGroupData) {
            color = ((Horse.HorseGroupData)spawnDataIn).variant;
        } else {
            color = (Variant)Util.getRandom((Object[])Variant.values(), (RandomSource)this.getRandom());
            spawnDataIn = new Horse.HorseGroupData(color);
        }
        this.setVariant(color, (Markings)Util.getRandom((Object[])Markings.values(), (RandomSource)this.getRandom()));
        return super.finalizeSpawn(worldIn, difficulty, mobSpawnType, spawnDataIn);
    }

    public boolean canJump() {
        return super.canJump() && this.flyingTime <= 0;
    }

    public void onPlayerJump(int jumpPowerIn) {
    }

    public void flyingJump() {
        if (this.flyingTime <= 0 && this.canJump()) {
            float jumpMotion = this.getJumpPower() + 0.82f;
            this.push(0.0, jumpMotion, 0.0);
            this.markHurt();
            this.setOnGround(true);
            this.flyingTime = 8;
            this.isFlying = true;
        }
    }

    public void handleStartJump(int jumpPower) {
        if (!this.onGround()) {
            this.setStanding(false);
        }
    }

    public boolean isJumping() {
        return false;
    }

    public boolean isFlying() {
        double flyingMotion = this.isBaby() ? 0.02 : 0.06;
        return !this.onGround() || this.getDeltaMovement().lengthSqr() > flyingMotion;
    }

    protected int calculateFallDamage(float distance, float damageMultiplier) {
        return 0;
    }

    public void travel(Vec3 vec) {
        super.travel(vec);
    }

    protected void playGallopSound(SoundType sound) {
        super.playGallopSound(sound);
        if (this.random.nextInt(10) == 0) {
            this.playSound(SoundEvents.HORSE_BREATHE, sound.getVolume() * 0.6f, sound.getPitch());
        }
    }

    protected SoundEvent getAmbientSound() {
        super.getAmbientSound();
        return SoundEvents.HORSE_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        super.getDeathSound();
        return SoundEvents.HORSE_DEATH;
    }

    protected SoundEvent getEatingSound() {
        return SoundEvents.HORSE_EAT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        super.getHurtSound(damageSourceIn);
        return SoundEvents.HORSE_HURT;
    }

    protected SoundEvent getAngrySound() {
        super.getAngrySound();
        return SoundEvents.HORSE_ANGRY;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (!this.isBaby()) {
            if (this.isTamed() && player.isSecondaryUseActive()) {
                this.openCustomInventoryScreen(player);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
            }
            if (this.isVehicle()) {
                return super.mobInteract(player, hand);
            }
            if (itemstack.isEmpty() && this.isTamed() || itemstack.is((Item)GFRegistry.ItemReg.GOLDEN_BRIDLE.get())) {
                this.doPlayerRide(player);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
            }
        }
        if (!itemstack.isEmpty()) {
            boolean isUsableSaddle;
            if (this.isFood(itemstack)) {
                return this.fedFood(player, itemstack);
            }
            InteractionResult actionresulttype = itemstack.interactLivingEntity(player, (LivingEntity)this, hand);
            if (actionresulttype.consumesAction()) {
                return actionresulttype;
            }
            if (!this.isTamed()) {
                this.makeMad();
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
            }
            boolean bl = isUsableSaddle = !this.isBaby() && !this.isSaddled() && itemstack.is(Items.SADDLE);
            if (this.isBodyArmorItem(itemstack) || isUsableSaddle) {
                this.openCustomInventoryScreen(player);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
            }
        }
        return super.mobInteract(player, hand);
    }

    public int getMaxTemper() {
        return 150;
    }

    public boolean canMate(Animal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        return otherAnimal instanceof Pegasus && this.canParent() && ((Pegasus)otherAnimal).canParent();
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob mate) {
        Pegasus pegasusMate = (Pegasus)mate;
        Pegasus child = (Pegasus)((EntityType)GFRegistry.EntityReg.PEGASUS.get()).create((Level)world);
        int i = this.random.nextInt(9);
        Variant coatcolors = i < 4 ? this.getVariant() : (i < 8 ? pegasusMate.getVariant() : (Variant)Util.getRandom((Object[])Variant.values(), (RandomSource)this.random));
        int j = this.random.nextInt(5);
        Markings coattypes = j < 2 ? this.getMarkings() : (j < 4 ? pegasusMate.getMarkings() : (Markings)Util.getRandom((Object[])Markings.values(), (RandomSource)this.random));
        child.setVariant(coatcolors, coattypes);
        this.setOffspringAttributes(mate, child);
        return child;
    }

    @Override
    public void setPackedVariant(int packedColorsTypes) {
        this.entityData.set(VARIANT, (Object)packedColorsTypes);
    }

    @Override
    public int getPackedVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt(KEY_VARIANT, this.getPackedVariant());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setPackedVariant(compound.getInt(KEY_VARIANT));
    }

    class AvoidPlayersGoal
    extends AvoidEntityGoal<Player> {
        public AvoidPlayersGoal(Pegasus this$0, Pegasus pegasus) {
            super((PathfinderMob)pegasus, Player.class, 16.0f, 1.2, 1.1, entity -> !entity.isDiscrete() && !pegasus.isVehicle() && (!pegasus.isTamed() || pegasus.getOwnerUUID() == null || !entity.getUUID().equals(pegasus.getOwnerUUID())));
        }

        public boolean canUse() {
            return super.canUse();
        }
    }
}

