/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.ai.MoveToStructureGoal;
import greekfantasy.entity.ai.SummonMobGoal;
import greekfantasy.entity.util.HasHorseVariant;
import greekfantasy.item.InstrumentItem;
import greekfantasy.util.SongManager;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class Satyr
extends PathfinderMob
implements NeutralMob,
HasHorseVariant {
    private static final EntityDataAccessor<Byte> DATA_STATE = SynchedEntityData.defineId(Satyr.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> DATA_SHAMAN = SynchedEntityData.defineId(Satyr.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.defineId(Satyr.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final String KEY_SHAMAN = "Shaman";
    public static final String KEY_VARIANT = "Variant";
    private static final ResourceLocation SUMMONING_SONG = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"sarias_song");
    protected static final byte NONE = 0;
    protected static final byte DANCING = 1;
    protected static final byte SUMMONING = 2;
    protected static final byte PLAY_SUMMON_SOUND = 12;
    protected static final int MAX_SUMMON_TIME = 160;
    protected static final int MAX_PANFLUTE_TIME = 10;
    public int holdingPanfluteTime;
    public int summonTime;
    public boolean hasShamanTexture;
    protected static final UniformInt ANGER_RANGE = TimeUtil.rangeOfSeconds((int)20, (int)39);
    protected int angerTime;
    protected UUID angerTarget;
    public static final BiPredicate<BlockState, Boolean> IS_CAMPFIRE = (state, lit) -> state.is(BlockTags.CAMPFIRES) && state.hasProperty((Property)CampfireBlock.LIT) && state.getValue((Property)CampfireBlock.LIT) == lit && (!state.hasProperty((Property)BlockStateProperties.WATERLOGGED) || (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) == false);
    protected BlockPos dancingAround = null;
    protected final Goal meleeAttackGoal;
    protected final Goal summonAnimalsGoal;

    public Satyr(EntityType<? extends Satyr> type, Level level) {
        super(type, level);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.meleeAttackGoal = new MeleeAttackGoal((PathfinderMob)this, 1.0, false);
        this.summonAnimalsGoal = new SummonWolfGoal(160, 480);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 28.0).add(Attributes.MOVEMENT_SPEED, 0.35).add(Attributes.ATTACK_DAMAGE, 2.5);
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_STATE, (Object)0);
        builder.define(DATA_SHAMAN, (Object)Boolean.FALSE);
        builder.define(DATA_VARIANT, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new DancingGoal(0.75, 880));
        this.goalSelector.addGoal(3, (Goal)new PanicGoal(1.3));
        this.goalSelector.addGoal(4, (Goal)new StartDancingGoal(0.9, 22, 12, 420));
        this.goalSelector.addGoal(5, (Goal)new LightCampfireGoal(0.9, 12, 10, 60, 500));
        if (((Boolean)GreekFantasy.CONFIG.SATYR_SEEK_CAMP.get()).booleanValue()) {
            this.goalSelector.addGoal(6, (Goal)new MoveToStructureGoal((PathfinderMob)this, 1.0, 2, 8, 4, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"satyr_camp"), DefaultRandomPos::getPos));
        }
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal(this, 0.8, 160.0f){

            public boolean canUse() {
                return Satyr.this.isIdleState() && Satyr.this.getTarget() == null && super.canUse();
            }
        });
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new SatyrHurtByTargetGoal());
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Satyr)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide()) {
            if (this.isSummoning()) {
                SongManager.playMusic((LivingEntity)this, (InstrumentItem)((Object)GFRegistry.ItemReg.PANFLUTE.get()), SUMMONING_SONG, this.summonTime, 0.92f, 0.34f);
            } else if (this.isDancing()) {
                SongManager.playMusic((LivingEntity)this, (InstrumentItem)((Object)GFRegistry.ItemReg.PANFLUTE.get()), GreekFantasy.CONFIG.getSatyrSong(), this.level().getGameTime(), 0.84f, 0.28f);
            }
        } else {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
        this.holdingPanfluteTime = this.isDancing() || this.isSummoning() ? Math.min(this.holdingPanfluteTime + 1, 10) : Math.max(this.holdingPanfluteTime - 1, 0);
        if (this.summonTime > 0) {
            this.summonTime = Math.min(this.summonTime + 1, 160);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean attackEntityFrom = super.hurt(source, amount);
        if (attackEntityFrom && source.getDirectEntity() instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)source.getDirectEntity();
            List shamans = this.getCommandSenderWorld().getEntitiesOfClass(Satyr.class, this.getBoundingBox().inflate(10.0), e -> e.isShaman());
            for (Satyr shaman : shamans) {
                if (shaman.getTarget() != null) continue;
                shaman.setLastHurtByMob(target);
                shaman.setPersistentAngerTarget(target.getUUID());
                shaman.startPersistentAngerTimer();
            }
        }
        return attackEntityFrom;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (super.isInvulnerableTo(source)) {
            return true;
        }
        return source == this.damageSources().inFire();
    }

    public boolean canBeLeashed() {
        return false;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnDataIn) {
        if (spawnType != MobSpawnType.STRUCTURE) {
            Variant color;
            if (spawnDataIn instanceof GroupData) {
                color = ((GroupData)spawnDataIn).variant;
            } else {
                color = (Variant)Util.getRandom((Object[])Variant.values(), (RandomSource)this.getRandom());
                spawnDataIn = new GroupData(color);
            }
            this.setVariant(color);
        }
        this.setShaman((double)(this.getRandom().nextFloat() * 100.0f) < (Double)GreekFantasy.CONFIG.SATYR_SHAMAN_CHANCE.get());
        return super.finalizeSpawn(worldIn, difficulty, spawnType, spawnDataIn);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key == DATA_SHAMAN) {
            this.updateCombatAI();
            this.hasShamanTexture = this.isShaman();
        } else if (key == DATA_STATE) {
            this.summonTime = this.isSummoning() ? 1 : 0;
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 12) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.WOLF_HOWL, this.getSoundSource(), 1.1f, 0.9f + this.getRandom().nextFloat() * 0.2f, false);
            this.summonTime = 1;
        } else {
            super.handleEntityEvent(id);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean(KEY_SHAMAN, this.isShaman());
        compound.putByte(KEY_VARIANT, (byte)this.getVariant().getId());
        this.addPersistentAngerSaveData(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setShaman(compound.getBoolean(KEY_SHAMAN));
        this.setVariant(Variant.byId((int)compound.getByte(KEY_VARIANT)));
        this.readPersistentAngerSaveData(this.level(), compound);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_RANGE.sample(this.random));
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.angerTime = time;
    }

    public int getRemainingPersistentAngerTime() {
        return this.angerTime;
    }

    public void setPersistentAngerTarget(@Nullable UUID target) {
        this.angerTarget = target;
    }

    public UUID getPersistentAngerTarget() {
        return this.angerTarget;
    }

    public byte getSatyrState() {
        return (Byte)this.getEntityData().get(DATA_STATE);
    }

    public boolean isIdleState() {
        return this.getSatyrState() == 0;
    }

    public void setIdleState() {
        this.getEntityData().set(DATA_STATE, (Object)0);
    }

    public boolean isDancing() {
        return this.getSatyrState() == 1;
    }

    public void setDancing(boolean dancing) {
        this.getEntityData().set(DATA_STATE, (Object)(dancing ? (byte)1 : 0));
    }

    public boolean isSummoning() {
        return this.getSatyrState() == 2;
    }

    public void setSummoning(boolean summoning) {
        this.getEntityData().set(DATA_STATE, (Object)(summoning ? (byte)2 : 0));
    }

    public boolean isShaman() {
        return (Boolean)this.getEntityData().get(DATA_SHAMAN);
    }

    public void setShaman(boolean shaman) {
        this.hasShamanTexture = shaman;
        this.getEntityData().set(DATA_SHAMAN, (Object)shaman);
        this.updateCombatAI();
    }

    @Override
    public void setPackedVariant(int packedColorsTypes) {
        this.getEntityData().set(DATA_VARIANT, (Object)packedColorsTypes);
    }

    @Override
    public int getPackedVariant() {
        return (Integer)this.getEntityData().get(DATA_VARIANT);
    }

    @Override
    public Markings getMarkings() {
        return Markings.NONE;
    }

    protected void updateCombatAI() {
        if (this.isEffectiveAi()) {
            if (this.isShaman()) {
                this.goalSelector.addGoal(1, this.summonAnimalsGoal);
                this.goalSelector.removeGoal(this.meleeAttackGoal);
            } else {
                this.goalSelector.addGoal(1, this.meleeAttackGoal);
                this.goalSelector.removeGoal(this.summonAnimalsGoal);
            }
        }
    }

    public boolean hasShamanTexture() {
        return this.hasShamanTexture;
    }

    public float getArmMovementPercent(float partialTick) {
        float time = Mth.lerp((float)partialTick, (float)this.holdingPanfluteTime, (float)(this.holdingPanfluteTime + 1));
        return Math.min(1.0f, time / 10.0f);
    }

    protected boolean wantsToDanceAround(@Nullable BlockPos pos) {
        if (null == pos) {
            return false;
        }
        BlockState target = this.level().getBlockState(pos);
        if (!IS_CAMPFIRE.test(target, true)) {
            return false;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos p;
                if (x == 0 && z == 0 || !this.cannotStandAt((p = pos.offset(x, 0, z)).below()) || !this.cannotStandAt(p) || !this.cannotStandAt(p.above())) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean cannotStandAt(BlockPos pos) {
        BlockState state1 = this.level().getBlockState(pos);
        BlockState state2 = this.level().getBlockState(pos.above());
        if (state1.blocksMotion() || !state1.getFluidState().is(Fluids.EMPTY) || state2.blocksMotion() || !state2.getFluidState().is(Fluids.EMPTY)) {
            return true;
        }
        return !this.level().getBlockState(pos.below(1)).entityCanStandOn((BlockGetter)this.level(), pos.below(1), (Entity)this);
    }

    class SummonWolfGoal
    extends SummonMobGoal<Wolf> {
        public SummonWolfGoal(int duration, int cooldown) {
            super(Satyr.this, duration, cooldown, EntityType.WOLF, 3);
        }

        @Override
        public void start() {
            super.start();
            Satyr.this.setSummoning(true);
        }

        @Override
        public void tick() {
            super.tick();
        }

        @Override
        public void stop() {
            super.stop();
            Satyr.this.setSummoning(false);
            Satyr.this.level().broadcastEntityEvent((Entity)Satyr.this, (byte)12);
        }

        @Override
        protected void onSummonMob(Wolf mobEntity) {
            mobEntity.setRemainingPersistentAngerTime(800);
            LivingEntity target = Satyr.this.getTarget();
            if (target != null) {
                mobEntity.setPersistentAngerTarget(target.getUUID());
            }
        }
    }

    class DancingGoal
    extends Goal {
        private final int obstructedTimeout = 100;
        private final int dancingTimeout;
        private Vec3 targetPos;
        private Direction targetDirection;
        protected final double moveSpeed;
        private int dancingTime;
        private int obstructedTime;

        public DancingGoal(double speedIn, int maxDancingTime) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.moveSpeed = speedIn;
            this.dancingTimeout = maxDancingTime;
            this.dancingTime = maxDancingTime;
        }

        public boolean canUse() {
            if (Satyr.this.isDancing() && Satyr.this.dancingAround != null) {
                this.targetDirection = this.getClosestDirection();
                this.targetPos = Vec3.atBottomCenterOf((Vec3i)Satyr.this.dancingAround.relative(this.targetDirection));
                return true;
            }
            return false;
        }

        public void start() {
            super.start();
            if (this.targetPos != null) {
                Satyr.this.getNavigation().moveTo(this.targetPos.x, this.targetPos.y, this.targetPos.z, this.moveSpeed);
                this.dancingTime = this.dancingTimeout;
                this.obstructedTime = 100;
            }
        }

        public boolean canContinueToUse() {
            boolean isCampfireValid = true;
            if (Satyr.this.tickCount % 15 == 1) {
                isCampfireValid = Satyr.this.wantsToDanceAround(Satyr.this.dancingAround);
            }
            return isCampfireValid && this.targetPos != null && Satyr.this.getTarget() == null && Satyr.this.hurtTime == 0;
        }

        public void tick() {
            super.tick();
            if (this.dancingTime-- > 0 && this.obstructedTime-- > 0) {
                if (this.isNearTarget(1.26)) {
                    this.updateTarget();
                    if (Satyr.this.onGround()) {
                        Satyr.this.jumpFromGround();
                    }
                    Satyr.this.getNavigation().moveTo(this.targetPos.x, this.targetPos.y, this.targetPos.z, this.moveSpeed);
                    this.obstructedTime = 100;
                }
            } else {
                this.stop();
            }
        }

        public void stop() {
            if (Satyr.this.dancingAround != null && Satyr.this.dancingAround.closerThan((Vec3i)Satyr.this.blockPosition(), 4.0)) {
                Vec3 vec = LandRandomPos.getPosAway((PathfinderMob)Satyr.this, (int)4, (int)4, (Vec3)Vec3.atBottomCenterOf((Vec3i)Satyr.this.dancingAround));
                if (vec != null) {
                    Satyr.this.getNavigation().moveTo(vec.x(), vec.y(), vec.z(), this.moveSpeed);
                }
            } else {
                Satyr.this.getNavigation().stop();
            }
            Satyr.this.dancingAround = null;
            this.targetPos = null;
            this.dancingTime = this.dancingTimeout;
            this.obstructedTime = 100;
            Satyr.this.setDancing(false);
        }

        private boolean updateTarget() {
            if (Satyr.this.dancingAround != null) {
                this.targetDirection = this.targetDirection.getClockWise();
                this.targetPos = Vec3.atBottomCenterOf((Vec3i)Satyr.this.dancingAround.relative(this.targetDirection));
                return true;
            }
            return false;
        }

        private Direction getClosestDirection() {
            Direction dClosest = Direction.NORTH;
            Vec3 curPos = Satyr.this.position();
            double dMin = 100.0;
            if (Satyr.this.dancingAround != null) {
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    BlockPos dPos = Satyr.this.dancingAround.relative(dir);
                    Vec3 dVec = Vec3.atBottomCenterOf((Vec3i)dPos);
                    double dSq = curPos.distanceToSqr(dVec);
                    if (!(dSq < dMin)) continue;
                    dClosest = dir;
                    dMin = dSq;
                }
            }
            return dClosest;
        }

        private boolean isNearTarget(double distance) {
            Vec3 position = Satyr.this.position();
            return this.targetPos != null && this.targetPos.distanceToSqr(position.x(), this.targetPos.y(), position.z()) < distance * distance;
        }
    }

    class PanicGoal
    extends net.minecraft.world.entity.ai.goal.PanicGoal {
        public PanicGoal(double speed) {
            super((PathfinderMob)Satyr.this, speed);
        }

        public boolean canUse() {
            return null == Satyr.this.getLastHurtByMob() && super.canUse();
        }

        public void tick() {
            Satyr.this.setIdleState();
            super.tick();
        }
    }

    class StartDancingGoal
    extends MoveToBlockGoal {
        protected final int chance;

        public StartDancingGoal(double speed, int searchRange, int verticalSearchRange, int chanceIn) {
            super((PathfinderMob)Satyr.this, speed, searchRange, verticalSearchRange);
            this.chance = chanceIn;
        }

        public boolean canUse() {
            return Satyr.this.getTarget() == null && Satyr.this.isIdleState() && super.canUse();
        }

        protected boolean isValidTarget(LevelReader level, BlockPos pos) {
            for (Direction d : Direction.Plane.HORIZONTAL) {
                BlockPos p = pos.relative(d, 1);
                if (!Satyr.this.wantsToDanceAround(p)) continue;
                Satyr.this.dancingAround = p;
                return true;
            }
            return false;
        }

        public double acceptedDistance() {
            return 2.1;
        }

        public void tick() {
            if (this.isReachedTarget()) {
                if (Satyr.this.dancingAround != null && Satyr.this.wantsToDanceAround(Satyr.this.dancingAround)) {
                    Satyr.this.setDancing(true);
                } else {
                    Satyr.this.dancingAround = null;
                    this.nextStartTick = this.nextStartTick(Satyr.this);
                }
            }
            super.tick();
        }

        protected int nextStartTick(PathfinderMob entity) {
            return 200 + entity.getRandom().nextInt(this.chance);
        }
    }

    class LightCampfireGoal
    extends MoveToBlockGoal {
        protected final int maxLightCampfireTime;
        protected final int chance;
        protected int lightCampfireTimer;
        protected BlockPos lightingFireAt;

        public LightCampfireGoal(double speed, int searchLength, int radius, int maxLightTime, int chanceIn) {
            super((PathfinderMob)Satyr.this, speed, searchLength, radius);
            this.lightingFireAt = null;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.maxLightCampfireTime = maxLightTime;
            this.lightCampfireTimer = 0;
            this.chance = chanceIn;
        }

        protected boolean isValidTarget(LevelReader level, BlockPos pos) {
            for (Direction d : Direction.Plane.HORIZONTAL) {
                BlockPos p = pos.relative(d, 1);
                if (!IS_CAMPFIRE.test(level.getBlockState(p), false) || Satyr.this.level().isRainingAt(p)) continue;
                this.lightingFireAt = p;
                return true;
            }
            return false;
        }

        public double acceptedDistance() {
            return 2.1;
        }

        public boolean canUse() {
            return Satyr.this.isIdleState() && Satyr.this.getTarget() == null && Satyr.this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && super.canUse();
        }

        public void start() {
            this.lightCampfireTimer = this.maxLightCampfireTime;
            super.start();
        }

        public void tick() {
            if (this.isReachedTarget() && this.lightingFireAt != null) {
                Satyr.this.getLookControl().setLookAt(Vec3.atBottomCenterOf((Vec3i)this.lightingFireAt));
                Satyr.this.setPose(Pose.CROUCHING);
                if (this.lightCampfireTimer-- <= 0) {
                    this.lightCampfire(this.lightingFireAt);
                    Satyr.this.setPose(Pose.STANDING);
                    this.lightingFireAt = null;
                } else if (Satyr.this.getRandom().nextInt(12) == 0) {
                    Satyr.this.playSound(SoundEvents.FLINTANDSTEEL_USE, 1.0f, 1.0f);
                    Satyr.this.swing(InteractionHand.MAIN_HAND, true);
                }
            }
            super.tick();
        }

        protected int nextStartTick(PathfinderMob entity) {
            return 200 + entity.getRandom().nextInt(this.chance) + this.maxLightCampfireTime;
        }

        public void stop() {
            super.stop();
            if (Satyr.this.getPose() == Pose.CROUCHING) {
                Satyr.this.setPose(Pose.STANDING);
            }
            this.lightingFireAt = null;
        }

        protected boolean lightCampfire(BlockPos pos) {
            BlockState state;
            if (EventHooks.canEntityGrief((Level)Satyr.this.level(), (Entity)Satyr.this) && IS_CAMPFIRE.test(state = Satyr.this.level().getBlockState(pos), false)) {
                Satyr.this.playSound(SoundEvents.FLINTANDSTEEL_USE, 1.0f, 1.0f);
                Satyr.this.level().setBlock(pos, (BlockState)state.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.TRUE), 2);
                Satyr.this.swing(InteractionHand.MAIN_HAND, true);
                return true;
            }
            return false;
        }
    }

    class SatyrHurtByTargetGoal
    extends HurtByTargetGoal {
        public SatyrHurtByTargetGoal() {
            super((PathfinderMob)Satyr.this, new Class[0]);
        }

        public void start() {
            super.start();
            this.alertShamans();
        }

        protected void alertShamans() {
            double range = Satyr.this.getAttributeValue(Attributes.FOLLOW_RANGE);
            LivingEntity target = Satyr.this.getLastHurtByMob();
            List shamans = Satyr.this.level().getEntitiesOfClass(Satyr.class, Satyr.this.getBoundingBox().inflate(range), e -> e.isShaman());
            for (Satyr shaman : shamans) {
                this.alertOther((Mob)shaman, target);
            }
        }
    }

    public static class GroupData
    implements SpawnGroupData {
        public final Variant variant;

        public GroupData(Variant color) {
            this.variant = color;
        }
    }
}

