/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class Sparti
extends TamableAnimal
implements RangedAttackMob {
    protected static final String KEY_SPAWN_TIME = "Spawning";
    protected static final String KEY_LIFE_TICKS = "LifeTicks";
    private static final byte SPAWN_EVENT = 11;
    protected final int maxSpawnTime = 60;
    protected int spawnTime = 0;
    protected boolean limitedLifespan;
    protected int limitedLifeTicks;
    private final EntityDimensions spawningSize = EntityDimensions.scalable((float)0.8f, (float)0.2f);

    public Sparti(EntityType<? extends Sparti> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 54.0).add(Attributes.MOVEMENT_SPEED, 0.28).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.ARMOR, 2.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new SpawningGoal());
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(3, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 16.0f, 5.0f));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.78));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, e -> e instanceof Enemy));
    }

    public void aiStep() {
        super.aiStep();
        if (this.limitedLifespan && --this.limitedLifeTicks <= 0) {
            this.limitedLifeTicks = 20;
            this.hurt(this.damageSources().starve(), 2.0f);
        }
        if (this.isSpawning() && --this.spawnTime <= 0) {
            this.refreshDimensions();
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide() && this.isSpawning()) {
            int i = Mth.floor((double)this.getX());
            int j = Mth.floor((double)(this.getY() - (double)0.2f));
            int k = Mth.floor((double)this.getZ());
            BlockPos pos = new BlockPos(i, j, k);
            BlockState blockstate = this.level().getBlockState(pos);
            if (!this.level().isEmptyBlock(pos)) {
                for (int count = 0; count < 10; ++count) {
                    this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockstate).setPos(pos), this.getX() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), this.getY() + 0.1, this.getZ() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), 4.0 * ((double)this.random.nextFloat() - 0.5), 0.6, ((double)this.random.nextFloat() - 0.5) * 4.0);
                }
            }
        }
    }

    public void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.IRON_SWORD));
        this.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData result = super.finalizeSpawn(worldIn, difficulty, spawnType, spawnDataIn);
        this.populateDefaultEquipmentSlots(this.getRandom(), difficulty);
        this.setBaby(false);
        return result;
    }

    public void setSpawning() {
        this.spawnTime = 60;
        this.refreshDimensions();
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)11);
        }
    }

    public boolean isSpawning() {
        return this.spawnTime > 0;
    }

    public float getSpawnPercent() {
        return this.spawnTime > 0 ? 1.0f - (float)this.spawnTime / 60.0f : 1.0f;
    }

    public void handleEntityEvent(byte id) {
        switch (id) {
            case 11: {
                this.setSpawning();
                break;
            }
            default: {
                super.handleEntityEvent(id);
            }
        }
    }

    public void setLimitedLife(int life) {
        this.limitedLifespan = true;
        this.limitedLifeTicks = life;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.SKELETON_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.SKELETON_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SKELETON_DEATH;
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound(SoundEvents.SKELETON_STEP, 0.15f, 1.0f);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.isTame();
    }

    protected float getStandingEyeHeight(Pose pose, EntityDimensions dimensions) {
        return this.isSpawning() ? 0.05f : dimensions.eyeHeight();
    }

    public boolean canBeLeashed() {
        return false;
    }

    public boolean canMate(Animal otherAnimal) {
        return false;
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mate) {
        return null;
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public void setOrderedToSit(boolean sitting) {
    }

    public void die(DamageSource cause) {
        this.setOwnerUUID(null);
        super.die(cause);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.limitedLifespan) {
            compound.putInt(KEY_LIFE_TICKS, this.limitedLifeTicks);
        }
        compound.putBoolean(KEY_SPAWN_TIME, this.isSpawning());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.getBoolean(KEY_SPAWN_TIME)) {
            this.setSpawning();
        }
        if (compound.contains(KEY_LIFE_TICKS)) {
            this.setLimitedLife(compound.getInt(KEY_LIFE_TICKS));
        }
    }

    public boolean canAttack(LivingEntity entity) {
        if (this.isOwnedBy(entity)) {
            return false;
        }
        return super.canAttack(entity);
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        AbstractHorse abstractHorse;
        if (target instanceof FlyingMob) {
            return false;
        }
        if (target instanceof TamableAnimal) {
            TamableAnimal tamable = (TamableAnimal)target;
            return !tamable.isTame() || tamable.getOwner() != owner;
        }
        if (target instanceof Player) {
            Player ownerPlayer;
            Player targetPlayer = (Player)target;
            if (owner instanceof Player && !(ownerPlayer = (Player)owner).canHarmPlayer(targetPlayer)) {
                return false;
            }
        }
        return !(target instanceof AbstractHorse) || !(abstractHorse = (AbstractHorse)target).isTamed();
    }

    public void performRangedAttack(LivingEntity target, float damage) {
    }

    class SpawningGoal
    extends Goal {
        public SpawningGoal() {
            this.setFlags(EnumSet.allOf(Goal.Flag.class));
        }

        public boolean canUse() {
            return Sparti.this.isSpawning();
        }

        public void tick() {
            Sparti.this.getNavigation().stop();
        }
    }
}

