/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GreekFantasy;
import greekfantasy.entity.ai.GoToWaterGoal;
import greekfantasy.entity.ai.MoveToStructureGoal;
import greekfantasy.entity.ai.TradeWithPlayerGoal;
import greekfantasy.entity.ai.TridentRangedAttackGoal;
import greekfantasy.entity.ai.WaterAnimalMoveControl;
import greekfantasy.entity.boss.Charybdis;
import greekfantasy.entity.boss.Scylla;
import greekfantasy.entity.util.TradingMob;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Triton
extends PathfinderMob
implements RangedAttackMob,
NeutralMob,
TradingMob {
    protected static final EntityDataAccessor<Boolean> SLIM = SynchedEntityData.defineId(Triton.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final String KEY_SLIM = "Slim";
    protected static final String KEY_TIMESTAMP = "GuardianTimestamp";
    protected static final TagKey<Item> TRITON_TRADE = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"triton_trade"));
    protected static final ResourceLocation TRADE_LOOT_TABLE = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"gameplay/triton_trade");
    private static final byte FINISH_TRADE_EVENT = 9;
    protected static final UniformInt ANGER_RANGE = TimeUtil.rangeOfSeconds((int)4, (int)10);
    protected int angerTime;
    protected UUID angerTarget;
    protected static final int GUARDIAN_COOLDOWN = 400;
    protected long guardianTimestamp;
    protected EntityDimensions swimmingDimensions;
    protected Component description;
    protected Player tradingPlayer = null;

    public Triton(EntityType<? extends Triton> type, Level level) {
        super(type, level);
        this.moveControl = new TritonMoveControl(this);
        this.swimmingDimensions = EntityDimensions.scalable((float)0.48f, (float)0.48f);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ARMOR, 1.0).add(Attributes.STEP_HEIGHT, 0.6);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SLIM, (Object)true);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new GoToWaterGoal(this, 1.0, false));
        this.goalSelector.addGoal(2, (Goal)new TridentRangedAttackGoal(this, 1.0, 40, 10.0f));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.1, false));
        this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Charybdis.class, 12.0f, 1.0, 1.0));
        this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Scylla.class, 12.0f, 1.0, 1.0));
        this.goalSelector.addGoal(5, new TradeWithPlayerGoal<Triton>(this, 50 + this.random.nextInt(20)));
        this.goalSelector.addGoal(6, (Goal)new FeedDolphinGoal(this, 0.9, 180, 840, 500));
        if (((Boolean)GreekFantasy.CONFIG.TRITON_SEEK_OCEAN_VILLAGE.get()).booleanValue()) {
            this.goalSelector.addGoal(6, (Goal)new MoveToStructureGoal((PathfinderMob)this, 1.0, 6, 4, 10, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"ocean_village"), BehaviorUtils::getRandomSwimmablePos));
        }
        this.goalSelector.addGoal(7, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 0.8, 120));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Dolphin.class, 6.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Guardian.class, 6.0f));
        this.goalSelector.addGoal(11, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Triton)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Drowned.class, false));
        this.targetSelector.addGoal(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected PathNavigation createNavigation(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    public void baseTick() {
        int i = this.getAirSupply();
        super.baseTick();
        if (this.isInWater()) {
            this.setAirSupply(i);
        }
    }

    public void tick() {
        super.tick();
        boolean inWater = this.isInWaterRainOrBubble();
        if (!inWater && this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().add((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f)));
            this.setYRot(this.random.nextFloat() * 360.0f);
            this.setOnGround(false);
            this.hasImpulse = true;
        }
        if (!inWater || this.getDeltaMovement().horizontalDistanceSqr() > 0.0012) {
            this.setPose(Pose.SWIMMING);
        } else if (this.getPose() == Pose.SWIMMING) {
            this.setPose(Pose.STANDING);
        }
    }

    public boolean isSlim() {
        return (Boolean)this.getEntityData().get(SLIM);
    }

    public void setSlim(boolean slim) {
        this.getEntityData().set(SLIM, (Object)slim);
    }

    protected Component getTypeName() {
        if (null == this.description) {
            Object descriptionId = this.getType().getDescriptionId();
            if (this.isSlim()) {
                descriptionId = (String)descriptionId + ".slim";
            }
            this.description = Component.translatable((String)descriptionId);
        }
        return this.description;
    }

    public boolean wantsToSpawnGuardian(long gameTime) {
        return gameTime - this.guardianTimestamp > 400L;
    }

    public void onSpawnGuardian(long gameTime) {
        this.guardianTimestamp = gameTime;
    }

    public Optional<Guardian> trySpawnGuardian(ServerLevel level) {
        BlockPos blockpos = this.blockPosition();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 10; ++i) {
            Guardian guardian;
            pos.setWithOffset((Vec3i)blockpos, level.random.nextInt(16) - 8, level.random.nextInt(8) - 4, level.random.nextInt(16) - 8);
            if (!level.getBlockState((BlockPos)pos).getFluidState().is(FluidTags.WATER) || (guardian = (Guardian)EntityType.GUARDIAN.create((Level)level)) == null) continue;
            guardian.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            if (guardian.checkSpawnRules((LevelAccessor)level, MobSpawnType.MOB_SUMMONED) && guardian.checkSpawnObstruction((LevelReader)level)) {
                level.addFreshEntityWithPassengers((Entity)guardian);
                guardian.setPersistenceRequired();
                return Optional.of(guardian);
            }
            guardian.discard();
        }
        return Optional.empty();
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_RANGE.sample(this.random));
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.angerTime = time;
    }

    public int getRemainingPersistentAngerTime() {
        return this.angerTime;
    }

    public void setPersistentAngerTarget(@Nullable UUID target) {
        this.angerTarget = target;
    }

    public UUID getPersistentAngerTarget() {
        return this.angerTarget;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        InteractionResult tradeResult = this.startTrading(this, player, hand);
        if (tradeResult != InteractionResult.PASS) {
            return tradeResult;
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public Player getTradingPlayer() {
        return this.tradingPlayer;
    }

    @Override
    public void setTradingPlayer(@Nullable Player player) {
        this.tradingPlayer = player;
    }

    @Override
    public TagKey<Item> getTradeTag() {
        return TRITON_TRADE;
    }

    @Override
    public ResourceLocation getTradeLootTable() {
        return TRADE_LOOT_TABLE;
    }

    @Override
    public void trade(PathfinderMob self, @Nullable Player player, ItemStack tradeItem) {
        TradingMob.super.trade(self, player, tradeItem);
        this.level().broadcastEntityEvent((Entity)this, (byte)9);
    }

    @Override
    public Vec3 getTradeTargetPosition(PathfinderMob self, @Nullable Player player) {
        Vec3 tradeTarget;
        if (player != null) {
            tradeTarget = player.position().add(0.0, -0.5, 0.0);
        } else {
            tradeTarget = AirAndWaterRandomPos.getPos((PathfinderMob)self, (int)4, (int)2, (int)-1, (double)self.getX(), (double)self.getZ(), (double)1.5707963705062866);
            if (null == tradeTarget) {
                tradeTarget = self.position();
            }
        }
        return tradeTarget;
    }

    public void handleEntityEvent(byte id) {
        switch (id) {
            case 9: {
                this.swing(InteractionHand.MAIN_HAND, true);
                for (int i = 0; i < 4; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getX() + 0.5 * (this.random.nextDouble() - 0.5), this.getEyeY() + 0.5 * (this.random.nextDouble() - 0.5), this.getZ() + 0.5 * (this.random.nextDouble() - 0.5), 0.0, 0.0, 0.0);
                }
                break;
            }
            default: {
                super.handleEntityEvent(id);
            }
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (super.hurt(source, amount) && source.getEntity() instanceof Enemy) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                Optional<Guardian> oGuardian;
                List guardians;
                ServerLevel serverLevel = (ServerLevel)level;
                AABB aabb = this.getBoundingBox().inflate(12.0);
                long gameTime = this.level().getGameTime();
                List nearbyTriton = this.level().getEntitiesOfClass(Triton.class, aabb);
                List<Triton> wantsToSpawnGuardian = nearbyTriton.stream().filter(m -> m.wantsToSpawnGuardian(gameTime)).limit(4L).toList();
                if (wantsToSpawnGuardian.size() >= 2 && (guardians = this.level().getEntitiesOfClass(Guardian.class, aabb)).isEmpty() && (oGuardian = this.trySpawnGuardian(serverLevel)).isPresent()) {
                    nearbyTriton.forEach(m -> m.onSpawnGuardian(gameTime));
                }
            }
            return true;
        }
        return false;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean(KEY_SLIM, this.isSlim());
        compound.putLong(KEY_TIMESTAMP, this.guardianTimestamp);
        this.addPersistentAngerSaveData(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setSlim(compound.getBoolean(KEY_SLIM));
        this.guardianTimestamp = compound.getLong(KEY_TIMESTAMP);
        this.readPersistentAngerSaveData(this.level(), compound);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType mobType, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData result = super.finalizeSpawn(worldIn, difficultyIn, mobType, spawnDataIn);
        boolean slim = this.getRandom().nextBoolean();
        this.setSlim(slim);
        this.populateDefaultEquipmentSlots(this.getRandom(), difficultyIn);
        return result;
    }

    public boolean canBeLeashed() {
        return false;
    }

    protected int decreaseAirSupply(int airSupply) {
        return airSupply;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (source.getDirectEntity() instanceof ThrownTrident && source.getEntity() != null && source.getEntity().getType() == this.getType()) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        float tridentChance = 0.31f;
        if (random.nextFloat() < tridentChance) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.TRIDENT));
        }
    }

    public boolean checkSpawnObstruction(LevelReader level) {
        return level.isUnobstructed((Entity)this);
    }

    public boolean isPushedByFluid() {
        return !this.isSwimming();
    }

    public void updateSwimming() {
        if (!this.level().isClientSide) {
            this.setSwimming(true);
        }
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        ThrownTrident throwntrident = new ThrownTrident(this.level(), (LivingEntity)this, new ItemStack((ItemLike)Items.TRIDENT));
        double d0 = target.getX() - this.getX();
        double d1 = target.getY(0.33) - throwntrident.getY();
        double d2 = target.getZ() - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        throwntrident.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
        this.playSound((SoundEvent)SoundEvents.TRIDENT_THROW.value(), 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)throwntrident);
    }

    static class TritonMoveControl
    extends WaterAnimalMoveControl {
        protected Triton triton;

        public TritonMoveControl(Triton entity) {
            super(entity);
            this.triton = entity;
        }

        @Override
        public void tick() {
            super.tick();
            Player livingentity = this.triton.getTradingPlayer();
            if (this.triton.isInWater() && livingentity != null) {
                if (livingentity.getY() > this.triton.getY() + 0.2) {
                    this.waterAnimal.setDeltaMovement(this.waterAnimal.getDeltaMovement().add(0.0, 0.02, 0.0));
                }
                if (livingentity.getY() < this.triton.getY() - 0.2) {
                    this.waterAnimal.setDeltaMovement(this.waterAnimal.getDeltaMovement().add(0.0, -0.02, 0.0));
                }
            }
        }
    }

    static class FeedDolphinGoal
    extends Goal {
        protected final PathfinderMob entity;
        protected final double speedModifier;
        protected final int interval;
        protected final int maxCooldown;
        protected final int maxDuration;
        protected int duration;
        protected int cooldown;
        protected Dolphin dolphin;

        public FeedDolphinGoal(PathfinderMob entity, double speedModifier, int maxDuration, int interval, int cooldown) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.entity = entity;
            this.speedModifier = speedModifier;
            this.maxDuration = maxDuration;
            this.interval = interval;
            this.maxCooldown = cooldown;
            this.cooldown = this.maxCooldown / 2;
        }

        public boolean canUse() {
            if (this.cooldown-- > 0) {
                return false;
            }
            if (!this.entity.isInWaterOrBubble() || this.entity.getTarget() != null && (this.entity.getOffhandItem().isEmpty() || this.entity.getOffhandItem().is(ItemTags.FISHES))) {
                return false;
            }
            this.dolphin = (Dolphin)this.entity.level().getNearestEntity(Dolphin.class, TargetingConditions.forNonCombat().selector(e -> e.getAirSupply() > 200 && e.isInWaterOrBubble()), (LivingEntity)this.entity, this.entity.getX(), this.entity.getY(), this.entity.getZ(), this.entity.getBoundingBox().inflate(10.0));
            return null != this.dolphin && this.dolphin.getTarget() == null;
        }

        public boolean canContinueToUse() {
            if (!this.entity.isInWaterOrBubble() || this.entity.getTarget() != null) {
                return false;
            }
            return null != this.dolphin && this.dolphin.isAlive() && this.dolphin.isInWaterOrBubble() && this.dolphin.getTarget() == null && !this.dolphin.gotFish();
        }

        public void start() {
            this.duration = 1;
            ItemStack fish = this.entity.getRandom().nextBoolean() ? new ItemStack((ItemLike)Items.COD) : new ItemStack((ItemLike)Items.SALMON);
            this.entity.setItemInHand(InteractionHand.OFF_HAND, fish);
        }

        public boolean requiresUpdateEveryTick() {
            return this.duration > 0 || this.cooldown > 0;
        }

        public void tick() {
            if (null == this.dolphin) {
                this.stop();
                return;
            }
            double disSq = this.entity.distanceToSqr((Entity)this.dolphin);
            if (disSq > 5.5) {
                this.entity.getNavigation().moveTo((Entity)this.dolphin, this.speedModifier);
            } else {
                this.entity.getNavigation().stop();
            }
            this.entity.lookAt((Entity)this.dolphin, 100.0f, 100.0f);
            ++this.duration;
            if (this.duration >= this.maxDuration) {
                if (disSq < 6.25) {
                    this.dolphin.playSound(SoundEvents.DOLPHIN_EAT, 1.0f, 1.0f);
                    ((ServerLevel)this.entity.level()).sendParticles((ParticleOptions)ParticleTypes.HEART, this.dolphin.getX(), this.dolphin.getY(), this.dolphin.getZ(), 2, 0.5, 0.5, 0.5, 0.0);
                }
                this.stop();
            }
        }

        public void stop() {
            if (this.entity.getOffhandItem().is(ItemTags.FISHES)) {
                this.entity.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
            }
            this.entity.getNavigation().stop();
            this.duration = 0;
            this.cooldown = this.maxCooldown + this.entity.getRandom().nextInt(this.maxCooldown) / 4;
            this.dolphin = null;
        }
    }
}

