/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;

public class Unicorn
extends AbstractHorse {
    public Unicorn(EntityType<? extends Unicorn> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractHorse.createBaseHorseAttributes().add(Attributes.ARMOR, 2.0);
    }

    public void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 16.0f, 1.1, 0.95, entity -> !entity.isDiscrete() && !this.isVehicle() && (!this.isTamed() || this.getOwnerUUID() == null || !entity.getUUID().equals(this.getOwnerUUID()))));
    }

    protected void randomizeAttributes(RandomSource random) {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)this.generateRandomMaxHealth(random));
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(this.generateRandomSpeed(random));
        this.getAttribute(Attributes.JUMP_STRENGTH).setBaseValue(this.generateRandomJumpStrength(random));
    }

    protected float generateRandomMaxHealth(RandomSource random) {
        return AbstractHorse.generateMaxHealth(arg_0 -> ((RandomSource)random).nextInt(arg_0)) + 28.0f;
    }

    protected double generateRandomJumpStrength(RandomSource random) {
        return AbstractHorse.generateJumpStrength(() -> ((RandomSource)random).nextDouble()) + (double)0.22f;
    }

    protected double generateRandomSpeed(RandomSource random) {
        return AbstractHorse.generateSpeed(() -> ((RandomSource)random).nextDouble()) + (double)0.16f;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide() && this.random.nextFloat() < 0.25f) {
            float radius = this.getBbWidth();
            this.level().addParticle((ParticleOptions)ParticleTypes.INSTANT_EFFECT, this.getX() + (this.level().random.nextDouble() - 0.5) * (double)radius, this.getY() + (this.level().random.nextDouble() - 0.5) * (double)radius * 0.75, this.getZ() + (this.level().random.nextDouble() - 0.5) * (double)radius, 0.0, 0.0, 0.0);
        }
    }

    public void die(DamageSource cause) {
        super.die(cause);
        if (cause.getEntity() instanceof LivingEntity) {
            LivingEntity killer = (LivingEntity)cause.getEntity();
            killer.addEffect(new MobEffectInstance(MobEffects.UNLUCK, 12000, 0, false, false, true));
        }
    }

    protected void actuallyHurt(DamageSource source, float amountIn) {
        super.actuallyHurt(source, source.is(DamageTypeTags.BYPASSES_ENCHANTMENTS) || source.is(DamageTypeTags.BYPASSES_ARMOR) ? amountIn : amountIn * 0.5f);
    }

    public boolean canBeAffected(MobEffectInstance effect) {
        if (((MobEffect)effect.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL) {
            MobEffectEvent.Applicable event = new MobEffectEvent.Applicable((LivingEntity)this, effect, null);
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
            NeoForge.EVENT_BUS.post((Event)event);
            return event.getResult() == MobEffectEvent.Applicable.Result.APPLY;
        }
        return super.canBeAffected(effect);
    }

    protected void playGallopSound(SoundType sound) {
        super.playGallopSound(sound);
        if (this.random.nextInt(10) == 0) {
            this.playSound(SoundEvents.HORSE_BREATHE, sound.getVolume() * 0.6f, sound.getPitch());
        }
    }

    protected SoundEvent getAmbientSound() {
        super.getAmbientSound();
        return SoundEvents.HORSE_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        super.getDeathSound();
        return SoundEvents.HORSE_DEATH;
    }

    protected SoundEvent getEatingSound() {
        return SoundEvents.HORSE_EAT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        super.getHurtSound(damageSourceIn);
        return SoundEvents.HORSE_HURT;
    }

    protected SoundEvent getAngrySound() {
        super.getAngrySound();
        return SoundEvents.HORSE_ANGRY;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (!this.isBaby()) {
            if (this.isTamed() && player.isSecondaryUseActive()) {
                this.openCustomInventoryScreen(player);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
            }
            if (this.isVehicle()) {
                return super.mobInteract(player, hand);
            }
            if (itemstack.isEmpty() && this.isTamed() || itemstack.is((Item)GFRegistry.ItemReg.GOLDEN_BRIDLE.get())) {
                this.doPlayerRide(player);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
            }
        }
        if (!itemstack.isEmpty()) {
            boolean isUsableSaddle;
            if (this.isFood(itemstack)) {
                return this.fedFood(player, itemstack);
            }
            InteractionResult actionresulttype = itemstack.interactLivingEntity(player, (LivingEntity)this, hand);
            if (actionresulttype.consumesAction()) {
                return actionresulttype;
            }
            if (!this.isTamed()) {
                this.makeMad();
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
            }
            boolean bl = isUsableSaddle = !this.isBaby() && !this.isSaddled() && itemstack.is(Items.SADDLE);
            if (this.isBodyArmorItem(itemstack) || isUsableSaddle) {
                this.openCustomInventoryScreen(player);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
            }
        }
        return super.mobInteract(player, hand);
    }

    public int getMaxTemper() {
        return 160;
    }

    public boolean canMate(Animal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        return otherAnimal instanceof Unicorn && this.canParent() && ((Unicorn)otherAnimal).canParent();
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob mate) {
        Unicorn unicorn = (Unicorn)((EntityType)GFRegistry.EntityReg.UNICORN.get()).create((Level)world);
        this.setOffspringAttributes(mate, unicorn);
        return unicorn;
    }
}

