/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.boss.Charybdis;
import greekfantasy.integration.RGCompat;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;

public class Whirl
extends WaterAnimal {
    protected static final TagKey<Item> TRIGGER = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"charybdis_trigger"));
    protected static final EntityDataAccessor<Boolean> ATTRACT_MOBS = SynchedEntityData.defineId(Whirl.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final String KEY_AFFECTS_MOBS = "AttractMobs";
    protected static final String KEY_LIFE_TICKS = "LifeTicks";
    protected boolean limitedLifespan;
    protected int limitedLifeTicks;

    public Whirl(EntityType<? extends Whirl> type, Level level) {
        super(type, level);
        this.xpReward = 5;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.05).add(Attributes.ATTACK_DAMAGE, 0.25).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.FOLLOW_RANGE, 32.0);
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ATTRACT_MOBS, (Object)Boolean.FALSE);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SwirlGoal(this));
    }

    public void aiStep() {
        super.aiStep();
        List waterMobList = this.level().getEntitiesOfClass(WaterAnimal.class, this.getBoundingBox().inflate(1.0), e -> e != this && e.isAlive() && (e.getType() == GFRegistry.EntityReg.CHARYBDIS.get() || e.getType() == GFRegistry.EntityReg.WHIRL.get()));
        if (!waterMobList.isEmpty() && this.isAlive()) {
            this.hurt(this.damageSources().starve(), this.getMaxHealth() * 2.0f);
            return;
        }
        if (this.limitedLifespan && --this.limitedLifeTicks <= 0) {
            this.limitedLifeTicks = 20;
            this.setHealth(this.getHealth() - 1.0f);
        }
        double maxItemY = this.getY() + (double)this.getBbHeight() + 0.75;
        List itemEntityList = this.level().getEntities((EntityTypeTest)EntityType.ITEM, this.getBoundingBox().inflate(1.25, 1.0, 1.25), e -> e.getY() < maxItemY);
        for (ItemEntity e2 : itemEntityList) {
            if (this.level() instanceof ServerLevel && !e2.getItem().isEmpty()) {
                Item item = e2.getItem().getItem();
                if (e2.getItem().is(TRIGGER) || item == Items.HEART_OF_THE_SEA) {
                    Charybdis.spawnCharybdis((ServerLevel)this.level(), this);
                    e2.discard();
                    return;
                }
            }
            if (e2.isInWaterOrBubble() && !e2.hasPickUpDelay()) {
                e2.discard();
            }
            if (e2.isAlive()) continue;
            this.playSound(SoundEvents.GENERIC_DRINK, 0.6f, 0.8f + this.getRandom().nextFloat() * 0.4f);
        }
    }

    public void baseTick() {
        int i = this.getAirSupply();
        super.baseTick();
        if (this.isInWater()) {
            this.setAirSupply(i);
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide() && this.tickCount % 3 == 0 && this.isInWaterOrBubble()) {
            float maxY = this.getBbHeight() * 1.65f;
            float y = 0.0f;
            float nY = 90.0f;
            float dY = maxY / nY;
            double posX = this.getX();
            double posY = this.getY();
            double posZ = this.getZ();
            float a = 0.0f;
            float nA = 28 + this.random.nextInt(4);
            float dA = (float)Math.PI * 2 / nA;
            while (y < maxY) {
                float radius = y * 0.35f;
                float cosA = Mth.cos((float)a) * radius;
                float sinA = Mth.sin((float)a) * radius;
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, posX + (double)cosA, posY + (double)y - (double)maxY * 0.4, posZ + (double)sinA, 0.0, 0.085, 0.0);
                y += dY;
                a += dA;
            }
        }
    }

    protected void doPush(Entity entityIn) {
        super.doPush(entityIn);
    }

    public double getFluidJumpThreshold() {
        return (double)this.getBbHeight() - 0.1;
    }

    public MobCategory getClassification(boolean forSpawnCount) {
        return MobCategory.WATER_CREATURE;
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    protected boolean canRide(Entity entity) {
        return false;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.is(DamageTypeTags.IS_PROJECTILE) || super.isInvulnerableTo(source);
    }

    protected void actuallyHurt(DamageSource source, float amountIn) {
        float amount = amountIn;
        if (!source.is(DamageTypeTags.BYPASSES_ENCHANTMENTS) && this.getAttractMobs()) {
            amount *= 0.25f;
        }
        super.actuallyHurt(source, amount);
    }

    public boolean isPushable() {
        return false;
    }

    protected void pushEntities() {
    }

    protected float getWaterSlowDown() {
        return 0.9f;
    }

    public void setAttractMobs(boolean attractsMobs) {
        this.getEntityData().set(ATTRACT_MOBS, (Object)attractsMobs);
    }

    public boolean getAttractMobs() {
        return (Boolean)this.getEntityData().get(ATTRACT_MOBS);
    }

    public void setLimitedLife(int life) {
        this.limitedLifespan = true;
        this.limitedLifeTicks = life;
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return this.limitedLifespan ? BuiltInLootTables.EMPTY : super.getDefaultLootTable();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean(KEY_AFFECTS_MOBS, this.getAttractMobs());
        if (this.limitedLifespan) {
            compound.putInt(KEY_LIFE_TICKS, this.limitedLifeTicks);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setAttractMobs(compound.getBoolean(KEY_AFFECTS_MOBS));
        if (compound.contains(KEY_LIFE_TICKS)) {
            this.setLimitedLife(compound.getInt(KEY_LIFE_TICKS));
        }
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.HOSTILE_SPLASH;
    }

    protected float getSoundVolume() {
        return 0.8f;
    }

    public float getVoicePitch() {
        return 0.8f + this.random.nextFloat() * 0.2f;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    private static class SwirlGoal
    extends greekfantasy.entity.ai.SwirlGoal {
        private final Whirl whirl;

        public SwirlGoal(Whirl entity) {
            super((LivingEntity)entity, 10000, 0, 9.0, 0.12f, false, e -> e.getType() != GFRegistry.EntityReg.WHIRL.get() && e.getType() != GFRegistry.EntityReg.CHARYBDIS.get() && (e instanceof LivingEntity && entity.getAttractMobs() || e instanceof ItemEntity) && (!(e instanceof Player) || !GreekFantasy.isRGLoaded() || !RGCompat.getInstance().canUseLordOfTheSea((Player)e)));
            this.whirl = entity;
        }

        @Override
        protected void onCollideWith(Entity e) {
            if (this.whirl.getAttractMobs() && e instanceof LivingEntity) {
                e.hurt(e.damageSources().mobAttack(this.entity), 1.0f);
            }
        }
    }
}

