/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.ai;

import greekfantasy.entity.util.HasCustomCooldown;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;

public class CooldownRangedAttackGoal<T extends PathfinderMob & RangedAttackMob>
extends RangedAttackGoal {
    protected final T entity;
    protected final int cooldown;

    public CooldownRangedAttackGoal(T entity, int interval, float attackDistance, int cooldown) {
        super((RangedAttackMob)entity, 1.0, interval, attackDistance);
        this.entity = entity;
        this.cooldown = cooldown;
    }

    public boolean canUse() {
        LivingEntity target = this.entity.getTarget();
        double disSq = target != null ? this.entity.distanceToSqr((Entity)target) : 0.0;
        return ((HasCustomCooldown)this.entity).hasNoCustomCooldown() && disSq > 9.0 && super.canUse();
    }

    public void start() {
        super.start();
        ((HasCustomCooldown)this.entity).setCustomCooldown(this.cooldown);
    }

    public void tick() {
        super.tick();
    }
}

