/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.ai;

import greekfantasy.entity.Triton;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.phys.Vec3;

public class DolphinTemptByTritonGoal
extends Goal {
    protected final Dolphin entity;
    protected final double speedModifier;
    protected final Ingredient ingredient;
    protected final int maxCooldown = 250;
    protected Triton triton;
    protected int cooldown;

    public DolphinTemptByTritonGoal(Dolphin dolphin, double speedModifier, Ingredient ingredient) {
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.entity = dolphin;
        this.speedModifier = speedModifier;
        this.ingredient = ingredient;
        this.cooldown = 125;
    }

    public boolean canUse() {
        if (this.cooldown-- > 0) {
            return false;
        }
        if (!this.entity.isInWaterOrBubble() || this.entity.getTarget() != null && !this.entity.gotFish() && this.entity.getAirSupply() > 200) {
            return false;
        }
        this.triton = (Triton)this.entity.level().getNearestEntity(Triton.class, TargetingConditions.forNonCombat().selector(t -> this.ingredient.test(t.getOffhandItem()) && t.isInWaterOrBubble()), (LivingEntity)this.entity, this.entity.getX(), this.entity.getY(), this.entity.getZ(), this.entity.getBoundingBox().inflate(10.0));
        return null != this.triton && this.triton.getTarget() == null;
    }

    public boolean canContinueToUse() {
        if (!this.entity.isInWaterOrBubble() || this.entity.getTarget() != null || this.entity.getNavigation().isStuck() || this.entity.getAirSupply() < 200) {
            return false;
        }
        if (!(null != this.triton && this.triton.isAlive() && this.triton.isInWaterOrBubble() && this.triton.getTarget() == null && this.ingredient.test(this.triton.getOffhandItem()))) {
            return false;
        }
        return this.entity.getRandom().nextInt(300) != 0;
    }

    public boolean requiresUpdateEveryTick() {
        return this.triton != null || this.cooldown > 0;
    }

    public void tick() {
        if (null == this.triton) {
            this.stop();
            return;
        }
        double disSq = this.entity.distanceToSqr((Entity)this.triton);
        if (disSq < 6.25) {
            this.entity.getNavigation().stop();
            double oscillatingY = Mth.cos((float)((float)this.entity.tickCount * 0.25f)) * 1.1f;
            Vec3 lookPos = this.triton.getEyePosition().add(0.0, oscillatingY, 0.0);
            this.entity.getLookControl().setLookAt(lookPos);
        } else {
            this.entity.getNavigation().moveTo(this.triton.getX(), this.triton.getEyeY(), this.triton.getZ(), this.speedModifier);
            this.entity.lookAt((Entity)this.triton, 100.0f, 100.0f);
        }
    }

    public void stop() {
        this.entity.getNavigation().stop();
        this.cooldown = 250 + this.entity.getRandom().nextInt(250) / 4;
        this.triton = null;
    }
}

