/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.ai;

import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;

public abstract class FindBlockGoal
extends Goal {
    protected final PathfinderMob creature;
    protected final int searchRadiusXZ;
    protected final int searchRadiusY;
    protected final int maxCooldown;
    protected int cooldown;
    protected BlockPos targetPos;

    public FindBlockGoal(PathfinderMob entity, int radius, int cooldown) {
        this(entity, radius, Math.max(1, radius / 2), cooldown);
    }

    public FindBlockGoal(PathfinderMob entity, int radiusXZ, int radiusY, int cooldownIn) {
        this.setFlags(EnumSet.noneOf(Goal.Flag.class));
        this.creature = entity;
        this.searchRadiusXZ = radiusXZ;
        this.searchRadiusY = radiusY;
        this.maxCooldown = cooldownIn;
        this.cooldown = 10;
    }

    public boolean canUse() {
        if (this.cooldown > 0) {
            --this.cooldown;
        } else {
            if (this.isOnBlock() || this.isNearTarget(1.2)) {
                return false;
            }
            this.targetPos = this.findNearbyBlock().orElse(null);
            return this.targetPos != null;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return false;
    }

    public void start() {
        this.cooldown = this.maxCooldown;
        this.onFoundBlock((LevelReader)this.creature.level(), this.targetPos);
    }

    public abstract boolean isTargetBlock(LevelReader var1, BlockPos var2);

    public abstract void onFoundBlock(LevelReader var1, BlockPos var2);

    protected boolean isOnBlock() {
        return this.isTargetBlock((LevelReader)this.creature.level(), this.creature.blockPosition());
    }

    protected boolean isNearTarget(double distance) {
        return this.targetPos != null && Vec3.atBottomCenterOf((Vec3i)this.targetPos).closerThan((Position)this.creature.position(), distance);
    }

    protected Optional<BlockPos> findNearbyBlock() {
        RandomSource rand = this.creature.getRandom();
        BlockPos pos1 = this.creature.blockPosition().below();
        for (int i = 0; i < 20; ++i) {
            BlockPos pos2 = pos1.offset(rand.nextInt(this.searchRadiusXZ * 2) - this.searchRadiusXZ, rand.nextInt(this.searchRadiusY * 2) - this.searchRadiusY, rand.nextInt(this.searchRadiusXZ * 2) - this.searchRadiusXZ);
            if (!this.isTargetBlock((LevelReader)this.creature.getCommandSenderWorld(), pos2)) continue;
            return Optional.of(new BlockPos(pos2.getX(), pos2.getY(), pos2.getZ()));
        }
        return Optional.empty();
    }
}

