/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class GFBegGoal
extends Goal {
    protected final Mob mob;
    protected final double range;
    protected final int interval;
    protected final Predicate<Entity> hasBegItem;
    @Nullable
    protected LivingEntity player;

    protected GFBegGoal(Mob mob, double range, int interval, Predicate<ItemStack> isBegItem) {
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.TARGET, Goal.Flag.MOVE));
        this.mob = mob;
        this.range = range;
        this.interval = interval;
        this.hasBegItem = e -> {
            LivingEntity livingEntity;
            return e instanceof LivingEntity && (isBegItem.test((livingEntity = (LivingEntity)e).getMainHandItem()) || isBegItem.test(livingEntity.getOffhandItem()));
        };
    }

    public boolean canUse() {
        if (this.mob.tickCount % this.interval == 0) {
            List list = this.mob.level().getEntitiesOfClass(Player.class, this.mob.getBoundingBox().inflate(this.range), this.hasBegItem);
            this.player = !list.isEmpty() ? (LivingEntity)list.get(0) : null;
        }
        return this.player != null;
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public void tick() {
        this.mob.getLookControl().setLookAt((Entity)this.player, (float)this.mob.getMaxHeadYRot(), (float)this.mob.getMaxHeadXRot());
        if (this.player == this.mob.getTarget()) {
            this.mob.setTarget(null);
        }
    }
}

