/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;

public class IntervalRangedAttackGoal<T extends Mob>
extends Goal {
    protected final T entity;
    protected final int maxDuration;
    protected final int maxCooldown;
    protected final int interval;
    protected final float minRangeSq;
    protected final float maxRangeSq;
    protected int progressTimer;
    protected int cooldown;

    public IntervalRangedAttackGoal(T entityIn, int interval, int count, int maxCooldownIn, float maxRange) {
        this(entityIn, interval, count, maxCooldownIn, 2.0f, maxRange);
    }

    public IntervalRangedAttackGoal(T entityIn, int interval, int count, int maxCooldownIn, float minRange, float maxRange) {
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.entity = entityIn;
        this.interval = Math.max(1, interval);
        this.maxDuration = this.interval * count;
        this.maxCooldown = maxCooldownIn;
        this.cooldown = 30;
        this.minRangeSq = minRange * minRange;
        this.maxRangeSq = maxRange * maxRange;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean canUse() {
        if (this.cooldown > 0) {
            --this.cooldown;
        } else {
            return this.entity.getTarget() != null && this.entity.getSensing().hasLineOfSight((Entity)this.entity.getTarget()) && this.isWithinRange(this.entity.getTarget());
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.progressTimer > 0 && this.cooldown <= 0 && this.entity.getTarget() != null && this.entity.getSensing().hasLineOfSight((Entity)this.entity.getTarget()) && this.isWithinRange(this.entity.getTarget());
    }

    public void start() {
        this.progressTimer = 1;
        this.entity.setAggressive(true);
    }

    public void tick() {
        LivingEntity target = this.entity.getTarget();
        this.entity.getNavigation().stop();
        this.entity.lookAt((Entity)target, 100.0f, 100.0f);
        this.entity.getLookControl().setLookAt((Entity)target, 100.0f, 100.0f);
        if (this.progressTimer % this.interval == 0) {
            ((RangedAttackMob)this.entity).performRangedAttack(target, 0.1f);
        }
        if (this.progressTimer++ >= this.maxDuration) {
            this.stop();
        }
    }

    public void stop() {
        this.entity.setAggressive(false);
        this.progressTimer = 0;
        this.cooldown = this.maxCooldown;
    }

    protected boolean isWithinRange(LivingEntity target) {
        if (target != null) {
            double disSq = this.entity.distanceToSqr((Entity)target);
            return disSq > (double)this.minRangeSq && disSq < (double)this.maxRangeSq;
        }
        return false;
    }
}

