/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.ai;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec3;

public class MoveToStructureGoal
extends RandomStrollGoal {
    protected final Holder<Structure> structure;
    protected final HolderSet<Structure> structureSet;
    protected final int rangeInSections;
    protected final int distanceXZ;
    protected final int distanceY;
    protected final RandomPosFactory randomPosFactory;
    protected StructureStart structureStart;
    protected final int maxCooldown;
    protected int cooldown;

    public MoveToStructureGoal(PathfinderMob mob, double speedModifier, int rangeInSections, int distanceXZ, int distanceY, ResourceLocation structureId, RandomPosFactory posFactory) {
        this(mob, speedModifier, rangeInSections, distanceXZ, distanceY, MoveToStructureGoal.createHolder(mob.level().registryAccess(), structureId), posFactory);
    }

    public MoveToStructureGoal(PathfinderMob mob, double speedModifier, int rangeInSections, int distanceXZ, int distanceY, Holder<Structure> structure, RandomPosFactory posFactory) {
        super(mob, speedModifier, 20);
        this.structure = structure;
        this.structureSet = HolderSet.direct((Holder[])new Holder[]{this.structure});
        this.rangeInSections = rangeInSections;
        this.distanceXZ = distanceXZ;
        this.distanceY = distanceY;
        this.randomPosFactory = posFactory;
        this.structureStart = StructureStart.INVALID_START;
        this.maxCooldown = 250 + mob.getId() % 200;
        this.cooldown = 10 + mob.getId() % 20;
    }

    public boolean canUse() {
        ServerLevel level = (ServerLevel)this.mob.level();
        BlockPos blockpos = this.mob.blockPosition();
        if (MoveToStructureGoal.isNearStructure(this.structureStart, blockpos, this.distanceXZ, this.distanceY)) {
            return false;
        }
        if (this.cooldown-- <= 0) {
            this.cooldown = this.maxCooldown;
            Pair pair = level.getChunkSource().getGenerator().findNearestMapStructure(level, this.structureSet, blockpos, this.rangeInSections, false);
            if (null == pair) {
                this.structureStart = StructureStart.INVALID_START;
                return false;
            }
            BlockPos structurePos = (BlockPos)pair.getFirst();
            SectionPos sectionPos = SectionPos.of((BlockPos)structurePos);
            int sectionX = SectionPos.blockToSectionCoord((int)structurePos.getX());
            int sectionZ = SectionPos.blockToSectionCoord((int)structurePos.getZ());
            ChunkAccess chunkAccess = level.getChunk(sectionX, sectionZ, ChunkStatus.STRUCTURE_STARTS);
            this.structureStart = Optional.ofNullable(level.structureManager().getStartForStructure(sectionPos, (Structure)((Holder)pair.getSecond()).value(), (StructureAccess)chunkAccess)).orElse(StructureStart.INVALID_START);
            if (this.structureStart != StructureStart.INVALID_START) {
                this.trigger();
            }
        }
        return this.structureStart != StructureStart.INVALID_START && super.canUse();
    }

    @Nullable
    protected Vec3 getPosition() {
        Vec3 vec = this.randomPosFactory.apply(this.mob, this.distanceXZ, this.distanceY);
        if (vec != null) {
            BlockPos pos = new BlockPos((int)vec.x, (int)vec.y, (int)vec.z);
            if (MoveToStructureGoal.isInStructure(this.structureStart, pos)) {
                return vec;
            }
            BlockPos center = this.structureStart.getBoundingBox().getCenter();
            if (!(this.mob.getNavigation() instanceof WaterBoundPathNavigation)) {
                int y = this.mob.level().getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, center.getX(), center.getZ());
                center = new BlockPos(center.getX(), y, center.getZ());
            }
            Vec3 towardsVec = DefaultRandomPos.getPosTowards((PathfinderMob)this.mob, (int)this.distanceXZ, (int)this.distanceY, (Vec3)Vec3.atBottomCenterOf((Vec3i)center), (double)1.5707963267948966);
            return towardsVec;
        }
        return null;
    }

    protected static boolean isInStructure(StructureStart start, BlockPos pos) {
        return MoveToStructureGoal.isNearStructure(start, pos, 1, 1);
    }

    protected static boolean isNearStructure(StructureStart start, BlockPos pos, int inflateXZ, int inflateY) {
        if (start == StructureStart.INVALID_START) {
            return false;
        }
        BoundingBox posBB = new BoundingBox(pos.getX() - inflateXZ, pos.getY() - inflateY, pos.getZ() - inflateXZ, pos.getX() + inflateXZ, pos.getY() + inflateY, pos.getZ() + inflateXZ);
        return start.getBoundingBox().intersects(posBB);
    }

    public static Holder<Structure> createHolder(RegistryAccess access, ResourceLocation structureId) {
        Structure csf = (Structure)access.registryOrThrow(Registries.STRUCTURE).get(structureId);
        if (null == csf) {
            throw new IllegalArgumentException("Failed to create holder for unknown structure '" + String.valueOf(structureId) + "'");
        }
        return Holder.direct((Object)csf);
    }

    public static interface RandomPosFactory {
        @Nullable
        public Vec3 apply(PathfinderMob var1, int var2, int var3);
    }
}

