/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.ai;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ShootFireGoal
extends Goal {
    private final Mob entity;
    private final int maxCooldown;
    private final int maxDuration;
    private final double range;
    private int progressTimer;
    private int cooldown;

    protected ShootFireGoal(Mob entity, int duration, int maxCooldown, double range) {
        this.setFlags(EnumSet.allOf(Goal.Flag.class));
        this.entity = entity;
        this.maxDuration = duration;
        this.range = range;
        this.maxCooldown = maxCooldown;
        this.cooldown = 30;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean canUse() {
        if (this.cooldown > 0) {
            --this.cooldown;
        } else {
            return this.entity.getTarget() != null && this.entity.distanceToSqr((Entity)this.entity.getTarget()) < this.range * this.range && this.entity.getSensing().hasLineOfSight((Entity)this.entity.getTarget());
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.entity.getTarget() != null && this.entity.getSensing().hasLineOfSight((Entity)this.entity.getTarget()) && this.entity.distanceToSqr((Entity)this.entity.getTarget()) < this.range * this.range;
    }

    public void start() {
        this.progressTimer = 1;
        this.entity.playSound(SoundEvents.CREEPER_PRIMED, 1.0f, 1.2f);
    }

    public void tick() {
        if (null == this.entity.getTarget()) {
            this.stop();
            return;
        }
        if (this.progressTimer > 0 && this.progressTimer < this.maxDuration) {
            ++this.progressTimer;
            this.entity.getNavigation().stop();
            this.entity.lookAt((Entity)this.entity.getTarget(), 100.0f, 100.0f);
            this.entity.getLookControl().setLookAt((Entity)this.entity.getTarget(), 100.0f, 100.0f);
            if (this.progressTimer > 18 && this.progressTimer % 7 == 0) {
                Vec3 entityPos = this.entity.getEyePosition();
                this.setFireToIntersectingEntities(entityPos, this.entity.getTarget().position(), 0.65, 5);
                this.entity.playSound(SoundEvents.FIRECHARGE_USE, 1.0f, 1.0f);
            }
        } else {
            this.stop();
        }
    }

    public void stop() {
        this.progressTimer = 0;
        this.cooldown = this.maxCooldown;
    }

    private void setFireToIntersectingEntities(Vec3 startPos, Vec3 endPos, double radius, int fireTime) {
        Vec3 vecDifference = endPos.subtract(startPos);
        int randFireTime = fireTime + this.entity.getRandom().nextInt(5) - 2;
        double l = vecDifference.length();
        double stepSize = radius * 0.75;
        for (double i = 0.1; i < l; i += stepSize) {
            Vec3 scaled = startPos.add(vecDifference.scale(i));
            AABB aabb = new AABB(scaled.x - radius, scaled.y - radius, scaled.z - radius, scaled.x + radius, scaled.y + radius, scaled.z + radius);
            for (Entity e : this.entity.level().getEntities((Entity)this.entity, aabb)) {
                e.igniteForSeconds((float)randFireTime);
            }
        }
    }
}

