/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;

public class SummonMobGoal<T extends Mob>
extends Goal {
    protected final PathfinderMob summoner;
    protected final EntityType<? extends T> mobEntityType;
    protected final int maxDuration;
    protected final int maxCooldown;
    protected final int count;
    protected int progressTimer;
    protected int cooldown;

    public SummonMobGoal(PathfinderMob entity, int duration, int cooldown, EntityType<? extends T> entityType) {
        this(entity, duration, cooldown, entityType, 1);
    }

    public SummonMobGoal(PathfinderMob entity, int duration, int cooldown, EntityType<? extends T> entityType, int mobCount) {
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        this.summoner = entity;
        this.maxDuration = duration;
        this.maxCooldown = cooldown;
        this.mobEntityType = entityType;
        this.count = mobCount;
        this.cooldown = 100;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean canUse() {
        if (this.cooldown > 0) {
            --this.cooldown;
        } else {
            return this.summoner.getTarget() != null;
        }
        return false;
    }

    public void start() {
        this.progressTimer = 1;
    }

    public boolean canContinueToUse() {
        return this.progressTimer > 0 && this.canUse();
    }

    public void tick() {
        super.tick();
        this.summoner.getNavigation().stop();
        this.summoner.getLookControl().setLookAt((Entity)this.summoner.getTarget(), 100.0f, 100.0f);
        if (this.progressTimer++ > this.maxDuration) {
            for (int i = 0; i < this.count; ++i) {
                T mobEntity = this.summonMob();
                this.onSummonMob(mobEntity);
            }
            this.stop();
        }
    }

    public void stop() {
        this.progressTimer = 0;
        this.cooldown = this.maxCooldown;
    }

    protected T summonMob() {
        Mob mobEntity = (Mob)this.mobEntityType.create(this.summoner.level());
        mobEntity.copyPosition((Entity)this.summoner);
        mobEntity.setLastHurtByMob(this.summoner.getLastHurtByMob());
        mobEntity.setTarget(this.summoner.getTarget());
        this.summoner.level().addFreshEntity((Entity)mobEntity);
        return (T)mobEntity;
    }

    protected void onSummonMob(T mobEntity) {
    }
}

