/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.ai;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.phys.Vec3;

public abstract class SwirlGoal
extends Goal {
    protected static final Predicate<Entity> CAN_TARGET = e -> {
        Player p;
        return !(!e.isInWaterOrBubble() || e.isSpectator() || e instanceof Player && (p = (Player)e).isCreative() || !(e instanceof LivingEntity) && !(e instanceof Boat) && !(e instanceof ItemEntity));
    };
    protected final LivingEntity entity;
    protected final int duration;
    protected final int cooldown;
    protected final double range;
    protected final float strength;
    protected final boolean breakBoats;
    protected final Predicate<Entity> targetPredicate;
    protected List<Entity> trackedEntities = new ArrayList<Entity>();
    protected int progressTime;
    protected int cooldownTime;

    public SwirlGoal(LivingEntity entity, int duration, int cooldown, double range, float deltaAngle, boolean breakBoats, Predicate<Entity> targetPredicate) {
        this.setFlags(EnumSet.noneOf(Goal.Flag.class));
        this.entity = entity;
        this.duration = duration;
        this.cooldown = cooldown;
        this.range = range;
        this.strength = deltaAngle;
        this.cooldownTime = 60;
        this.breakBoats = breakBoats;
        this.targetPredicate = CAN_TARGET.and(targetPredicate);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean canUse() {
        if (this.cooldownTime > 0) {
            --this.cooldownTime;
        } else {
            this.trackedEntities = SwirlGoal.getEntitiesInRange(this.entity, this.range, this.targetPredicate);
            return this.trackedEntities.size() > 0;
        }
        return false;
    }

    public void start() {
        this.progressTime = 1;
    }

    public boolean canContinueToUse() {
        if (this.entity.tickCount % 11 == 0) {
            this.trackedEntities = SwirlGoal.getEntitiesInRange(this.entity, this.range, this.targetPredicate);
        }
        return this.progressTime > 0 && this.trackedEntities.size() > 0;
    }

    public void tick() {
        if (this.progressTime++ >= this.duration) {
            this.stop();
            return;
        }
        for (Entity e : this.trackedEntities) {
            if (e instanceof Boat) {
                if (!this.breakBoats || this.entity.getRandom().nextInt(8) != 0) continue;
                e.hurt(e.damageSources().mobAttack(this.entity), 3.0f);
                continue;
            }
            double dx = this.entity.getX() - e.position().x;
            double dz = this.entity.getZ() - e.position().z;
            double horizDisSq = dx * dx + dz * dz;
            if (this.entity.getBoundingBox().inflate(1.0).intersects(e.getBoundingBox())) {
                this.onCollideWith(e);
                continue;
            }
            SwirlGoal.swirlEntity((Entity)this.entity, this.range, this.strength, e, horizDisSq);
        }
    }

    public void stop() {
        if (this.cooldown > 0) {
            this.progressTime = 0;
            this.cooldownTime = this.cooldown;
            this.trackedEntities.clear();
        } else {
            this.progressTime = 1;
        }
    }

    protected abstract void onCollideWith(Entity var1);

    protected static List<Entity> getEntitiesInRange(LivingEntity entity, double range, Predicate<Entity> predicate) {
        return entity.level().getEntities((Entity)entity, entity.getBoundingBox().inflate(range, range / 2.0, range), predicate);
    }

    protected static void swirlEntity(Entity entity, double range, float deltaAngle, Entity target, double disSq) {
        double motion = 0.062 + 0.11 * (1.0 - disSq / (range * range));
        Vec3 normalVec = entity.position().multiply(1.0, 0.0, 1.0).subtract(target.position().multiply(1.0, 0.0, 1.0)).normalize();
        Vec3 rotatedVec = normalVec.yRot(1.5707964f - deltaAngle).scale(motion);
        Vec3 motionVec = target.getDeltaMovement().add(normalVec.scale(0.028)).add(rotatedVec).multiply(0.65, 1.0, 0.65);
        target.setDeltaMovement(motionVec);
        target.push(0.0, 0.0068, 0.0);
        target.hurtMarked = true;
        target.hasImpulse = true;
    }
}

