/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.ai;

import greekfantasy.entity.util.TradingMob;
import java.util.EnumSet;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;

public class TradeWithPlayerGoal<T extends PathfinderMob>
extends Goal {
    protected final T entity;
    protected final int maxThinkingTime;
    protected int thinkingTime;

    public TradeWithPlayerGoal(T entity, int maxThinkingTimeIn) {
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.entity = entity;
        this.maxThinkingTime = maxThinkingTimeIn;
        this.thinkingTime = 0;
    }

    public boolean canUse() {
        return !this.entity.isAggressive() && !this.entity.getOffhandItem().isEmpty() && this.entity.getOffhandItem().is(((TradingMob)this.entity).getTradeTag());
    }

    public boolean canContinueToUse() {
        return this.thinkingTime > 0 && this.thinkingTime <= this.maxThinkingTime && this.canUse();
    }

    public void start() {
        this.thinkingTime = 1;
    }

    public boolean requiresUpdateEveryTick() {
        return this.thinkingTime > 0;
    }

    public void tick() {
        this.entity.getNavigation().stop();
        this.entity.getLookControl().setLookAt(this.entity.getEyePosition(1.0f).add(0.0, -0.25, 0.0));
        if (this.thinkingTime++ >= this.maxThinkingTime) {
            ((TradingMob)this.entity).trade((PathfinderMob)this.entity, ((TradingMob)this.entity).getTradingPlayer(), this.entity.getOffhandItem());
            this.stop();
        }
    }

    public void stop() {
        this.thinkingTime = 0;
    }
}

