/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.ai;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;

public class WaterAnimalMoveControl
extends MoveControl {
    protected final PathfinderMob waterAnimal;

    public WaterAnimalMoveControl(PathfinderMob entity) {
        super((Mob)entity);
        this.waterAnimal = entity;
    }

    public void tick() {
        LivingEntity livingentity = this.waterAnimal.getTarget();
        if (this.waterAnimal.isInWater()) {
            if (livingentity != null && livingentity.getY() > this.waterAnimal.getY()) {
                this.waterAnimal.setDeltaMovement(this.waterAnimal.getDeltaMovement().add(0.0, 0.02, 0.0));
            }
            if (this.operation != MoveControl.Operation.MOVE_TO || this.waterAnimal.getNavigation().isDone()) {
                this.waterAnimal.setSpeed(0.0f);
                this.waterAnimal.setDeltaMovement(this.waterAnimal.getDeltaMovement().multiply(1.0, 0.5, 1.0));
                return;
            }
            double d0 = this.wantedX - this.waterAnimal.getX();
            double d1 = this.wantedY - this.waterAnimal.getY();
            double d2 = this.wantedZ - this.waterAnimal.getZ();
            double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
            d1 /= d3;
            float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
            this.waterAnimal.setYRot(this.rotlerp(this.waterAnimal.getYRot(), f, 90.0f));
            this.waterAnimal.yBodyRot = this.waterAnimal.getYRot();
            float f1 = (float)(this.speedModifier * this.waterAnimal.getAttributeValue(Attributes.MOVEMENT_SPEED));
            float f2 = Mth.lerp((float)0.125f, (float)this.waterAnimal.getSpeed(), (float)f1);
            this.waterAnimal.setSpeed(f2);
            this.waterAnimal.setDeltaMovement(this.waterAnimal.getDeltaMovement().add((double)f2 * d0 * 0.03, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.03));
        } else {
            if (!this.waterAnimal.onGround()) {
                this.waterAnimal.setDeltaMovement(this.waterAnimal.getDeltaMovement().add(0.0, -0.008, 0.0));
            }
            super.tick();
        }
    }
}

