/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.boss;

import greekfantasy.GreekFantasy;
import greekfantasy.entity.misc.WebBall;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class Arachne
extends Monster
implements RangedAttackMob {
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);

    public Arachne(EntityType<? extends Arachne> type, Level level) {
        super(type, level);
        this.setPersistenceRequired();
        this.xpReward = 50;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 80.0).add(Attributes.MOVEMENT_SPEED, 0.285).add(Attributes.ATTACK_DAMAGE, 4.5).add(Attributes.KNOCKBACK_RESISTANCE, 0.5).add(Attributes.ARMOR, 2.0).add(Attributes.FOLLOW_RANGE, 20.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new ArachneRangedAttackGoal(1.0, 75, 15.0f));
        this.goalSelector.addGoal(4, (Goal)new ArachneAttackGoal(1.0, true));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public void aiStep() {
        super.aiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.SPIDER_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.SPIDER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SPIDER_DEATH;
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound(SoundEvents.SPIDER_STEP, 0.15f, 1.0f);
    }

    public void makeStuckInBlock(BlockState state, Vec3 motionMultiplierIn) {
        if (!state.is(Blocks.COBWEB)) {
            super.makeStuckInBlock(state, motionMultiplierIn);
        }
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        WebBall web = WebBall.create(this.level(), (LivingEntity)this);
        web.setWebType(this.getRandom().nextBoolean(), true, false);
        web.setPos(this.getX() - (double)(this.getBbWidth() + 1.0f) * 0.5 * (double)Mth.sin((float)(this.yBodyRot * ((float)Math.PI / 180))), this.getEyeY() - 0.1, this.getZ() + (double)(this.getBbWidth() + 1.0f) * 0.5 * (double)Mth.cos((float)(this.yBodyRot * ((float)Math.PI / 180))));
        double dx = target.getX() - web.getX();
        double dy = target.getY(0.67) - web.getY();
        double dz = target.getZ() - web.getZ();
        double dis = Math.sqrt(dx * dx + dz * dz);
        web.shoot(dx, dy + dis * (double)0.2f, dz, 1.14f, 14 - this.level().getDifficulty().getId() * 4);
        this.playSound(SoundEvents.LLAMA_SPIT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)web);
    }

    public boolean canBeAffected(MobEffectInstance potioneffectIn) {
        return potioneffectIn.getEffect().value() != MobEffects.POISON && super.canBeAffected(potioneffectIn);
    }

    public boolean canChangeDimensions(Level from, Level to) {
        return false;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
        this.bossInfo.setName(this.hasCustomName() ? this.getCustomName() : this.getDisplayName());
        this.bossInfo.setVisible(GreekFantasy.CONFIG.showArachneBossBar());
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    class ArachneRangedAttackGoal
    extends RangedAttackGoal {
        public ArachneRangedAttackGoal(double moveSpeed, int attackInterval, float attackDistance) {
            super((RangedAttackMob)Arachne.this, moveSpeed, attackInterval, attackDistance);
        }

        public boolean canUse() {
            LivingEntity target = Arachne.this.getTarget();
            return target != null && Arachne.this.distanceToSqr((Entity)target) > 9.0 && super.canUse();
        }
    }

    class ArachneAttackGoal
    extends MeleeAttackGoal {
        public ArachneAttackGoal(double moveSpeed, boolean useLongMemory) {
            super((PathfinderMob)Arachne.this, moveSpeed, useLongMemory);
        }

        public boolean canUse() {
            LivingEntity target = Arachne.this.getTarget();
            return target != null && Arachne.this.distanceToSqr((Entity)target) < 9.0 && super.canUse();
        }
    }
}

