/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.boss;

import greekfantasy.GFRegistry;
import greekfantasy.entity.ai.CooldownMeleeAttackGoal;
import greekfantasy.entity.ai.ShootFireGoal;
import greekfantasy.entity.util.HasCustomCooldown;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class BronzeBull
extends Monster
implements HasCustomCooldown {
    private static final EntityDataAccessor<Byte> STATE = SynchedEntityData.defineId(BronzeBull.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final String KEY_STATE = "BullState";
    private static final String KEY_SPAWN = "SpawnTime";
    private static final byte NONE = 0;
    private static final byte SPAWNING = 1;
    private static final byte FIRING = 2;
    private static final byte GORING = 3;
    private static final byte SPAWN_EVENT = 8;
    private static final byte FIRING_EVENT = 9;
    private static final byte GORING_EVENT = 10;
    private static final double FIRE_RANGE = 10.0;
    private static final int MAX_SPAWN_TIME = 90;
    private static final int MAX_FIRING_TIME = 89;
    private static final int MAX_GORING_TIME = 130;
    private static final int MELEE_COOLDOWN = 50;
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
    private int firingTime;
    private int spawnTime;
    private int goringTime0;
    private int goringTime;
    private int attackCooldown;

    public BronzeBull(EntityType<? extends BronzeBull> type, Level level) {
        super(type, level);
        this.xpReward = 50;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 230.0).add(Attributes.MOVEMENT_SPEED, 0.28).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.ATTACK_DAMAGE, 9.0).add(Attributes.ATTACK_KNOCKBACK, 1.125).add(Attributes.ARMOR, 12.0).add(Attributes.STEP_HEIGHT, (double)0.6f);
    }

    public static BronzeBull spawnBronzeBull(Level level, BlockPos pos, float yaw) {
        return BronzeBull.spawnBronzeBull(level, Vec3.atBottomCenterOf((Vec3i)pos), yaw);
    }

    public static BronzeBull spawnBronzeBull(Level level, Vec3 pos, float yaw) {
        BronzeBull entity = (BronzeBull)((EntityType)GFRegistry.EntityReg.BRONZE_BULL.get()).create(level);
        entity.moveTo(pos.x, pos.y, pos.z, yaw, 0.0f);
        entity.yBodyRot = yaw;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.addFreshEntityWithPassengers((Entity)entity);
            entity.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(BlockPos.containing((Position)pos)), MobSpawnType.MOB_SUMMONED, null);
            for (ServerPlayer player : level.getEntitiesOfClass(ServerPlayer.class, entity.getBoundingBox().inflate(25.0))) {
                CriteriaTriggers.SUMMONED_ENTITY.trigger(player, (Entity)entity);
            }
        }
        entity.setSpawning(true);
        entity.playSound(SoundEvents.WITHER_SPAWN, 1.2f, 1.0f);
        return entity;
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new BronzeBullSpawningGoal());
        this.goalSelector.addGoal(1, (Goal)new BronzeBullFireAttackGoal(89, 150));
        this.goalSelector.addGoal(3, (Goal)new BronzeBullMeleeAttackGoal(this, 1.25, false));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    public void aiStep() {
        super.aiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
        if (!this.level().isClientSide()) {
            this.tickCustomCooldown();
        }
        if ((this.isSpawning() || this.spawnTime > 0) && --this.spawnTime <= 0) {
            this.setSpawning(false);
        }
        this.goringTime0 = this.goringTime;
        if ((this.isGoring() || this.goringTime > 0) && --this.goringTime <= 0) {
            this.setGoring(false);
        }
        if ((this.isFiring() || this.firingTime > 0) && --this.firingTime <= 0) {
            this.setFiring(false);
        }
        if (this.isEffectiveAi() && (this.isFiring() || this.isGoring()) && this.getTarget() == null) {
            this.setFiring(false);
            this.setGoring(false);
        }
        if (this.level().isClientSide() && this.isFiring()) {
            this.spawnFireParticles();
        }
        if (this.level().isClientSide()) {
            double x = this.getX();
            double y = this.getY() + 1.25;
            double z = this.getZ();
            double motion = 0.06;
            double radius = (double)this.getBbWidth() * 1.15;
            this.level().addParticle((ParticleOptions)ParticleTypes.LAVA, x + (this.level().random.nextDouble() - 0.5) * radius, y + (this.level().random.nextDouble() - 0.5) * radius, z + (this.level().random.nextDouble() - 0.5) * radius, (this.level().random.nextDouble() - 0.5) * 0.06, (this.level().random.nextDouble() - 0.5) * 0.07, (this.level().random.nextDouble() - 0.5) * 0.06);
        }
    }

    public boolean doHurtTarget(Entity entity) {
        if (!this.isGoring()) {
            this.setGoring(true);
        }
        if (super.doHurtTarget(entity)) {
            double knockbackFactor = 0.82;
            Vec3 myPos = this.position();
            Vec3 ePos = entity.position();
            double dX = Math.signum(ePos.x - myPos.x) * 0.82;
            double dZ = Math.signum(ePos.z - myPos.z) * 0.82;
            entity.push(dX, 0.41, dZ);
            entity.hurtMarked = true;
            this.playSound(SoundEvents.IRON_GOLEM_ATTACK, 1.0f, 0.6f + this.random.nextFloat() * 0.2f);
            return true;
        }
        return false;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData result = super.finalizeSpawn(level, difficulty, spawnType, spawnDataIn);
        this.setSpawning(true);
        return result;
    }

    protected float getJumpPower() {
        return 0.42f * this.getBlockJumpFactor();
    }

    public boolean isPushable() {
        return false;
    }

    public void pushEntities() {
    }

    public boolean canChangeDimensions(Level from, Level to) {
        return false;
    }

    public boolean removeWhenFarAway(double disToPlayer) {
        return false;
    }

    protected boolean canRide(Entity entityIn) {
        return false;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return this.isSpawning() || source.is(DamageTypeTags.WITCH_RESISTANT_TO) || source.is(DamageTypeTags.IS_DROWNING) || source == this.damageSources().inWall() || source.is(DamageTypeTags.WITHER_IMMUNE_TO) || source.getDirectEntity() instanceof AbstractArrow || super.isInvulnerableTo(source);
    }

    public int getAmbientSoundInterval() {
        return 280;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.BLAZE_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.IRON_GOLEM_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.IRON_GOLEM_DEATH;
    }

    protected float getSoundVolume() {
        return 1.8f;
    }

    public float getVoicePitch() {
        return 0.6f + this.random.nextFloat() * 0.25f;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte(KEY_STATE, this.getState());
        compound.putInt(KEY_SPAWN, this.spawnTime);
        this.saveCustomCooldown(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setState(compound.getByte(KEY_STATE));
        this.spawnTime = compound.getInt(KEY_SPAWN);
        this.readCustomCooldown(compound);
    }

    public void spawnFireParticles() {
        if (!this.level().isClientSide()) {
            return;
        }
        Vec3 lookVec = this.getLookAngle();
        Vec3 pos = this.getEyePosition(1.0f).subtract(0.0, 0.25, 0.0);
        double motion = 0.06;
        double radius = 0.75;
        for (int i = 0; i < 5; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, pos.x + (this.level().random.nextDouble() - 0.5) * 0.75, pos.y + (this.level().random.nextDouble() - 0.5) * 0.75, pos.z + (this.level().random.nextDouble() - 0.5) * 0.75, lookVec.x * 0.06 * 10.0, lookVec.y * 0.06 * 0.5, lookVec.z * 0.06 * 10.0);
        }
    }

    public byte getState() {
        return (Byte)this.getEntityData().get(STATE);
    }

    public void setState(byte state) {
        this.getEntityData().set(STATE, (Object)state);
    }

    public boolean isNoneState() {
        return this.getState() == 0;
    }

    public boolean isSpawning() {
        return this.spawnTime > 0 || this.getState() == 1;
    }

    public boolean isFiring() {
        return this.getState() == 2 || this.firingTime > 0;
    }

    public boolean isGoring() {
        return this.getState() == 3 || this.goringTime > 0;
    }

    public void setFiring(boolean firing) {
        this.firingTime = firing ? 89 : 0;
        this.setState(firing ? (byte)2 : 0);
        if (firing && !this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)9);
        }
    }

    public void setGoring(boolean goring) {
        this.goringTime = goring ? 130 : 0;
        this.setState(goring ? (byte)3 : 0);
        if (goring && !this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)10);
            this.destroyIntersectingBlocks(1.45f + 0.75f * this.random.nextFloat(), 2.0);
        }
    }

    public void setSpawning(boolean spawning) {
        this.spawnTime = spawning ? 90 : 0;
        this.setState(spawning ? (byte)1 : 0);
        if (spawning && !this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)8);
        }
    }

    public void handleEntityEvent(byte id) {
        switch (id) {
            case 8: {
                this.setSpawning(true);
                break;
            }
            case 9: {
                this.setFiring(true);
                break;
            }
            case 10: {
                this.setGoring(true);
                break;
            }
            default: {
                super.handleEntityEvent(id);
            }
        }
    }

    public float getSpawnPercent(float partialTick) {
        return Math.max(0.0f, (float)this.spawnTime - partialTick) / 90.0f;
    }

    public float getFiringPercent(float partialTick) {
        return Math.max(0.0f, (float)this.firingTime - partialTick) / 89.0f;
    }

    public float getGoringPercent(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.goringTime0, (float)this.goringTime) / 130.0f;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    private void destroyIntersectingBlocks(float maxHardness, double offset) {
        if (!this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            return;
        }
        Vec3 facing = Vec3.directionFromRotation((Vec2)this.getRotationVector());
        AABB box = this.getBoundingBox().move(facing.normalize().scale(offset));
        BlockPos.betweenClosedStream((AABB)box).forEach(p -> {
            BlockState b = this.level().getBlockState(p);
            if ((b.canOcclude() || b.blocksMotion()) && b.getDestroySpeed((BlockGetter)this.level(), p) < maxHardness && !b.is(BlockTags.WITHER_IMMUNE)) {
                this.level().destroyBlock(p, true);
            }
        });
    }

    @Override
    public void setCustomCooldown(int cooldown) {
        this.attackCooldown = cooldown;
    }

    @Override
    public int getCustomCooldown() {
        return this.attackCooldown;
    }

    class BronzeBullSpawningGoal
    extends Goal {
        public BronzeBullSpawningGoal() {
            this.setFlags(EnumSet.allOf(Goal.Flag.class));
        }

        public boolean canUse() {
            return BronzeBull.this.isSpawning();
        }

        public void tick() {
            BronzeBull.this.getNavigation().stop();
            BronzeBull.this.getLookControl().setLookAt(BronzeBull.this.getX(), BronzeBull.this.getY(), BronzeBull.this.getZ());
            BronzeBull.this.setRot(0.0f, 0.0f);
        }
    }

    class BronzeBullFireAttackGoal
    extends ShootFireGoal {
        protected BronzeBullFireAttackGoal(int fireTimeIn, int maxCooldownIn) {
            super((Mob)BronzeBull.this, fireTimeIn, maxCooldownIn, 10.0);
        }

        @Override
        public boolean canUse() {
            return super.canUse() && BronzeBull.this.isNoneState();
        }

        @Override
        public boolean canContinueToUse() {
            return super.canContinueToUse() && BronzeBull.this.isFiring();
        }

        @Override
        public void start() {
            super.start();
            BronzeBull.this.setFiring(true);
        }

        @Override
        public void stop() {
            super.stop();
            BronzeBull.this.setFiring(false);
        }
    }

    class BronzeBullMeleeAttackGoal
    extends CooldownMeleeAttackGoal<BronzeBull> {
        public BronzeBullMeleeAttackGoal(BronzeBull this$0, double speedIn, boolean useLongMemory) {
            super(this$0, speedIn, useLongMemory, 50);
        }
    }
}

